/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.SolarPanelMenu;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.ExtractOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class SolarPanelBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.PUSH, ConstantComponents.SIDE_CONFIG_ENERGY));

    public SolarPanelBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 1);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new SolarPanelMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new ExtractOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public EnergyContainerMachineBlockEntity.ChargeSlotType getChargeSlotType() {
        return EnergyContainerMachineBlockEntity.ChargeSlotType.POWER_ITEM;
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        if (this.canFunction()) {
            this.distributeToChargeSlots();
            if (this.isDay()) {
                this.generateEnergy(PlanetApi.API.getSolarPower((class_1937)level));
            }
        }
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushEnergyNearby(this, pos, this.getEnergyStorage().maxExtract(), sideConfig.get(0), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[0];
    }

    public boolean isDay() {
        if (this.level().method_8532() % 24000L > 12000L) {
            return false;
        }
        return this.level().method_8311(this.method_11016().method_10084());
    }

    public void generateEnergy(long generationRate) {
        this.energyContainer.internalInsert(generationRate, false);
    }

    public void distributeToChargeSlots() {
        class_1799 stack = this.method_5438(0);
        if (stack.method_7960()) {
            return;
        }
        if (!EnergyContainer.holdsEnergy((class_1799)stack)) {
            return;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        EnergyApi.moveEnergy((class_2586)this, null, (ItemStackHolder)holder, (long)this.getEnergyStorage().maxExtract(), (boolean)false);
        if (holder.isDirty()) {
            this.method_5447(0, holder.getStack());
        }
    }
}

