/*
 * Decompiled with CFR 0.152.
 */
package com.ferriarnus.liquidburner.mixin;

import com.ferriarnus.liquidburner.BlazeTank;
import com.ferriarnus.liquidburner.recipe.FluidContainer;
import com.ferriarnus.liquidburner.recipe.LiquidBurning;
import com.ferriarnus.liquidburner.recipe.RecipeRegistry;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlazeBurnerBlockEntity.class})
public abstract class BlazeBurnerTileEntityMixin
extends SmartBlockEntity
implements SidedStorageBlockEntity {
    @Unique
    BlazeTank tank = new BlazeTank(81000, fluidStack -> this.recipeFluids(), this.getFluidStackPredicate());
    @Shadow(remap=false)
    protected BlazeBurnerBlockEntity.FuelType activeFuel;
    @Shadow(remap=false)
    protected int remainingBurnTime;
    @Unique
    private LiquidBurning lb;

    public BlazeBurnerTileEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Unique
    public boolean recipeFluids() {
        if (this.tank.getFluidAmount() < this.tank.getCapacity()) {
            return false;
        }
        FluidContainer container = new FluidContainer(this.tank.getFluid());
        if (this.field_11863 == null) {
            return false;
        }
        Optional recipe = this.field_11863.method_8433().method_8132(RecipeRegistry.LIQUIDBURNING, (class_1263)container, this.field_11863);
        if (recipe.isPresent()) {
            BlazeBurnerBlockEntity.FuelType newFuel;
            int newBurnTime;
            this.lb = (LiquidBurning)recipe.get();
            if (this.lb.getSuperheattime() > 0) {
                newBurnTime = this.lb.getSuperheattime();
                newFuel = BlazeBurnerBlockEntity.FuelType.SPECIAL;
            } else {
                newBurnTime = this.lb.getBurntime();
                newFuel = BlazeBurnerBlockEntity.FuelType.NORMAL;
                this.lb = null;
            }
            if (newFuel.ordinal() < this.activeFuel.ordinal()) {
                return true;
            }
            if (this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL && this.remainingBurnTime > 20) {
                return true;
            }
            if (newFuel == this.activeFuel) {
                if (this.remainingBurnTime + newBurnTime > 10000) {
                    return false;
                }
                newBurnTime = class_3532.method_15340((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
            }
            this.activeFuel = newFuel;
            this.remainingBurnTime = newBurnTime;
            if (this.field_11863.field_9236) {
                this.spawnParticleBurst(this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL);
            } else {
                BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
                this.playSound();
                this.updateBlockState();
                if (prev != this.getHeatLevelFromBlock()) {
                    this.field_11863.method_8396((class_1657)null, this.method_11016(), class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.method_43057() * 0.125f, 1.15f - this.field_11863.field_9229.method_43057() * 0.25f);
                }
            }
            this.tank.setFluid(FluidStack.EMPTY);
            return true;
        }
        this.lb = null;
        return false;
    }

    @Unique
    private Predicate<FluidStack> getFluidStackPredicate() {
        if (this.field_11863 == null) {
            return fluidStack -> true;
        }
        return fluid -> this.field_11863.method_8433().method_30027(RecipeRegistry.LIQUIDBURNING).stream().anyMatch(r -> r.getFluid().isFluidEqual(fluid));
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=5000)}, remap=false)
    public int liquidburner$addBurntime(int constant) {
        if (this.lb != null) {
            int temp = this.lb.getBurntime();
            this.lb = null;
            return temp;
        }
        return constant;
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/simibubi/create/content/processing/burner/BlazeBurnerBlockEntity;updateBlockState()V", shift=At.Shift.BEFORE, ordinal=1)}, method={"tick"}, remap=false)
    public void liquidburner$appendTick(CallbackInfo ci) {
        if (this.remainingBurnTime <= 0) {
            this.recipeFluids();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"read"}, remap=false)
    public void liquidburner$appendRead(class_2487 compound, boolean clientPacket, CallbackInfo ci) {
        if (compound.method_10545("tank")) {
            this.tank.readFromNBT(compound.method_10562("tank"));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"write"}, remap=false)
    public void liquidburner$appendWrite(class_2487 compound, boolean clientPacket, CallbackInfo ci) {
        class_2487 tag = new class_2487();
        this.tank.writeToNBT(tag);
        compound.method_10566("tank", (class_2520)tag);
    }

    @Shadow(remap=false)
    public abstract void updateBlockState();

    @Shadow(remap=false)
    protected abstract void playSound();

    @Shadow(remap=false)
    public abstract BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock();

    @Shadow(remap=false)
    public abstract void spawnParticleBurst(boolean var1);

    @Shadow(remap=false)
    public abstract void tick();

    @Nullable
    public Storage<FluidVariant> getFluidStorage(class_2350 side) {
        return this.tank;
    }
}

