/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.MinecraftEndecs;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.impl.SlotTypeImpl;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_7923;

public record SyncData(List<SlotType> slotTypes, Map<class_1299<?>, Set<String>> entitySlots, Set<SlotGroup> slotGroups, Set<String> uniqueGroups, Map<String, ExtraSlotTypeProperties> uniqueExtraProperties) implements BaseAccessoriesPacket
{
    public static Endec<SyncData> ENDEC = StructEndecBuilder.of((StructField)SlotTypeImpl.ENDEC.listOf().fieldOf("slotTypes", SyncData::slotTypes), (StructField)Endec.map(MinecraftEndecs.ofRegistry(class_7923.field_41177), (Endec)Endec.STRING.setOf()).fieldOf("entitySlots", SyncData::entitySlots), (StructField)SlotGroupImpl.ENDEC.setOf().fieldOf("slotGroups", SyncData::slotGroups), (StructField)Endec.STRING.setOf().fieldOf("uniqueGroups", SyncData::uniqueGroups), (StructField)ExtraSlotTypeProperties.ENDEC.mapOf().fieldOf("uniqueExtraProperties", SyncData::uniqueExtraProperties), SyncData::new);

    public static SyncData create() {
        Map<String, SlotType> allSlotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);
        Map<class_1299<?>, Map<String, SlotType>> entitySlotData = EntitySlotLoader.INSTANCE.getEntitySlotData(false);
        HashMap entitySlots = new HashMap();
        for (Map.Entry<class_1299<?>, Map<String, SlotType>> entry : entitySlotData.entrySet()) {
            entitySlots.put(entry.getKey(), entry.getValue().keySet());
        }
        HashSet<SlotGroup> slotGroups = new HashSet<SlotGroup>();
        slotGroups.addAll(SlotGroupLoader.INSTANCE.getGroups(false, false));
        return new SyncData(List.copyOf(allSlotTypes.values()), entitySlots, slotGroups, UniqueSlotHandling.getGroups(false), ExtraSlotTypeProperties.getProperties(false));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(class_1657 player) {
        HashMap<String, SlotType> slotTypes = new HashMap<String, SlotType>();
        for (SlotType slotType2 : this.slotTypes()) {
            slotTypes.put(slotType2.name(), slotType2);
        }
        SlotTypeLoader.INSTANCE.setSlotType(slotTypes);
        UniqueSlotHandling.buildClientSlotReferences();
        HashMap entitySlotTypes = new HashMap();
        for (Map.Entry<class_1299<?>, Set<String>> entry : this.entitySlots().entrySet()) {
            Map<String, SlotType> map = entry.getValue().stream().map(slotTypes::get).collect(Collectors.toUnmodifiableMap(SlotType::name, slotType -> slotType));
            entitySlotTypes.put(entry.getKey(), map);
        }
        EntitySlotLoader.INSTANCE.setEntitySlotData(entitySlotTypes);
        Map<String, SlotGroup> map = this.slotGroups().stream().collect(Collectors.toUnmodifiableMap(SlotGroup::name, group -> group));
        SlotGroupLoader.INSTANCE.setGroups(map);
        UniqueSlotHandling.setClientGroups(this.uniqueGroups());
        ExtraSlotTypeProperties.setClientPropertyMap(this.uniqueExtraProperties());
    }
}

