/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.AlloyingRecipeWorkstation;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AbstractDoubleInputRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;

public class AlloyingRecipe
implements class_1860<class_1263>,
UnknownReceipBookCategory {
    public static final String GROUP = "alloying";
    public static final class_3956<AlloyingRecipe> TYPE = BCLRecipeManager.registerType("bclib", "alloying");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer("bclib", "alloying", new Serializer());
    protected final class_3956<?> type;
    protected final class_2960 id;
    protected final class_1856 primaryInput;
    protected final class_1856 secondaryInput;
    protected final class_1799 output;
    protected final String group;
    protected final float experience;
    protected final int smeltTime;

    public AlloyingRecipe(class_2960 id, String group, class_1856 primaryInput, class_1856 secondaryInput, class_1799 output, float experience, int smeltTime) {
        this.group = group;
        this.id = id;
        this.primaryInput = primaryInput;
        this.secondaryInput = secondaryInput;
        this.output = output;
        this.experience = experience;
        this.smeltTime = smeltTime;
        this.type = TYPE;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.primaryInput);
        defaultedList.add((Object)this.secondaryInput);
        return defaultedList;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        return this.primaryInput.method_8093(inv.method_5438(0)) && this.secondaryInput.method_8093(inv.method_5438(1)) || this.primaryInput.method_8093(inv.method_5438(1)) && this.secondaryInput.method_8093(inv.method_5438(0));
    }

    public class_1799 method_8116(class_1263 inv, class_5455 registryAccess) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 acc) {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    @Environment(value=EnvType.CLIENT)
    public String method_8112() {
        return this.group;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_17447() {
        return AlloyingRecipeWorkstation.getWorkstationIcon();
    }

    public static void register() {
    }

    public static class Serializer
    implements class_1865<AlloyingRecipe> {
        public AlloyingRecipe fromJson(class_2960 id, JsonObject json) {
            JsonArray ingredients = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            class_1856 primaryInput = class_1856.method_52177((JsonElement)ingredients.get(0));
            class_1856 secondaryInput = class_1856.method_52177((JsonElement)ingredients.get(1));
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            class_1799 output = ItemUtil.fromJsonRecipeWithNBT(result);
            if (output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            float experience = class_3518.method_15277((JsonObject)json, (String)"experience", (float)0.0f);
            int smeltTime = class_3518.method_15282((JsonObject)json, (String)"smelttime", (int)350);
            return new AlloyingRecipe(id, group, primaryInput, secondaryInput, output, experience, smeltTime);
        }

        public AlloyingRecipe fromNetwork(class_2960 id, class_2540 packetBuffer) {
            String group = packetBuffer.method_10800(Short.MAX_VALUE);
            class_1856 primary = class_1856.method_8086((class_2540)packetBuffer);
            class_1856 secondary = class_1856.method_8086((class_2540)packetBuffer);
            class_1799 output = packetBuffer.method_10819();
            float experience = packetBuffer.readFloat();
            int smeltTime = packetBuffer.method_10816();
            return new AlloyingRecipe(id, group, primary, secondary, output, experience, smeltTime);
        }

        public void toNetwork(class_2540 packetBuffer, AlloyingRecipe recipe) {
            packetBuffer.method_10814(recipe.group);
            recipe.primaryInput.method_8088(packetBuffer);
            recipe.secondaryInput.method_8088(packetBuffer);
            packetBuffer.method_10793(recipe.output);
            packetBuffer.writeFloat(recipe.experience);
            packetBuffer.method_10804(recipe.smeltTime);
        }
    }

    public static class Builder
    extends AbstractDoubleInputRecipeBuilder<Builder, AlloyingRecipe> {
        private float experience = 0.0f;
        private int smeltTime = 350;

        private Builder(class_2960 id, class_1935 output) {
            super(id, output);
        }

        static Builder create(class_2960 id, class_1935 output) {
            return new Builder(id, output);
        }

        @Override
        public Builder setOutputCount(int count) {
            return (Builder)super.setOutputCount(count);
        }

        @Override
        public Builder setOutputTag(class_2487 tag) {
            return (Builder)super.setOutputTag(tag);
        }

        public Builder setInput(class_1935 primaryInput, class_1935 secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        public Builder setInput(class_6862<class_1792> primaryInput, class_6862<class_1792> secondaryInput) {
            this.setPrimaryInput(primaryInput);
            this.setSecondaryInput(secondaryInput);
            return this;
        }

        public Builder setExperience(float amount) {
            this.experience = amount;
            return this;
        }

        public Builder setSmeltTime(int time) {
            this.smeltTime = time;
            return this;
        }

        @Override
        public Builder setGroup(String group) {
            return (Builder)super.setGroup(group);
        }

        @Override
        protected boolean checkRecipe() {
            if (this.smeltTime < 0) {
                BCLib.LOGGER.warning("Semelt-time for recipe {} most be positive!", this.id);
                return false;
            }
            return super.checkRecipe();
        }

        @Override
        protected class_1865<AlloyingRecipe> getSerializer() {
            return SERIALIZER;
        }

        @Override
        protected void serializeRecipeData(JsonObject root) {
            super.serializeRecipeData(root);
            if (this.experience != 0.0f) {
                root.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            if (this.experience != 350.0f) {
                root.addProperty("smelttime", (Number)this.smeltTime);
            }
        }
    }
}

