/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget;

import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_7842;

@Environment(value=EnvType.CLIENT)
public abstract class WidgetBuilder<T> {
    protected static final Supplier<class_310> CLIENT = class_310::method_1551;
    protected final IConfigEntry<T> config;
    protected class_7842 textWidget;
    protected class_4185 resetButton;
    protected boolean canSave = true;

    protected WidgetBuilder(IConfigEntry<T> config) {
        this.config = config;
    }

    public void addDialogElements(Consumer<class_339> appender, String text, int x, int y, int width, int height) {
        class_327 textRenderer = WidgetBuilder.CLIENT.get().field_1772;
        this.textWidget = new class_7842(20, y, textRenderer.method_1727(text), height, class_2561.method_30163((String)text), textRenderer);
        appender.accept((class_339)this.textWidget);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"jupiter.screen.button.remove"), button -> {
            this.config.reset();
            this.refresh();
        }).method_46434(x + width - 50, y, 50, height).method_46431();
        this.refreshResetButton(true);
        appender.accept((class_339)this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    public void addElements(Consumer<class_339> appender, int x, int y, int width, int height) {
        String name = this.config.getPrettyName();
        class_327 textRenderer = WidgetBuilder.CLIENT.get().field_1772;
        this.textWidget = new class_7842(20, y, textRenderer.method_1727(name), height, class_2561.method_30163((String)name), textRenderer);
        appender.accept((class_339)this.textWidget);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"jupiter.screen.button.reset"), button -> {
            this.config.reset();
            this.refresh();
        }).method_46434(x + width - 50, y, 50, height).method_46431();
        this.refreshResetButton(false);
        this.config.registerCallback(v -> this.refreshResetButton(false));
        appender.accept((class_339)this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    private void refreshResetButton(boolean dialog) {
        this.setCanReset(dialog || !this.config.getValue().equals(this.config.getDefaultValue()));
    }

    protected void setCanReset(boolean b) {
        this.resetButton.field_22763 = b;
    }

    public abstract void addCustomElements(Consumer<class_339> var1, int var2, int var3, int var4, int var5);

    public void update(boolean visible, int y) {
        if (this.textWidget != null) {
            this.textWidget.field_22764 = visible;
            this.textWidget.method_46419(y);
        }
        if (this.resetButton != null) {
            this.resetButton.field_22764 = visible;
            this.resetButton.method_46419(y);
        }
        this.updateCustom(visible, y);
    }

    public abstract void updateCustom(boolean var1, int var2);

    public abstract void refresh();

    public boolean canSave() {
        return this.canSave;
    }
}

