/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block;

import com.nhoryzon.mc.farmersdelight.block.StoveBlock;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.util.MathUtils;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntity
extends class_2586
implements class_3829 {
    public static final String TAG_KEY_COOKING_TIMES = "CookingTimes";
    public static final String TAG_KEY_COOKING_TOTAL_TIMES = "CookingTotalTimes";
    private static final class_265 GRILLING_AREA = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int MAX_STACK_SIZE = 6;
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTotalTimes = new int[6];
    protected final class_2371<class_1799> inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);

    private StoveBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState) {
        super(type, blockPos, blockState);
    }

    public StoveBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(BlockEntityTypesRegistry.STOVE.get(), blockPos, blockState);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.inventory.clear();
        class_1262.method_5429((class_2487)tag, this.inventory);
        if (tag.method_10573(TAG_KEY_COOKING_TIMES, 11)) {
            int[] cookingTimeRead = tag.method_10561(TAG_KEY_COOKING_TIMES);
            System.arraycopy(cookingTimeRead, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimeRead.length));
        }
        if (tag.method_10573(TAG_KEY_COOKING_TOTAL_TIMES, 11)) {
            int[] cookingTotalTimeRead = tag.method_10561(TAG_KEY_COOKING_TOTAL_TIMES);
            System.arraycopy(cookingTotalTimeRead, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTotalTimeRead.length));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5427((class_2487)tag, this.inventory, (boolean)true);
        tag.method_10539(TAG_KEY_COOKING_TIMES, this.cookingTimes);
        tag.method_10539(TAG_KEY_COOKING_TOTAL_TIMES, this.cookingTotalTimes);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, StoveBlockEntity blockEntity) {
        boolean isStoveLit = (Boolean)blockEntity.method_11010().method_11654((class_2769)StoveBlock.LIT);
        boolean isStoveBlocked = blockEntity.isStoveBlockedAbove();
        if (world != null && world.method_8608()) {
            if (isStoveLit) {
                blockEntity.addParticles();
            }
        } else {
            if (world != null && isStoveBlocked && !blockEntity.inventory.isEmpty()) {
                class_1264.method_17349((class_1937)world, (class_2338)pos, blockEntity.inventory);
                blockEntity.inventoryChanged();
            }
            if (isStoveLit && !isStoveBlocked) {
                blockEntity.cookAndDrop();
            } else {
                blockEntity.fadeCooking();
            }
        }
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5427((class_2487)nbtCompound, this.inventory, (boolean)true);
        return nbtCompound;
    }

    public Optional<class_3920> findMatchingRecipe(class_1799 itemStack) {
        return this.field_11863 == null || this.inventory.stream().noneMatch(class_1799::method_7960) ? Optional.empty() : this.field_11863.method_8433().method_8132(class_3956.field_17549, (class_1263)new class_1277(new class_1799[]{itemStack}), this.field_11863);
    }

    public boolean isStoveBlockedAbove() {
        if (this.field_11863 != null) {
            class_2680 above = this.field_11863.method_8320(this.field_11867.method_10084());
            return class_259.method_1074((class_265)GRILLING_AREA, (class_265)above.method_26218((class_1922)this.field_11863, this.field_11867.method_10084()), (class_247)class_247.field_16896);
        }
        return false;
    }

    private void addParticles() {
        class_1937 world = this.method_10997();
        if (world != null) {
            class_2338 blockpos = this.method_11016();
            class_5819 random = world.field_9229;
            for (int j = 0; j < this.inventory.size(); ++j) {
                if (((class_1799)this.inventory.get(j)).method_7960() || !(random.method_43057() < 0.2f)) continue;
                double d0 = (double)blockpos.method_10263() + 0.5;
                double d1 = (double)blockpos.method_10264() + 1.0;
                double d2 = (double)blockpos.method_10260() + 0.5;
                class_241 v1 = this.getStoveItemOffset(j);
                class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)StoveBlock.FACING);
                int directionIndex = direction.method_10161();
                class_241 offset = directionIndex % 2 == 0 ? v1 : new class_241(v1.field_1342, v1.field_1343);
                double d5 = d0 - (double)((float)direction.method_10148() * offset.field_1343) + (double)((float)direction.method_10170().method_10148() * offset.field_1343);
                double d7 = d2 - (double)((float)direction.method_10165() * offset.field_1342) + (double)((float)direction.method_10170().method_10165() * offset.field_1342);
                for (int k = 0; k < 3; ++k) {
                    world.method_8406((class_2394)class_2398.field_11251, d5, d1, d7, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public class_241 getStoveItemOffset(int index) {
        float xOffset = 0.3f;
        float yOffset = 0.2f;
        class_241[] offsets = new class_241[]{new class_241(0.3f, 0.2f), new class_241(0.0f, 0.2f), new class_241(-0.3f, 0.2f), new class_241(0.3f, -0.2f), new class_241(0.0f, -0.2f), new class_241(-0.3f, -0.2f)};
        return offsets[index];
    }

    private void inventoryChanged() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    private void cookAndDrop() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 itemstack = (class_1799)this.inventory.get(i);
            if (itemstack.method_7960()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTotalTimes[i]) continue;
            if (this.field_11863 != null) {
                class_1277 cookInventory = new class_1277(new class_1799[]{itemstack});
                class_1799 result = this.field_11863.method_8433().method_17877(class_3956.field_17549, (class_1263)cookInventory, this.field_11863).stream().map(arg_0 -> this.lambda$cookAndDrop$0((class_1263)cookInventory, arg_0)).findAny().orElse(itemstack);
                if (!result.method_7960()) {
                    class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5, result.method_7972());
                    entity.method_18800(MathUtils.RAND.nextGaussian() * (double)0.01f, (double)0.1f, MathUtils.RAND.nextGaussian() * (double)0.01f);
                    this.field_11863.method_8649((class_1297)entity);
                }
            }
            this.inventory.set(i, (Object)class_1799.field_8037);
            this.inventoryChanged();
        }
    }

    private void fadeCooking() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (this.cookingTimes[i] <= 0) continue;
            this.cookingTimes[i] = class_3532.method_15340((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTotalTimes[i]);
        }
    }

    public boolean addItem(class_1799 itemStack, int cookTime) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 itemstack = (class_1799)this.inventory.get(i);
            if (!itemstack.method_7960()) continue;
            this.cookingTotalTimes[i] = cookTime;
            this.cookingTimes[i] = 0;
            this.inventory.set(i, (Object)itemStack.method_7971(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    private /* synthetic */ class_1799 lambda$cookAndDrop$0(class_1263 cookInventory, class_3920 recipe) {
        return recipe.method_8116(cookInventory, this.field_11863.method_30349());
    }
}

