/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight;

import com.mojang.datafixers.util.Pair;
import com.nhoryzon.mc.farmersdelight.Configuration;
import com.nhoryzon.mc.farmersdelight.entity.RottenTomatoEntity;
import com.nhoryzon.mc.farmersdelight.entity.block.dispenser.CuttingBoardDispenseBehavior;
import com.nhoryzon.mc.farmersdelight.event.CuttingBoardEventListener;
import com.nhoryzon.mc.farmersdelight.event.KnivesEventListener;
import com.nhoryzon.mc.farmersdelight.event.LivingEntityFeedItemEventListener;
import com.nhoryzon.mc.farmersdelight.mixin.accessors.ParrotsTamingIngredientsAccessorMixin;
import com.nhoryzon.mc.farmersdelight.mixin.accessors.StructurePoolAccessorMixin;
import com.nhoryzon.mc.farmersdelight.registry.AdvancementsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.BiomeFeaturesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.BlocksRegistry;
import com.nhoryzon.mc.farmersdelight.registry.ConfiguredFeaturesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.EffectsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.EnchantmentsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.EntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.ExtendedScreenTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.ItemsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.LootFunctionsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.ParticleTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.PlacementModifiersRegistry;
import com.nhoryzon.mc.farmersdelight.registry.RecipeTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.SoundsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3852;
import net.minecraft.class_39;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6880;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_83;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmersDelightMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Farmer's Delight");
    public static final String MOD_ID = "farmersdelight";
    public static Configuration CONFIG = new Configuration();
    public static final class_5321<class_1761> ITEM_GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960("farmersdelight", "main"));

    public static class_5250 i18n(String key, Object ... args) {
        return class_2561.method_43469((String)("farmersdelight." + key), (Object[])args);
    }

    public void onInitialize() {
        class_2378.method_39197((class_2378)class_7923.field_44687, ITEM_GROUP, (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.farmersdelight.main")).method_47320(() -> new class_1799((class_1935)ItemsRegistry.STOVE.get())).method_47324());
        this.initConfiguration();
        BlocksRegistry.registerAll();
        ItemsRegistry.registerAll();
        EffectsRegistry.registerAll();
        BlockEntityTypesRegistry.registerAll();
        SoundsRegistry.registerAll();
        AdvancementsRegistry.registerAll();
        RecipeTypesRegistry.registerAll();
        LootFunctionsRegistry.registerAll();
        ExtendedScreenTypesRegistry.registerAll();
        ParticleTypesRegistry.registerAll();
        EnchantmentsRegistry.registerAll();
        ConfiguredFeaturesRegistry.registerAll();
        BiomeFeaturesRegistry.registerAll();
        PlacementModifiersRegistry.registerAll();
        EntityTypesRegistry.registerAll();
        this.registerBiomeModifications();
        this.registerCompostables();
        this.registerEventListeners();
        this.registerLootTable();
        this.registerDispenserBehavior();
        this.registerVillagerTradeOffer();
        ParrotsTamingIngredientsAccessorMixin.getTamingIngredients().addAll(List.of(ItemsRegistry.CABBAGE_SEEDS.get(), ItemsRegistry.TOMATO_SEEDS.get(), ItemsRegistry.RICE.get()));
    }

    protected void initConfiguration() {
        CONFIG = Configuration.load();
        ResourceConditions.register((class_2960)new class_2960(MOD_ID, "vanilla_crates_enabled"), jsonObject -> CONFIG.isEnableVanillaCropCrates());
        if (CONFIG.isGenerateVillageCompostHeaps()) {
            List<Pair> compostPileList = List.of(Pair.of((Object)"plains", (Object)5), Pair.of((Object)"savanna", (Object)4), Pair.of((Object)"snowy", (Object)3), Pair.of((Object)"taiga", (Object)4), Pair.of((Object)"desert", (Object)3));
            ServerLifecycleEvents.SERVER_STARTING.register(server -> compostPileList.forEach(villageType -> {
                LOGGER.info("Registering compost heaps in village type of {}", villageType.getFirst());
                class_2960 compostPileId = new class_2960(MOD_ID, "village/houses/" + (String)villageType.getFirst() + "_compost_pile");
                class_2960 villageHousePoolId = new class_2960("minecraft:village/" + (String)villageType.getFirst() + "/houses");
                this.addToStructurePool(server, villageHousePoolId, compostPileId, (Integer)villageType.getSecond());
            }));
        }
    }

    protected void addToStructurePool(MinecraftServer server, class_2960 poolIdentifier, class_2960 nbtIdentifier, int weight) {
        class_6880.class_6883 emptyProcessorList = server.method_30611().method_30530(class_7924.field_41247).method_40290(class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)new class_2960("minecraft", "empty")));
        server.method_30611().method_30530(class_7924.field_41249).method_17966(poolIdentifier).ifPresentOrElse(structurePool -> {
            class_3781 compostPilePool = (class_3781)class_3784.method_30435((String)nbtIdentifier.toString(), (class_6880)emptyProcessorList).apply(class_3785.class_3786.field_16687);
            ArrayList<Pair<class_3784, Integer>> elementCounts = new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessorMixin)structurePool).getElementCounts());
            elementCounts.add((Pair<class_3784, Integer>)Pair.of((Object)compostPilePool, (Object)weight));
            ((StructurePoolAccessorMixin)structurePool).setElementCounts(elementCounts);
            IntStream.range(0, weight).forEach(value -> ((StructurePoolAccessorMixin)structurePool).getElements().add((Object)compostPilePool));
        }, () -> LOGGER.warn("No structure pool found for {}, no compost heaps will be added on it.", (Object)poolIdentifier));
    }

    protected void registerEventListeners() {
        PlayerBlockBreakEvents.AFTER.register((Object)KnivesEventListener.INSTANCE);
        UseBlockCallback.EVENT.register((Object)KnivesEventListener.INSTANCE);
        UseBlockCallback.EVENT.register((Object)CuttingBoardEventListener.INSTANCE);
        UseEntityCallback.EVENT.register((Object)LivingEntityFeedItemEventListener.INSTANCE);
    }

    protected void registerBiomeModifications() {
        if (CONFIG.isGenerateWildBeetroots()) {
            BiomeModifications.addFeature(context -> context.getBiomeKey().equals(class_1972.field_9434), (class_2893.class_2895)class_2893.class_2895.field_13178, ConfiguredFeaturesRegistry.PATCH_WILD_BEETROOTS.key());
        }
        if (CONFIG.isGenerateWildCabbages()) {
            BiomeModifications.addFeature(context -> context.getBiomeKey().equals(class_1972.field_9434), (class_2893.class_2895)class_2893.class_2895.field_13178, ConfiguredFeaturesRegistry.PATCH_WILD_CABBAGES.key());
        }
        if (CONFIG.isGenerateWildRice()) {
            BiomeModifications.addFeature(context -> BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9471, class_1972.field_9417}).test(context), (class_2893.class_2895)class_2893.class_2895.field_13178, ConfiguredFeaturesRegistry.PATCH_WILD_RICE.key());
        }
        if (CONFIG.isGenerateWildTomatoes()) {
            BiomeModifications.addFeature(context -> context.getBiome().method_8712() >= 1.0f, (class_2893.class_2895)class_2893.class_2895.field_13178, ConfiguredFeaturesRegistry.PATCH_WILD_TOMATOES.key());
        }
        if (CONFIG.isGenerateWildCarrots()) {
            BiomeModifications.addFeature(context -> context.getBiome().method_8712() > 0.3f && context.getBiome().method_8712() < 1.0f, (class_2893.class_2895)class_2893.class_2895.field_13178, ConfiguredFeaturesRegistry.PATCH_WILD_CARROTS.key());
        }
        if (CONFIG.isGenerateWildOnions()) {
            BiomeModifications.addFeature(context -> context.getBiome().method_8712() > 0.3f && context.getBiome().method_8712() < 1.0f, (class_2893.class_2895)class_2893.class_2895.field_13178, ConfiguredFeaturesRegistry.PATCH_WILD_ONIONS.key());
        }
        if (CONFIG.isGenerateWildPotatoes()) {
            BiomeModifications.addFeature(context -> context.getBiome().method_8712() > 0.0f && context.getBiome().method_8712() < 0.3f, (class_2893.class_2895)class_2893.class_2895.field_13178, ConfiguredFeaturesRegistry.PATCH_WILD_POTATOES.key());
        }
    }

    protected void registerCompostables() {
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.TREE_BARK.get(), (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.STRAW.get(), (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.CABBAGE_SEEDS.get(), (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.TOMATO_SEEDS.get(), (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.RICE.get(), (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.RICE_PANICLE.get(), (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.PUMPKIN_SLICE.get(), (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.CABBAGE_LEAF.get(), (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.CABBAGE.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.ONION.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.TOMATO.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.WILD_CABBAGES.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.WILD_ONIONS.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.WILD_TOMATOES.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.WILD_CARROTS.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.WILD_POTATOES.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.WILD_BEETROOTS.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.WILD_RICE.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.PIE_CRUST.get(), (Object)Float.valueOf(0.65f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.RICE_BALE.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.SWEET_BERRY_COOKIE.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.HONEY_COOKIE.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.CAKE_SLICE.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.APPLE_PIE_SLICE.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.SWEET_BERRY_CHEESECAKE_SLICE.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.CHOCOLATE_PIE_SLICE.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.RAW_PASTA.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.ROTTEN_TOMATO.get(), (Object)Float.valueOf(0.85f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.APPLE_PIE.get(), (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.SWEET_BERRY_CHEESECAKE.get(), (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.CHOCOLATE_PIE.get(), (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.DUMPLINGS.get(), (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.STUFFED_PUMPKIN.get(), (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.BROWN_MUSHROOM_COLONY.get(), (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ItemsRegistry.RED_MUSHROOM_COLONY.get(), (Object)Float.valueOf(1.0f));
    }

    protected void registerLootTable() {
        Set<class_2960> chestsId = Set.of(class_39.field_472, class_39.field_24049, class_39.field_24046, class_39.field_274, class_39.field_16593, class_39.field_24050, class_39.field_880, class_39.field_356, class_39.field_16748, class_39.field_16753, class_39.field_16754, class_39.field_16749, class_39.field_16752, class_39.field_17012);
        Set<class_2960> scavengingEntityIdList = Set.of(class_1299.field_6093.method_16351(), class_1299.field_21973.method_16351(), class_1299.field_6132.method_16351(), class_1299.field_6085.method_16351(), class_1299.field_6067.method_16351(), class_1299.field_6139.method_16351(), class_1299.field_6074.method_16351(), class_1299.field_6057.method_16351(), class_1299.field_6140.method_16351(), class_1299.field_6109.method_16351(), class_1299.field_6079.method_16351());
        Set<class_2960> addItemLootBlockIdList = Set.of(class_2246.field_10479.method_26162(), class_2246.field_10214.method_26162(), class_2246.field_10293.method_26162());
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            class_2960 injectId = new class_2960(MOD_ID, "inject/" + id.method_12832());
            if (scavengingEntityIdList.contains(id) || addItemLootBlockIdList.contains(id)) {
                tableBuilder.pool(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)injectId)).method_355());
            }
            if (chestsId.contains(id) && CONFIG.isGenerateFDChestLoot()) {
                tableBuilder.pool(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)injectId).method_437(1).method_436(0)).method_355());
            }
        });
    }

    protected void registerDispenserBehavior() {
        if (CONFIG.isDispenserToolsCuttingBoard()) {
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8647, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8406, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8876, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8387, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8062, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8776, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8403, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8475, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8699, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8377, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8556, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8250, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8335, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8825, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8322, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_22024, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_22025, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_22023, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(class_1802.field_8868, new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(ItemsRegistry.FLINT_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(ItemsRegistry.IRON_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(ItemsRegistry.DIAMOND_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(ItemsRegistry.GOLDEN_KNIFE.get(), new CuttingBoardDispenseBehavior());
            CuttingBoardDispenseBehavior.registerBehaviour(ItemsRegistry.NETHERITE_KNIFE.get(), new CuttingBoardDispenseBehavior());
        }
        class_2315.method_10009((class_1935)ItemsRegistry.ROTTEN_TOMATO.get(), (class_2357)new class_2965(){

            protected class_1676 method_12844(class_1937 world, class_2374 position, class_1799 stack) {
                return new RottenTomatoEntity(world, position.method_10216(), position.method_10214(), position.method_10215());
            }
        });
    }

    protected void registerVillagerTradeOffer() {
        if (CONFIG.isFarmersBuyFDCrops()) {
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17056, (int)1, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.ONION.get(), 26), new class_1799((class_1935)class_1802.field_8687), 16, 2, 0.05f));
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17056, (int)1, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.TOMATO.get(), 26), new class_1799((class_1935)class_1802.field_8687), 16, 2, 0.05f));
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17056, (int)2, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.CABBAGE.get(), 16), new class_1799((class_1935)class_1802.field_8687), 16, 5, 0.05f));
            TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17056, (int)2, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.RICE.get(), 20), new class_1799((class_1935)class_1802.field_8687), 16, 5, 0.05f));
        }
        if (CONFIG.isWanderingTraderSellsFDItems()) {
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.CABBAGE_SEEDS.get()), new class_1799((class_1935)class_1802.field_8687), 1, 12, 0.05f));
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.TOMATO_SEEDS.get()), new class_1799((class_1935)class_1802.field_8687), 1, 12, 0.05f));
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.RICE.get()), new class_1799((class_1935)class_1802.field_8687), 1, 12, 0.05f));
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> new class_1914(new class_1799((class_1935)ItemsRegistry.ONION.get()), new class_1799((class_1935)class_1802.field_8687), 1, 12, 0.05f));
        }
    }
}

