/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model;

import com.iafenvoy.iceandfire.entity.util.IFlapable;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class IFChainBuffer {
    private int yawTimer;
    private float yawVariation;
    private int pitchTimer;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
        this.prevYawVariation = 0.0f;
        this.prevPitchVariation = 0.0f;
    }

    private boolean compareDouble(double a, double b) {
        double c = a - b;
        return Math.abs(c - 1.0) <= 0.01;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, class_1309 entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_6283, entity.field_6220) && class_3532.method_15379((float)this.yawVariation) < maxAngle) {
            this.yawVariation += class_3532.method_15363((float)((entity.field_6220 - entity.field_6283) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (class_3532.method_15379((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (class_3532.method_15379((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainPitchBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, class_1309 entity) {
        this.prevPitchVariation = entity.field_6004;
        this.pitchVariation = entity.method_36455();
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, class_1309 entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (Math.abs(entity.method_36455()) > maxAngle) {
            return;
        }
        if (!this.compareDouble(entity.method_36455(), entity.field_6004) && class_3532.method_15379((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += class_3532.method_15363((float)((entity.field_6004 - entity.method_36455()) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.pitchVariation > angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (class_3532.method_15379((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (class_3532.method_15379((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, class_1309 entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_6283, entity.field_6220) && class_3532.method_15379((float)this.yawVariation) < maxAngle) {
            this.yawVariation += class_3532.method_15363((float)((entity.field_6220 - entity.field_6283) / divisor), (float)(-maxAngle), (float)maxAngle);
            if (entity instanceof IFlapable) {
                IFlapable flap = (IFlapable)entity;
                if ((double)Math.abs(entity.field_6220 - entity.field_6283) > 15.0) {
                    flap.flapWings();
                }
            }
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (class_3532.method_15379((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (class_3532.method_15379((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainFlapBufferHead(float maxAngle, int bufferTime, float angleDecrement, float divisor, class_1309 entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_6259, entity.field_6241) && class_3532.method_15379((float)this.yawVariation) < maxAngle) {
            this.yawVariation += class_3532.method_15363((float)((entity.field_6241 - entity.field_6259) / divisor), (float)(-maxAngle), (float)maxAngle);
            if (entity instanceof IFlapable) {
                IFlapable flap = (IFlapable)entity;
                if ((double)Math.abs(entity.field_6241 - entity.field_6259) > 15.0) {
                    flap.flapWings();
                }
            }
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (class_3532.method_15379((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (class_3532.method_15379((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, class_1309 entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, class_1309 entity) {
        this.calculateChainWaveBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, class_1309 entity) {
        this.calculateChainFlapBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * class_3532.method_16439((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleY += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * class_3532.method_16439((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleX += rotateAmount;
        }
    }

    public void applyChainFlapBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * class_3532.method_16439((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleZ += rotateAmount;
        }
    }

    public void applyChainFlapBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * class_3532.method_16439((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleZ -= rotateAmount * 0.5f;
        }
    }

    public void applyChainSwingBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * class_3532.method_16439((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleY -= rotateAmount;
        }
    }

    public void applyChainWaveBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * class_3532.method_16439((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleX -= rotateAmount;
        }
    }

    private float getPartialTicks() {
        return class_310.method_1551().method_1488();
    }
}

