/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexEgg;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIForage;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIForageForItems;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIPickupBabies;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIStoreBabies;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIStoreItems;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIWander;
import com.iafenvoy.iceandfire.entity.util.MyrmexTrades;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.item.ItemMyrmexEgg;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.animation.Animation;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3853;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class EntityMyrmexWorker
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final class_2960 DESERT_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/myrmex_worker_desert");
    public static final class_2960 JUNGLE_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/myrmex_worker_jungle");
    private static final class_2960 TEXTURE_DESERT = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_worker.png");
    private static final class_2960 TEXTURE_JUNGLE = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_worker.png");
    public boolean keepSearching = true;

    public EntityMyrmexWorker(class_1299<EntityMyrmexWorker> t, class_1937 worldIn) {
        super(t, worldIn);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return EntityMyrmexWorker.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, ((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue()).doubleValue()).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23724, 4.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23721).method_6192(((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue()).doubleValue());
    }

    protected class_2960 method_5991() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    public void method_6078(class_1282 cause) {
        if (!this.method_37908().field_9236 && !this.method_5998(class_1268.field_5808).method_7960()) {
            this.method_5699(this.method_5998(class_1268.field_5808), 0.0f);
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        super.method_6078(cause);
    }

    @Override
    public int method_6110() {
        return 3;
    }

    @Override
    public boolean isSmallerThanBlock() {
        return true;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_5998(class_1268.field_5808).method_7960() && this.method_5998(class_1268.field_5808).method_7909() instanceof ItemMyrmexEgg) {
            boolean isJungle = this.method_5998(class_1268.field_5808).method_7909() == IafItems.MYRMEX_JUNGLE_EGG.get();
            class_2487 tag = this.method_5998(class_1268.field_5808).method_7969();
            int metadata = 0;
            if (tag != null) {
                metadata = tag.method_10550("EggOrdinal");
            }
            EntityMyrmexEgg egg = new EntityMyrmexEgg((class_1299<? extends EntityMyrmexEgg>)((class_1299)IafEntities.MYRMEX_EGG.get()), this.method_37908());
            egg.method_5719((class_1297)this);
            egg.setJungle(isJungle);
            egg.setMyrmexCaste(metadata);
            if (!this.method_37908().field_9236) {
                this.method_37908().method_8649((class_1297)egg);
            }
            egg.method_5804((class_1297)this);
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        if (!this.method_5685().isEmpty()) {
            for (class_1297 entity : this.method_5685()) {
                if (!(entity instanceof EntityMyrmexBase) || ((EntityMyrmexBase)entity).getGrowthStage() < 2) continue;
                entity.method_5848();
            }
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAITradePlayer(this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAILookAtTradePlayer(this));
        this.field_6201.method_6277(1, (class_1352)new MyrmexAIAttackMelee(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new MyrmexAIStoreBabies(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new MyrmexAIStoreItems(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new MyrmexAIReEnterHive(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new MyrmexAILeaveHive(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new MyrmexAIForage(this, 2));
        this.field_6201.method_6277(7, (class_1352)new MyrmexAIMoveThroughHive(this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new MyrmexAIWander(this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new MyrmexAIDefendHive(this));
        this.field_6185.method_6277(2, (class_1352)new MyrmexAIForageForItems(this));
        this.field_6185.method_6277(3, new MyrmexAIPickupBabies(this));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new MyrmexAIAttackPlayers(this));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, true, (Predicate)((com.google.common.base.Predicate)entity -> this.method_6047().method_7960() && entity != null && !EntityMyrmexWorker.haveSameHive(this, (class_1297)entity) && DragonUtils.isAlive(entity) && !(entity instanceof class_1569))));
    }

    @Override
    public boolean shouldWander() {
        return super.shouldWander() && this.canSeeSky();
    }

    @Override
    protected class_3853.class_1652[] getLevel1Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_WORKER.get(1) : (class_3853.class_1652[])MyrmexTrades.DESERT_WORKER.get(1);
    }

    @Override
    protected class_3853.class_1652[] getLevel2Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_WORKER.get(2) : (class_3853.class_1652[])MyrmexTrades.DESERT_WORKER.get(2);
    }

    @Override
    public class_2960 getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.6f;
    }

    @Override
    public boolean shouldLeaveHive() {
        return !this.holdingSomething();
    }

    @Override
    public boolean shouldEnterHive() {
        if (this.holdingSomething()) {
            return true;
        }
        if (this.method_37908().method_8530()) {
            return false;
        }
        return (Boolean)IafCommonConfig.INSTANCE.myrmex.hiveIgnoreDaytime.getValue() == false;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return !this.shouldLeaveHive() && !this.holdingSomething();
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.method_6051().method_43056() ? ANIMATION_STING : ANIMATION_BITE);
            float f = (float)this.method_26825(class_5134.field_23721);
            this.method_6114(entityIn);
            boolean flag = entityIn.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), f);
            if (this.getAnimation() == ANIMATION_STING && flag) {
                this.playStingSound();
                if (entityIn instanceof class_1309) {
                    ((class_1309)entityIn).method_6092(new class_1293(class_1294.field_5899, 200, 2));
                    this.method_5980((class_1309)entityIn);
                }
            } else {
                this.playBiteSound();
            }
            if (!this.method_37908().field_9236 && this.method_6051().method_43048(3) == 0 && this.method_5998(class_1268.field_5808) != class_1799.field_8037) {
                this.method_5699(this.method_5998(class_1268.field_5808), 0.0f);
                this.method_6122(class_1268.field_5808, class_1799.field_8037);
            }
            if (!this.method_5685().isEmpty()) {
                for (class_1297 entity : this.method_5685()) {
                    entity.method_5848();
                }
            }
            return true;
        }
        return false;
    }

    public boolean holdingSomething() {
        return this.getHeldEntity() != null || !this.method_5998(class_1268.field_5808).method_7960() || this.method_5968() != null;
    }

    public boolean holdingBaby() {
        return this.getHeldEntity() != null && (this.getHeldEntity() instanceof EntityMyrmexBase || this.getHeldEntity() instanceof EntityMyrmexEgg);
    }

    @Override
    public int getCasteImportance() {
        return 0;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (this.method_5626(passenger)) {
            this.field_6283 = this.method_36454();
            float radius = 1.05f;
            float angle = (float)Math.PI / 180 * this.field_6283;
            double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * class_3532.method_15362((float)angle);
            passenger.method_5814(this.method_23317() + extraX, this.method_23318() + 0.25, this.method_23321() + extraZ);
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if ((double)amount >= 1.0 && !this.method_37908().field_9236 && this.method_6051().method_43048(3) == 0 && this.method_5998(class_1268.field_5808) != class_1799.field_8037) {
            this.method_5699(this.method_5998(class_1268.field_5808), 0.0f);
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        if ((double)amount >= 1.0 && !this.method_5685().isEmpty()) {
            for (class_1297 entity : this.method_5685()) {
                entity.method_5848();
            }
        }
        return super.method_5643(source, amount);
    }

    public class_1297 getHeldEntity() {
        return this.method_5685().isEmpty() ? null : (class_1297)this.method_5685().get(0);
    }

    public void onPickupItem(class_1542 itemEntity) {
        class_1792 item = itemEntity.method_6983().method_7909();
        if (item == IafItems.MYRMEX_JUNGLE_RESIN.get() && this.isJungle() || item == IafItems.MYRMEX_DESERT_RESIN.get() && !this.isJungle()) {
            class_1657 owner = null;
            try {
                if (itemEntity.method_24921() != null) {
                    owner = (class_1657)itemEntity.method_24921();
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Myrmex picked up resin that wasn't thrown!");
            }
            if (owner != null && this.getHive() != null) {
                this.getHive().modifyPlayerReputation(owner.method_5667(), 5);
                this.method_5783(class_3417.field_15095, 1.0f, 1.0f);
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), owner.method_23317(), owner.method_23318(), owner.method_23321(), 1 + this.field_5974.method_43048(3)));
                }
            }
        }
    }

    public int method_19269() {
        return 0;
    }

    public boolean method_19270() {
        return false;
    }

    public boolean method_38069() {
        return this.method_37908().field_9236;
    }
}

