/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIFindHidingSpot;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIWander;
import com.iafenvoy.iceandfire.entity.util.MyrmexTrades;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.uranus.animation.Animation;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3853;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class EntityMyrmexSentinel
extends EntityMyrmexBase {
    public static final Animation ANIMATION_GRAB = Animation.create((int)15);
    public static final Animation ANIMATION_NIBBLE = Animation.create((int)10);
    public static final Animation ANIMATION_STING = Animation.create((int)25);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final class_2960 DESERT_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/myrmex_sentinel_desert");
    public static final class_2960 JUNGLE_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/myrmex_sentinel_jungle");
    private static final class_2960 TEXTURE_DESERT = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_sentinel.png");
    private static final class_2960 TEXTURE_JUNGLE = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_sentinel.png");
    private static final class_2960 TEXTURE_DESERT_HIDDEN = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_sentinel_hidden.png");
    private static final class_2960 TEXTURE_JUNGLE_HIDDEN = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_sentinel_hidden.png");
    private static final class_2940<Boolean> HIDING = class_2945.method_12791(EntityMyrmexSentinel.class, (class_2941)class_2943.field_13323);
    public float holdingProgress;
    public float hidingProgress;
    public int visibleTicks = 0;
    public int daylightTicks = 0;

    public EntityMyrmexSentinel(class_1299<? extends EntityMyrmexSentinel> t, class_1937 worldIn) {
        super(t, worldIn);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return EntityMyrmexSentinel.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23721, (Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 3.0).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23724, 12.0);
    }

    @Override
    protected class_3853.class_1652[] getLevel1Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_SENTINEL.get(1) : (class_3853.class_1652[])MyrmexTrades.DESERT_SENTINEL.get(1);
    }

    @Override
    protected class_3853.class_1652[] getLevel2Trades() {
        return this.isJungle() ? (class_3853.class_1652[])MyrmexTrades.JUNGLE_SENTINEL.get(2) : (class_3853.class_1652[])MyrmexTrades.DESERT_SENTINEL.get(2);
    }

    protected class_2960 method_5991() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    public int method_6110() {
        return 8;
    }

    public class_1297 getHeldEntity() {
        return this.method_5685().isEmpty() ? null : (class_1297)this.method_5685().get(0);
    }

    public void method_6007() {
        double dist;
        boolean hiding;
        super.method_6007();
        class_1309 attackTarget = this.method_5968();
        this.visibleTicks = this.visibleTicks > 0 ? --this.visibleTicks : 0;
        if (attackTarget != null) {
            this.visibleTicks = 100;
        }
        this.daylightTicks = this.canSeeSky() ? ++this.daylightTicks : 0;
        boolean holding = this.getHeldEntity() != null;
        boolean bl = hiding = this.isHiding() && !this.hasCustomer();
        if (holding || this.isOnResin() || attackTarget != null || this.visibleTicks > 0) {
            this.setHiding(false);
        }
        if (holding && this.holdingProgress < 20.0f) {
            this.holdingProgress += 1.0f;
        } else if (!holding && this.holdingProgress > 0.0f) {
            this.holdingProgress -= 1.0f;
        }
        if (hiding) {
            this.method_36456(this.field_5982);
        }
        if (hiding && this.hidingProgress < 20.0f) {
            this.hidingProgress += 1.0f;
        } else if (!hiding && this.hidingProgress > 0.0f) {
            this.hidingProgress -= 1.0f;
        }
        if (this.getHeldEntity() != null) {
            this.setAnimation(ANIMATION_NIBBLE);
            if (this.getAnimationTick() == 5) {
                this.playBiteSound();
                this.getHeldEntity().method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()) / 6.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_GRAB && attackTarget != null && this.getAnimationTick() == 7) {
            this.playStingSound();
            if (this.getAttackBounds().method_994(attackTarget.method_5829())) {
                attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()) / 2.0f);
                if (attackTarget instanceof EntityDragonBase) {
                    if (!((EntityDragonBase)attackTarget).isMobDead()) {
                        attackTarget.method_5804((class_1297)this);
                    }
                } else {
                    attackTarget.method_5804((class_1297)this);
                }
            }
        }
        if (this.getAnimation() == ANIMATION_SLASH && attackTarget != null && this.getAnimationTick() % 5 == 0 && this.getAnimationTick() <= 20) {
            this.playBiteSound();
            if (this.getAttackBounds().method_994(attackTarget.method_5829())) {
                attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()) / 4.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STING && (this.getAnimationTick() == 0 || this.getAnimationTick() == 10)) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && attackTarget != null && (this.getAnimationTick() == 6 || this.getAnimationTick() == 16) && (dist = this.method_5858((class_1297)attackTarget)) < 18.0) {
            attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            attackTarget.method_6092(new class_1293(class_1294.field_5899, 100, 3));
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAIFindHidingSpot(this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAITradePlayer(this));
        this.field_6201.method_6277(0, (class_1352)new MyrmexAILookAtTradePlayer(this));
        this.field_6201.method_6277(1, (class_1352)new MyrmexAIAttackMelee(this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new MyrmexAILeaveHive(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new MyrmexAIWander(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new MyrmexAIDefendHive(this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new MyrmexAIAttackPlayers(this));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1309.class, 4, true, true, (Predicate)((com.google.common.base.Predicate)entity -> entity != null && !EntityMyrmexSentinel.haveSameHive(this, (class_1297)entity) && DragonUtils.isAlive(entity) && !(entity instanceof class_1569))));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HIDING, (Object)Boolean.FALSE);
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23721).method_6192((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 3.0);
    }

    @Override
    public class_2960 getAdultTexture() {
        if (this.isHiding()) {
            return this.isJungle() ? TEXTURE_JUNGLE_HIDDEN : TEXTURE_DESERT_HIDDEN;
        }
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.8f;
    }

    @Override
    public int getCasteImportance() {
        return 2;
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Hiding", this.isHiding());
        tag.method_10569("DaylightTicks", this.daylightTicks);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setHiding(tag.method_10577("Hiding"));
        this.daylightTicks = tag.method_10550("DaylightTicks");
    }

    @Override
    public boolean shouldLeaveHive() {
        return true;
    }

    @Override
    public boolean shouldEnterHive() {
        return false;
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (this.method_5626(passenger)) {
            this.field_6283 = this.method_36454();
            float radius = 1.25f;
            float extraY = 0.35f;
            if (this.getAnimation() == ANIMATION_GRAB) {
                int modTick = class_3532.method_15340((int)this.getAnimationTick(), (int)0, (int)10);
                radius = 3.25f - (float)modTick * 0.2f;
                extraY = (float)modTick * 0.035f;
            }
            float angle = (float)Math.PI / 180 * this.field_6283;
            double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * class_3532.method_15362((float)angle);
            if (passenger.method_17682() >= 1.75f) {
                extraY = passenger.method_17682() - 2.0f;
            }
            passenger.method_5814(this.method_23317() + extraX, this.method_23318() + (double)extraY, this.method_23321() + extraZ);
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if ((double)amount >= 1.0 && !this.method_5685().isEmpty() && this.field_5974.method_43048(2) == 0) {
            for (class_1297 entity : this.method_5685()) {
                entity.method_5848();
            }
        }
        this.visibleTicks = 300;
        this.setHiding(false);
        return super.method_5643(source, amount);
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_SLASH && this.getAnimation() != ANIMATION_GRAB && this.getHeldEntity() == null) {
            if (this.method_6051().method_43048(2) == 0 && entityIn.method_17681() < 2.0f) {
                this.setAnimation(ANIMATION_GRAB);
            } else {
                this.setAnimation(this.method_6051().method_43056() ? ANIMATION_STING : ANIMATION_SLASH);
            }
            this.visibleTicks = 300;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsGaurding() {
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_SLASH, ANIMATION_STING, ANIMATION_GRAB, ANIMATION_NIBBLE};
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.getHeldEntity() == null && !this.isHiding();
    }

    public boolean isHiding() {
        return (Boolean)this.field_6011.method_12789(HIDING);
    }

    public void setHiding(boolean hiding) {
        this.field_6011.method_12778(HIDING, (Object)hiding);
    }

    public int method_19269() {
        return 4;
    }

    public boolean method_19270() {
        return false;
    }

    public boolean method_38069() {
        return this.method_37908().field_9236;
    }
}

