/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.Sets;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexEgg;
import com.iafenvoy.iceandfire.entity.EntityMyrmexQueen;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.MyrmexHive;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexConnectedResin;
import com.iafenvoy.iceandfire.item.block.BlockMyrmexResin;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import com.iafenvoy.iceandfire.world.MyrmexWorldData;
import com.iafenvoy.iceandfire.world.structure.MyrmexHiveStructure;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IPassabilityNavigator;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathResult;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3853;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public abstract class EntityMyrmexBase
extends class_1429
implements IAnimatedEntity,
class_1915,
ICustomSizeNavigator,
IPassabilityNavigator,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_PUPA_WIGGLE = Animation.create((int)20);
    private static final class_2940<Byte> CLIMBING = class_2945.method_12791(EntityMyrmexBase.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> GROWTH_STAGE = class_2945.method_12791(EntityMyrmexBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> VARIANT = class_2945.method_12791(EntityMyrmexBase.class, (class_2941)class_2943.field_13323);
    private static final class_2960 TEXTURE_DESERT_LARVA = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_larva.png");
    private static final class_2960 TEXTURE_DESERT_PUPA = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_pupa.png");
    private static final class_2960 TEXTURE_JUNGLE_LARVA = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_larva.png");
    private static final class_2960 TEXTURE_JUNGLE_PUPA = class_2960.method_43902((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_pupa.png");
    private final class_1277 villagerInventory = new class_1277(8);
    public boolean isEnteringHive = false;
    public boolean isBeingGuarded = false;
    protected int growthTicks = 1;
    protected class_1916 offers;
    private int waitTicks = 0;
    private int animationTick;
    private Animation currentAnimation;
    private MyrmexHive hive;
    private int timeUntilReset;
    private boolean leveledUp;
    private class_1657 customer;

    public EntityMyrmexBase(class_1299<? extends EntityMyrmexBase> t, class_1937 worldIn) {
        super(t, worldIn);
        this.field_6189 = this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.CLIMBING);
    }

    private static boolean isJungleBiome(class_1937 world, class_2338 position) {
        return world.method_23753(position).method_40220(IafBiomeTags.MYRMEX_HIVE_JUNGLE);
    }

    public static boolean haveSameHive(EntityMyrmexBase myrmex, class_1297 entity) {
        if (entity instanceof EntityMyrmexBase) {
            EntityMyrmexBase myrmexBase = (EntityMyrmexBase)entity;
            if (myrmex.getHive() != null && myrmexBase.getHive() != null && myrmex.isJungle() == myrmexBase.isJungle()) {
                return myrmex.getHive().getCenter() == myrmexBase.getHive().getCenter();
            }
        }
        if (entity instanceof EntityMyrmexEgg) {
            EntityMyrmexEgg egg = (EntityMyrmexEgg)entity;
            return myrmex.isJungle() == egg.isJungle();
        }
        return false;
    }

    public static int getRandomCaste(class_1937 world, class_5819 random, boolean royal) {
        float rand = random.method_43057();
        if (royal) {
            if ((double)rand > 0.9) {
                return 2;
            }
            if ((double)rand > 0.75) {
                return 3;
            }
            if ((double)rand > 0.5) {
                return 1;
            }
            return 0;
        }
        if ((double)rand > 0.8) {
            return 3;
        }
        if ((double)rand > 0.6) {
            return 1;
        }
        return 0;
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public boolean canMove() {
        return this.getGrowthStage() > 1;
    }

    public boolean method_6109() {
        return this.getGrowthStage() < 2;
    }

    protected void method_5958() {
        if (!this.hasCustomer() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.leveledUp) {
                    this.levelUp();
                    this.leveledUp = false;
                }
                this.method_6092(new class_1293(class_1294.field_5924, 200, 0));
            }
        }
        if (this.getHive() != null && this.method_8257() != null) {
            this.method_37908().method_8421((class_1297)this, (byte)14);
            this.getHive().setWorld(this.method_37908());
        }
        super.method_5958();
    }

    public int method_6110() {
        return this.getCasteImportance() * 7 + this.method_37908().field_9229.method_43048(3);
    }

    public boolean method_5643(class_1282 dmg, float i) {
        if (dmg == this.method_37908().method_48963().method_48822() && this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getGrowthStage() < 2) {
            this.setAnimation(ANIMATION_PUPA_WIGGLE);
        }
        return super.method_5643(dmg, i);
    }

    protected float method_6106() {
        return 0.52f;
    }

    public float method_6149(class_2338 pos) {
        return this.method_37908().method_8320(pos.method_10074()).method_26204() instanceof BlockMyrmexResin ? 10.0f : super.method_6149(pos);
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.CLIMBING);
    }

    protected class_1408 createNavigator(class_1937 worldIn, AdvancedPathNavigate.MovementType type) {
        return this.createNavigator(worldIn, type, this.method_17681(), this.method_17682());
    }

    protected class_1408 createNavigator(class_1937 worldIn, AdvancedPathNavigate.MovementType type, float width, float height) {
        AdvancedPathNavigate newNavigator = new AdvancedPathNavigate((class_1308)this, this.method_37908(), type, width, height);
        this.field_6189 = newNavigator;
        newNavigator.method_6354(true);
        newNavigator.method_6342().method_20(true);
        return newNavigator;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CLIMBING, (Object)0);
        this.field_6011.method_12784(GROWTH_STAGE, (Object)2);
        this.field_6011.method_12784(VARIANT, (Object)Boolean.FALSE);
    }

    public void method_5773() {
        super.method_5773();
        this.method_49477(1.0f);
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_5980(null);
        }
        if (this.getGrowthStage() < 2 && this.method_5854() != null && this.method_5854() instanceof EntityMyrmexBase) {
            float yaw = this.method_5854().method_36454();
            this.method_36456(yaw);
            this.field_6241 = yaw;
            this.field_6283 = 0.0f;
            this.field_6220 = 0.0f;
        }
        if (!this.method_37908().field_9236) {
            this.setBesideClimbableBlock(this.field_5976 && (this.method_24828() || !this.field_5992));
        }
        if (this.getGrowthStage() < 2) {
            ++this.growthTicks;
            if (this.growthTicks == (Integer)IafCommonConfig.INSTANCE.myrmex.larvaTicks.getValue()) {
                this.setGrowthStage(this.getGrowthStage() + 1);
                this.growthTicks = 0;
            }
        }
        if (!this.method_37908().field_9236 && this.getGrowthStage() < 2 && this.method_6051().method_43048(150) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_PUPA_WIGGLE);
        }
        if (this.method_5968() != null && !(this.method_5968() instanceof class_1657) && this.method_5942().method_6357()) {
            this.method_5980(null);
        }
        if (this.method_5968() != null && (EntityMyrmexBase.haveSameHive(this, (class_1297)this.method_5968()) || this.method_5968() instanceof class_1321 && !this.canAttackTamable((class_1321)this.method_5968()) || this.method_5968() instanceof class_1657 && this.getHive() != null && !this.getHive().isPlayerReputationLowEnoughToFight(this.method_5968().method_5667()))) {
            this.method_5980(null);
        }
        if (this.getWaitTicks() > 0) {
            this.setWaitTicks(this.getWaitTicks() - 1);
        }
        if (this.method_6032() < this.method_6063() && this.field_6012 % 500 == 0 && this.isOnResin()) {
            this.method_6025(1.0f);
            this.method_37908().method_8421((class_1297)this, (byte)76);
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
    }

    public void method_5652(class_2487 tag) {
        class_1916 merchantoffers;
        super.method_5652(tag);
        tag.method_10569("GrowthStage", this.getGrowthStage());
        tag.method_10569("GrowthTicks", this.growthTicks);
        tag.method_10556("Variant", this.isJungle());
        if (this.getHive() != null) {
            tag.method_25927("HiveUUID", this.getHive().hiveUUID);
        }
        if (!(merchantoffers = this.method_8264()).isEmpty()) {
            tag.method_10566("Offers", (class_2520)merchantoffers.method_8268());
        }
        class_2499 listnbt = new class_2499();
        for (int i = 0; i < this.villagerInventory.method_5439(); ++i) {
            class_1799 itemstack = this.villagerInventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            listnbt.add((Object)itemstack.method_7953(new class_2487()));
        }
        tag.method_10566("Inventory", (class_2520)listnbt);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setGrowthStage(tag.method_10550("GrowthStage"));
        this.growthTicks = tag.method_10550("GrowthTicks");
        this.setJungleVariant(tag.method_10577("Variant"));
        if (tag.method_25928("HiveUUID")) {
            this.setHive(MyrmexWorldData.get(this.method_37908()).getHiveFromUUID(tag.method_25926("HiveUUID")));
        }
        if (tag.method_10573("Offers", 10)) {
            this.offers = new class_1916(tag.method_10562("Offers"));
        }
        class_2499 listnbt = tag.method_10554("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            class_1799 itemstack = class_1799.method_7915((class_2487)listnbt.method_10602(i));
            if (itemstack.method_7960()) continue;
            this.villagerInventory.method_5491(itemstack);
        }
        this.setConfigurableAttributes();
    }

    public boolean canAttackTamable(class_1321 tameable) {
        if (tameable.method_35057() != null && this.getHive() != null) {
            return this.getHive().isPlayerReputationLowEnoughToFight(tameable.method_6139());
        }
        return true;
    }

    public class_243 method_19538() {
        return this.method_24515().method_46558();
    }

    public int getGrowthStage() {
        return (Integer)this.field_6011.method_12789(GROWTH_STAGE);
    }

    public void setGrowthStage(int stage) {
        this.field_6011.method_12778(GROWTH_STAGE, (Object)stage);
    }

    public int getWaitTicks() {
        return this.waitTicks;
    }

    public void setWaitTicks(int waitTicks) {
        this.waitTicks = waitTicks;
    }

    public boolean isJungle() {
        return (Boolean)this.field_6011.method_12789(VARIANT);
    }

    public void setJungleVariant(boolean isJungle) {
        this.field_6011.method_12778(VARIANT, (Object)isJungle);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_6011.method_12789(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_6011.method_12789(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_6011.method_12778(CLIMBING, (Object)b0);
    }

    public boolean method_6101() {
        if (this.method_5942() instanceof AdvancedPathNavigate && ((AdvancedPathNavigate)this.method_5942()).entityOnAndBelowPath((class_1297)this, new class_243(1.1, 0.0, 1.1))) {
            return true;
        }
        return super.method_6101();
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE};
    }

    public void method_6015(class_1309 livingBase) {
        if (this.getHive() == null || livingBase == null || livingBase instanceof class_1657 && this.getHive().isPlayerReputationLowEnoughToFight(livingBase.method_5667())) {
            super.method_6015(livingBase);
        }
        if (this.getHive() != null && livingBase != null) {
            this.getHive().addOrRenewAgressor(livingBase, this.getImportance());
        }
        if (this.getHive() != null && livingBase != null && livingBase instanceof class_1657) {
            int i = -5 * this.getCasteImportance();
            this.getHive().setWorld(this.method_37908());
            this.getHive().modifyPlayerReputation(livingBase.method_5667(), i);
            if (this.method_5805()) {
                this.method_37908().method_8421((class_1297)this, (byte)13);
            }
        }
    }

    public void method_6078(class_1282 cause) {
        class_1297 entity;
        if (this.getHive() != null && (entity = cause.method_5529()) != null) {
            this.getHive().setWorld(this.method_37908());
            this.getHive().modifyPlayerReputation(entity.method_5667(), -15);
        }
        this.resetCustomer();
        super.method_6078(cause);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean flag;
        boolean flag2;
        class_1799 itemstack = player.method_5998(hand);
        if (!this.shouldHaveNormalAI()) {
            return class_1269.field_5811;
        }
        boolean bl = flag2 = itemstack.method_7909() == IafItems.MYRMEX_JUNGLE_STAFF.get() || itemstack.method_7909() == IafItems.MYRMEX_DESERT_STAFF.get();
        if (flag2) {
            this.onStaffInteract(player, itemstack);
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        boolean bl2 = flag = itemstack.method_7909() == class_1802.field_8448 || itemstack.method_7909() == class_1802.field_8719;
        if (flag) {
            return super.method_5992(player, hand);
        }
        if (this.getGrowthStage() >= 2 && this.method_5805() && !this.method_6109() && !player.method_5715()) {
            if (this.method_8264().isEmpty()) {
                return super.method_5992(player, hand);
            }
            if (!(this.method_37908().field_9236 || this.method_5968() != null && this.method_5968().equals((Object)player) || hand != class_1268.field_5808 || this.getHive() == null || this.getHive().isPlayerReputationTooLowToTrade(player.method_5667()))) {
                this.method_8259(player);
                this.method_17449(player, this.method_5476(), 1);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return super.method_5992(player, hand);
    }

    public void onStaffInteract(class_1657 player, class_1799 itemstack) {
        UUID staffUUID;
        if (itemstack.method_7969() == null) {
            return;
        }
        UUID uUID = staffUUID = itemstack.method_7969().method_25928("HiveUUID") ? itemstack.method_7969().method_25926("HiveUUID") : null;
        if (this.method_37908().field_9236) {
            return;
        }
        if (!player.method_7337() && this.getHive() != null && !this.getHive().canPlayerCommandHive(player.method_5667())) {
            return;
        }
        if (this.getHive() == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.null_hive"), true);
        } else if (staffUUID != null && staffUUID.equals(this.getHive().hiveUUID)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"myrmex.message.staff_already_set"), true);
        } else {
            this.getHive().setWorld(this.method_37908());
            EntityMyrmexQueen queen = this.getHive().getQueen();
            class_2338 center = this.getHive().getCenterGround();
            if (queen != null && queen.method_16914()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.staff_set_named", (Object[])new Object[]{queen.method_5477(), center.method_10263(), center.method_10264(), center.method_10260()}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"myrmex.message.staff_set_unnamed", (Object[])new Object[]{center.method_10263(), center.method_10264(), center.method_10260()}), true);
            }
            itemstack.method_7969().method_25927("HiveUUID", this.getHive().hiveUUID);
        }
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setHive(MyrmexWorldData.get(this.method_37908()).getNearestHive(this.method_24515(), 400));
        if (this.getHive() != null) {
            this.setJungleVariant(EntityMyrmexBase.isJungleBiome(this.method_37908(), this.getHive().getCenter()));
        } else {
            this.setJungleVariant(this.field_5974.method_43056());
        }
        return spawnDataIn;
    }

    public abstract boolean shouldLeaveHive();

    public abstract boolean shouldEnterHive();

    public float method_17825() {
        return this.getGrowthStage() == 0 ? 0.5f : (this.getGrowthStage() == 1 ? 0.75f : 1.0f);
    }

    public abstract class_2960 getAdultTexture();

    public abstract float getModelScale();

    public class_2960 getTexture() {
        if (this.getGrowthStage() == 0) {
            return this.isJungle() ? TEXTURE_JUNGLE_LARVA : TEXTURE_DESERT_LARVA;
        }
        if (this.getGrowthStage() == 1) {
            return this.isJungle() ? TEXTURE_JUNGLE_PUPA : TEXTURE_DESERT_PUPA;
        }
        return this.getAdultTexture();
    }

    public MyrmexHive getHive() {
        return this.hive;
    }

    public void setHive(MyrmexHive newHive) {
        this.hive = newHive;
        if (this.hive != null) {
            this.hive.addMyrmex(this);
        }
    }

    protected void method_6087(class_1297 entityIn) {
        if (!EntityMyrmexBase.haveSameHive(this, entityIn)) {
            entityIn.method_5697((class_1297)this);
        }
    }

    public boolean canSeeSky() {
        return this.method_37908().method_22348(this.method_24515());
    }

    public boolean isOnResin() {
        int d0 = this.method_31478() - 1;
        class_2338 blockpos = new class_2338(this.method_31477(), d0, this.method_31479());
        while (this.method_37908().method_22347(blockpos) && blockpos.method_10264() > 1) {
            blockpos = blockpos.method_10074();
        }
        class_2680 BlockState = this.method_37908().method_8320(blockpos);
        return BlockState.method_26204() instanceof BlockMyrmexResin || BlockState.method_26204() instanceof BlockMyrmexConnectedResin;
    }

    public boolean isInNursery() {
        if (this.getHive() != null && this.getHive().getRooms(MyrmexHiveStructure.RoomType.NURSERY).isEmpty() && this.getHive().getRandomRoom(MyrmexHiveStructure.RoomType.NURSERY, this.method_6051(), this.method_24515()) != null) {
            return false;
        }
        if (this.getHive() != null) {
            class_2338 nursery = this.getHive().getRandomRoom(MyrmexHiveStructure.RoomType.NURSERY, this.method_6051(), this.method_24515());
            return Math.sqrt(this.method_5649(nursery.method_10263(), nursery.method_10264(), nursery.method_10260())) < 45.0;
        }
        return false;
    }

    public boolean isInHive() {
        if (this.getHive() != null) {
            for (class_2338 pos : this.getHive().getAllRooms()) {
                if (!this.isCloseEnoughToTarget(MyrmexHive.getGroundedPos((class_1936)this.method_37908(), pos), 50.0)) continue;
                return true;
            }
        }
        return false;
    }

    public void method_6091(class_243 motion) {
        if (!this.canMove()) {
            super.method_6091(class_243.field_1353);
            return;
        }
        super.method_6091(motion);
    }

    public int getImportance() {
        if (this.getGrowthStage() < 2) {
            return 1;
        }
        return this.getCasteImportance();
    }

    public abstract int getCasteImportance();

    public boolean needsGaurding() {
        return true;
    }

    public boolean shouldMoveThroughHive() {
        return true;
    }

    public boolean shouldWander() {
        return this.getHive() == null;
    }

    public void method_5711(byte id) {
        if (id == 76) {
            this.playVillagerEffect();
        } else {
            super.method_5711(id);
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)IafSounds.MYRMEX_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)IafSounds.MYRMEX_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)IafSounds.MYRMEX_DIE.get();
    }

    protected void playStepSound(class_2338 pos, class_2248 blockIn) {
        this.method_5783((class_3414)IafSounds.MYRMEX_WALK.get(), 0.16f * this.getMyrmexPitch() * (this.method_6051().method_43057() * 0.6f + 0.4f), 1.0f);
    }

    protected void playBiteSound() {
        this.method_5783((class_3414)IafSounds.MYRMEX_BITE.get(), this.getMyrmexPitch(), 1.0f);
    }

    protected void playStingSound() {
        this.method_5783((class_3414)IafSounds.MYRMEX_STING.get(), this.getMyrmexPitch(), 0.6f);
    }

    protected void playVillagerEffect() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            double d2 = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d1, d2);
        }
    }

    public float getMyrmexPitch() {
        return this.method_17681();
    }

    public boolean shouldHaveNormalAI() {
        return true;
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public class_238 getAttackBounds() {
        float size = this.method_17825() * 0.65f;
        return this.method_5829().method_1009((double)(1.0f + size), (double)(1.0f + size), (double)(1.0f + size));
    }

    public class_1657 method_8257() {
        return this.customer;
    }

    public void method_8259(class_1657 player) {
        this.customer = player;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public class_1916 method_8264() {
        if (this.offers == null) {
            this.offers = new class_1916();
            this.populateTradeData();
        }
        return this.offers;
    }

    public void method_8261(class_1916 offers) {
    }

    public void method_19271(int xpIn) {
    }

    public void method_8262(class_1914 offer) {
        offer.method_8244();
        this.field_6191 = -this.method_5970();
        this.onVillagerTrade(offer);
    }

    protected void onVillagerTrade(class_1914 offer) {
        if (offer.method_8256()) {
            int i = 3 + this.field_5974.method_43048(4);
            this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), i));
        }
        if (this.getHive() != null && this.method_8257() != null) {
            this.getHive().setWorld(this.method_37908());
            this.getHive().modifyPlayerReputation(this.method_8257().method_5667(), 1);
        }
    }

    public void method_8258(class_1799 stack) {
        if (!this.method_37908().field_9236 && this.field_6191 > -this.method_5970() + 20) {
            this.field_6191 = -this.method_5970();
            this.method_5783(this.getVillagerYesNoSound(!stack.method_7960()), this.method_6107(), this.method_6017());
        }
    }

    public class_3414 method_18010() {
        return (class_3414)IafSounds.MYRMEX_IDLE.get();
    }

    protected class_3414 getVillagerYesNoSound(boolean getYesSound) {
        return (class_3414)IafSounds.MYRMEX_IDLE.get();
    }

    protected void resetCustomer() {
        this.method_8259(null);
    }

    public class_1277 getVillagerInventory() {
        return this.villagerInventory;
    }

    public class_1799 method_24523(class_1799 stack) {
        class_1799 superStack = super.method_24523(stack);
        if (class_1799.method_7984((class_1799)superStack, (class_1799)stack) && class_1799.method_7973((class_1799)superStack, (class_1799)stack)) {
            return stack;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            class_1304 inventorySlot = armorItem.method_7685();
            int i = inventorySlot.method_5927() - 300;
            if (i >= 0 && i < this.villagerInventory.method_5439()) {
                this.villagerInventory.method_5447(i, stack);
                return stack;
            }
            return class_1799.field_8037;
        }
        return class_1799.field_8037;
    }

    protected void addTrades(class_1916 givenMerchantOffers, class_3853.class_1652[] newTrades) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > 5) {
            while (set.size() < 5) {
                set.add(this.field_5974.method_43048(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            class_3853.class_1652 villagertrades$itrade = newTrades[integer];
            class_1914 merchantoffer = villagertrades$itrade.method_7246((class_1297)this, this.field_5974);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    private void levelUp() {
        this.populateTradeData();
    }

    protected abstract class_3853.class_1652[] getLevel1Trades();

    protected abstract class_3853.class_1652[] getLevel2Trades();

    protected void populateTradeData() {
        class_3853.class_1652[] level1 = this.getLevel1Trades();
        class_3853.class_1652[] level2 = this.getLevel2Trades();
        if (level1 != null && level2 != null) {
            class_1914 merchantoffer3;
            class_1914 merchantoffer2;
            int rolls;
            class_1916 merchantoffers = this.method_8264();
            this.addTrades(merchantoffers, level1);
            int i = this.field_5974.method_43048(level2.length);
            int j = this.field_5974.method_43048(level2.length);
            int k = this.field_5974.method_43048(level2.length);
            for (rolls = 0; j == i && rolls < 100; ++rolls) {
                j = this.field_5974.method_43048(level2.length);
            }
            for (rolls = 0; (k == i || k == j) && rolls < 100; ++rolls) {
                k = this.field_5974.method_43048(level2.length);
            }
            class_3853.class_1652 rareTrade1 = level2[i];
            class_3853.class_1652 rareTrade2 = level2[j];
            class_3853.class_1652 rareTrade3 = level2[k];
            class_1914 merchantoffer1 = rareTrade1.method_7246((class_1297)this, this.field_5974);
            if (merchantoffer1 != null) {
                merchantoffers.add((Object)merchantoffer1);
            }
            if ((merchantoffer2 = rareTrade2.method_7246((class_1297)this, this.field_5974)) != null) {
                merchantoffers.add((Object)merchantoffer2);
            }
            if ((merchantoffer3 = rareTrade3.method_7246((class_1297)this, this.field_5974)) != null) {
                merchantoffers.add((Object)merchantoffer3);
            }
        }
    }

    public boolean isCloseEnoughToTarget(class_2338 target, double distanceSquared) {
        if (target != null) {
            return this.method_5649((double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5) <= distanceSquared;
        }
        return false;
    }

    public boolean pathReachesTarget(PathResult<?> path, class_2338 target, double distanceSquared) {
        return !path.failedToReachDestination() && (this.isCloseEnoughToTarget(target, distanceSquared) || this.method_5942().method_6345() == null || !this.method_5942().method_6345().method_46());
    }

    public boolean isSmallerThanBlock() {
        return false;
    }

    public float getXZNavSize() {
        return this.method_17681() / 2.0f;
    }

    public int getYNavSize() {
        return (int)this.method_17682() / 2;
    }

    public int maxSearchNodes() {
        return (Integer)IafCommonConfig.INSTANCE.dragon.maxPathingNodes.getValue();
    }

    public boolean isBlockExplicitlyPassable(class_2680 state, class_2338 pos, class_2338 entityPos) {
        return false;
    }

    public boolean isBlockExplicitlyNotPassable(class_2680 state, class_2338 pos, class_2338 entityPos) {
        return state.method_26204() instanceof class_2397;
    }
}

