/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.configdata;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;

public class LooniumMobSpawnData
extends class_6008.class_6009 {
    public static final Codec<LooniumMobSpawnData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41177.method_39673().fieldOf("type").forGetter(msd -> msd.type), (App)class_6007.field_29927.fieldOf("weight").forGetter(class_6008.class_6009::method_34979), (App)Codec.BOOL.optionalFieldOf("spawnAsBaby").forGetter(msd -> Optional.ofNullable(msd.spawnAsBaby)), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(msd -> Optional.ofNullable(msd.nbt)), (App)class_2960.field_25139.optionalFieldOf("equipmentTable").forGetter(msd -> Optional.ofNullable(msd.equipmentTable)), (App)Codec.list(LooniumMobEffectToApply.CODEC).optionalFieldOf("effectsToApply").forGetter(msd -> Optional.ofNullable(msd.effectsToApply)), (App)Codec.list(LooniumMobAttributeModifier.CODEC).optionalFieldOf("attributeModifiers").forGetter(msd -> Optional.ofNullable(msd.attributeModifiers))).apply((Applicative)instance, LooniumMobSpawnData::create));
    public final class_1299<?> type;
    public final Boolean spawnAsBaby;
    public final class_2487 nbt;
    public final class_2960 equipmentTable;
    public final List<LooniumMobEffectToApply> effectsToApply;
    public final List<LooniumMobAttributeModifier> attributeModifiers;

    private LooniumMobSpawnData(class_1299<?> type, class_6007 weight, Boolean spawnAsBaby, @Nullable class_2487 nbt, @Nullable class_2960 equipmentTable, @Nullable List<LooniumMobEffectToApply> effectsToApply, @Nullable List<LooniumMobAttributeModifier> attributeModifiers) {
        super(weight);
        this.type = type;
        this.spawnAsBaby = spawnAsBaby;
        this.nbt = nbt != null ? nbt.method_10553() : null;
        this.equipmentTable = equipmentTable;
        this.effectsToApply = effectsToApply != null ? ImmutableList.copyOf(effectsToApply) : null;
        this.attributeModifiers = attributeModifiers != null ? ImmutableList.copyOf(attributeModifiers) : null;
    }

    public static Builder entityWeight(class_1299<?> type, int weight) {
        return new Builder(type, weight);
    }

    public String toString() {
        return "MobSpawnData{type=" + String.valueOf(this.type) + ", spawnAsBaby=" + this.spawnAsBaby + ", nbt=" + String.valueOf(this.nbt) + ", equipmentTable=" + String.valueOf(this.equipmentTable) + ", effectsToApply=" + String.valueOf(this.effectsToApply) + ", attributeModifiers=" + String.valueOf(this.attributeModifiers) + "}";
    }

    private static LooniumMobSpawnData create(class_1299<?> type, class_6007 weight, Optional<Boolean> spawnAsBaby, Optional<class_2487> nbt, Optional<class_2960> equipmentTable, Optional<List<LooniumMobEffectToApply>> effectsToApply, Optional<List<LooniumMobAttributeModifier>> attributeModifiers) {
        return new LooniumMobSpawnData(type, weight, spawnAsBaby.orElse(null), nbt.orElse(null), equipmentTable.orElse(null), effectsToApply.orElse(null), attributeModifiers.orElse(null));
    }

    public static class Builder {
        private final class_1299<?> type;
        private final int weight;
        @Nullable
        private Boolean spawnAsBaby;
        @Nullable
        private class_2487 nbt;
        @Nullable
        private class_2960 equipmentTable;
        @Nullable
        private List<LooniumMobEffectToApply> effectsToApply;
        @Nullable
        private List<LooniumMobAttributeModifier> attributeModifiers;

        private Builder(class_1299<?> type, int weight) {
            this.type = type;
            this.weight = weight;
        }

        public Builder spawnAsBaby() {
            this.spawnAsBaby = true;
            return this;
        }

        public Builder spawnAsAdult() {
            this.spawnAsBaby = false;
            return this;
        }

        public Builder nbt(class_2487 nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder equipmentTable(class_2960 equipmentTable) {
            this.equipmentTable = equipmentTable;
            return this;
        }

        public Builder effectsToApply(LooniumMobEffectToApply ... effectsToApply) {
            this.effectsToApply = List.of(effectsToApply);
            return this;
        }

        public Builder attributeModifiers(LooniumMobAttributeModifier ... attributeModifiers) {
            this.attributeModifiers = List.of(attributeModifiers);
            return this;
        }

        public LooniumMobSpawnData build() {
            return new LooniumMobSpawnData(this.type, class_6007.method_34977((int)this.weight), this.spawnAsBaby, this.nbt, this.equipmentTable, this.effectsToApply, this.attributeModifiers);
        }
    }
}

