/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2401;
import net.minecraft.class_2453;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_6302;

@GameTestGroup(path="contraptions")
public class TestContraptions {
    @class_6302(method_35936="arrow_dispenser", method_35932=200)
    public static void arrowDispenser(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(2, 3, 1);
        helper.method_36039(lever);
        class_2338 pos1 = new class_2338(0, 5, 0);
        class_2338 pos2 = new class_2338(4, 5, 4);
        helper.method_36018(() -> {
            helper.assertSecondsPassed(7);
            List arrows = helper.getEntitiesBetween(class_1299.field_6122, pos1, pos2);
            if (arrows.size() != 4) {
                helper.method_35995("Expected 4 arrows");
            }
            helper.powerLever(lever);
            class_2338 dispenser = new class_2338(2, 5, 2);
            helper.method_35983(dispenser, class_1802.field_8107);
        });
    }

    @class_6302(method_35936="crop_farming", method_35932=200)
    public static void cropFarming(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(4, 3, 1);
        helper.method_36039(lever);
        class_2338 output = new class_2338(1, 3, 12);
        helper.method_36018(() -> helper.assertAnyContained(output, class_1802.field_8861, class_1802.field_8567, class_1802.field_8179));
    }

    @class_6302(method_35936="mounted_item_extract", method_35932=400)
    public static void mountedItemExtract(CreateGameTestHelper helper) {
        class_2338 barrel = new class_2338(1, 3, 2);
        Object2LongMap<class_1792> content = helper.getItemContent(barrel);
        class_2338 lever = new class_2338(1, 5, 1);
        helper.method_36039(lever);
        class_2338 outputPos = new class_2338(4, 2, 1);
        helper.method_36018(() -> {
            helper.assertContentPresent(content, outputPos);
            helper.powerLever(lever);
            helper.method_36047(barrel);
        });
    }

    @class_6302(method_35936="mounted_fluid_drain", method_35932=200)
    public static void mountedFluidDrain(CreateGameTestHelper helper) {
        class_2338 tank = new class_2338(1, 3, 2);
        FluidStack fluid = helper.getTankContents(tank);
        if (fluid.isEmpty()) {
            helper.method_35995("Tank empty");
        }
        class_2338 lever = new class_2338(1, 5, 1);
        helper.method_36039(lever);
        class_2338 output = new class_2338(4, 2, 1);
        helper.method_36018(() -> {
            helper.assertFluidPresent(fluid, output);
            helper.powerLever(lever);
            helper.assertTankEmpty(tank);
        });
    }

    @class_6302(method_35936="ploughing")
    public static void ploughing(CreateGameTestHelper helper) {
        class_2338 dirt = new class_2338(4, 2, 1);
        class_2338 lever = new class_2338(3, 3, 2);
        helper.method_36039(lever);
        helper.method_36018(() -> helper.method_35972(class_2246.field_10362, dirt));
    }

    @class_6302(method_35936="redstone_contacts")
    public static void redstoneContacts(CreateGameTestHelper helper) {
        class_2338 end = new class_2338(5, 10, 1);
        class_2338 lever = new class_2338(1, 3, 2);
        helper.method_36039(lever);
        helper.method_36018(() -> helper.method_35972(class_2246.field_10201, end));
    }

    @class_6302(method_35936="controls", method_35932=200)
    public static void controls(CreateGameTestHelper helper) {
        class_2338 button = new class_2338(5, 5, 4);
        class_2338 gearshift = new class_2338(4, 5, 4);
        class_2338 bearingPos = new class_2338(4, 4, 4);
        AtomicInteger step = new AtomicInteger(1);
        List<class_2338> dirt = List.of(new class_2338(4, 2, 6), new class_2338(2, 2, 4), new class_2338(4, 2, 2));
        List<class_2338> wheat = List.of(new class_2338(4, 3, 7), new class_2338(1, 3, 4), new class_2338(4, 3, 1));
        helper.method_36026(button);
        helper.method_36018(() -> {
            helper.method_35987(gearshift, (class_2769)SequencedGearshiftBlock.STATE, Integer.valueOf(0));
            if (step.get() == 4) {
                return;
            }
            MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.MECHANICAL_BEARING.get(), bearingPos);
            if (bearing.getMovedContraption() == null) {
                helper.method_35995("Contraption not assembled");
            }
            Contraption contraption = bearing.getMovedContraption().getContraption();
            switch (step.get()) {
                case 1: {
                    helper.method_35972(class_2246.field_10362, (class_2338)dirt.get(0));
                    helper.method_35987((class_2338)wheat.get(0), (class_2769)class_2302.field_10835, Integer.valueOf(0));
                    helper.toggleActorsOfType(contraption, (class_1935)AllBlocks.MECHANICAL_HARVESTER.get());
                    helper.method_36026(button);
                    step.incrementAndGet();
                    helper.method_35995("Entering step 2");
                    break;
                }
                case 2: {
                    helper.method_35972(class_2246.field_10362, (class_2338)dirt.get(1));
                    helper.method_35987((class_2338)wheat.get(1), (class_2769)class_2302.field_10835, Integer.valueOf(7));
                    helper.toggleActorsOfType(contraption, (class_1935)AllBlocks.MECHANICAL_PLOUGH.get());
                    helper.method_36026(button);
                    step.incrementAndGet();
                    helper.method_35995("Entering step 3");
                    break;
                }
                case 3: {
                    helper.method_35972(class_2246.field_10566, (class_2338)dirt.get(2));
                    helper.method_35987((class_2338)wheat.get(2), (class_2769)class_2302.field_10835, Integer.valueOf(7));
                    helper.method_36026(button);
                    step.incrementAndGet();
                    helper.method_35995("Entering step 4");
                }
            }
        });
    }

    @class_6302(method_35936="elevator")
    public static void elevator(CreateGameTestHelper helper) {
        class_2338 pulley = new class_2338(5, 12, 3);
        class_2338 secondaryPulley = new class_2338(5, 12, 1);
        class_2338 bottomLamp = new class_2338(2, 3, 2);
        class_2338 topLamp = new class_2338(2, 12, 2);
        class_2338 lever = new class_2338(1, 11, 2);
        class_2338 elevatorStart = new class_2338(4, 2, 2);
        class_2338 cowSpawn = new class_2338(4, 4, 2);
        class_2338 cowEnd = new class_2338(4, 13, 2);
        helper.method_35951(1L, () -> helper.method_35964(class_1299.field_6085, cowSpawn));
        helper.method_35951(15L, () -> ((ElevatorPulleyBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.ELEVATOR_PULLEY.get(), pulley)).clicked());
        helper.method_36018(() -> {
            helper.assertSecondsPassed(1);
            if (!((Boolean)helper.method_35980(lever).method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                helper.getFirstEntity((class_1299)AllEntityTypes.CONTROLLED_CONTRAPTION.get(), elevatorStart);
                helper.method_35987(topLamp, (class_2769)class_2453.field_11413, Boolean.valueOf(false));
                helper.method_35987(bottomLamp, (class_2769)class_2453.field_11413, Boolean.valueOf(true));
                ElevatorPulleyBlockEntity secondary = (ElevatorPulleyBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.ELEVATOR_PULLEY.get(), secondaryPulley);
                if (secondary.getMirrorParent() == null) {
                    helper.method_35995("Secondary pulley has no parent");
                }
                helper.method_36039(lever);
                helper.method_35995("Entering step 2");
            } else {
                helper.method_35987(topLamp, (class_2769)class_2453.field_11413, Boolean.valueOf(true));
                helper.method_35987(bottomLamp, (class_2769)class_2453.field_11413, Boolean.valueOf(false));
                helper.method_36023(class_1299.field_6085, cowEnd);
                ((ElevatorPulleyBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.ELEVATOR_PULLEY.get(), pulley)).clicked();
            }
        });
    }

    @class_6302(method_35936="roller_filling")
    public static void rollerFilling(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(7, 6, 1);
        class_2338 barrelEnd = new class_2338(2, 5, 2);
        List existing = class_2338.method_20437((class_2338)new class_2338(1, 3, 2), (class_2338)new class_2338(4, 2, 2)).toList();
        List<class_2338> filled = class_2338.method_20437((class_2338)new class_2338(1, 2, 1), (class_2338)new class_2338(4, 3, 3)).filter(pos -> !existing.contains(pos)).toList();
        List tracks = class_2338.method_20437((class_2338)new class_2338(1, 4, 2), (class_2338)new class_2338(4, 4, 2)).toList();
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.assertSecondsPassed(4);
            existing.forEach(pos -> helper.method_35972((class_2248)AllBlocks.RAILWAY_CASING.get(), (class_2338)pos));
            filled.forEach(pos -> helper.method_35972((class_2248)AllBlocks.ANDESITE_CASING.get(), (class_2338)pos));
            tracks.forEach(pos -> helper.method_35972((class_2248)AllBlocks.TRACK.get(), (class_2338)pos));
            helper.method_36047(barrelEnd);
        });
    }

    @class_6302(method_35936="roller_paving_and_clearing", method_35932=200)
    public static void rollerPavingAndClearing(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(8, 5, 1);
        List paved = class_2338.method_20437((class_2338)new class_2338(1, 2, 1), (class_2338)new class_2338(4, 2, 1)).toList();
        class_2338 cleared = new class_2338(2, 3, 1);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.assertSecondsPassed(9);
            paved.forEach(pos -> helper.method_35972((class_2248)AllBlocks.ANDESITE_CASING.get(), (class_2338)pos));
            helper.method_35972(class_2246.field_10124, cleared);
        });
    }
}

