/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client;

import forge.net.mca.Config;
import forge.net.mca.client.LanguageMap;
import forge.net.mca.client.OnlineSpeechManager;
import forge.net.mca.entity.CommonSpeechManager;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.util.LimitedLinkedHashMap;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class SpeechManager {
    public static final SpeechManager INSTANCE = new SpeechManager();
    public static final int TOTAL_VOICES = 10;
    private final LimitedLinkedHashMap<UUID, EntityBoundSoundInstance> currentlyPlaying = new LimitedLinkedHashMap(10);
    private final RandomSource threadSafeRandom = RandomSource.m_216337_();

    public void onChatMessage(Component message, UUID sender) {
        ComponentContents content = message.m_214077_();
        if (CommonSpeechManager.INSTANCE.translations.containsKey(content)) {
            this.speak((String)CommonSpeechManager.INSTANCE.translations.get(content), sender);
        } else {
            for (Component sibling : message.m_7360_()) {
                if (!CommonSpeechManager.INSTANCE.translations.containsKey(sibling.m_214077_())) continue;
                this.speak((String)CommonSpeechManager.INSTANCE.translations.get(sibling.m_214077_()), sender);
            }
        }
    }

    private VillagerEntityMCA getSpeaker(Minecraft client, UUID sender) {
        if (client.f_91073_ != null) {
            for (Entity entity : client.f_91073_.m_104735_()) {
                if (!(entity instanceof VillagerEntityMCA)) continue;
                VillagerEntityMCA v = (VillagerEntityMCA)entity;
                if (!entity.m_20148_().equals(sender)) continue;
                return v;
            }
        }
        return null;
    }

    private void speak(String phrase, UUID sender) {
        VillagerEntityMCA villager;
        if (this.currentlyPlaying.containsKey(sender) && Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this.currentlyPlaying.get(sender))) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null && (villager = this.getSpeaker(client, sender)) != null) {
            if (villager.isSpeechImpaired()) {
                return;
            }
            if (villager.isToYoungToSpeak()) {
                return;
            }
            float pitch = villager.m_6100_();
            float gene = villager.getGenetics().getGene(Genetics.VOICE_TONE);
            String gender = villager.getGenetics().getGender().binary().getDataName();
            if (Config.getInstance().enableOnlineTTS) {
                String gameLang = client.f_91066_.f_92075_;
                if (LanguageMap.LANGUAGE_MAP.containsKey(gameLang) && !LanguageMap.LANGUAGE_MAP.get(gameLang).isEmpty()) {
                    String content = Language.m_128107_().m_6834_(phrase);
                    int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
                    String voice = gender + "_" + tone;
                    OnlineSpeechManager.INSTANCE.play(LanguageMap.LANGUAGE_MAP.get(gameLang), voice, pitch, content, (Entity)villager);
                } else {
                    MutableComponent styled = Component.m_237115_((String)"command.tts_unsupported_language").m_130938_(s -> s.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Luke100000/minecraft-comes-alive/wiki/TTS")));
                    client.f_91065_.m_93076_().m_93785_((Component)styled);
                }
            } else {
                Collection keys;
                int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
                ResourceLocation sound = new ResourceLocation("mca_voices", phrase.toLowerCase(Locale.ROOT) + "/" + gender + "_" + tone);
                if (client.f_91073_ != null && client.f_91074_ != null && (keys = client.m_91106_().m_120354_()).contains(sound)) {
                    EntityBoundSoundInstance instance = new EntityBoundSoundInstance(SoundEvent.m_262824_((ResourceLocation)sound), SoundSource.NEUTRAL, 1.0f, pitch, (Entity)villager, this.threadSafeRandom.m_188505_());
                    this.currentlyPlaying.put(sender, instance);
                    client.m_91106_().m_120367_((SoundInstance)instance);
                }
            }
        }
    }
}

