/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.util.AEColor;
import appeng.block.paint.PaintSplotches;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.helpers.Splotch;
import appeng.items.misc.PaintBallItem;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class PaintSplotchesBlockEntity
extends AEBaseBlockEntity {
    private List<Splotch> dots = null;

    public PaintSplotchesBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        class_2540 myDat = new class_2540(Unpooled.buffer());
        this.writeBuffer(myDat);
        if (myDat.hasArray()) {
            data.method_10570("dots", myDat.array());
        }
    }

    private void writeBuffer(class_2540 out) {
        if (this.dots == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(this.dots.size());
        for (Splotch s : this.dots) {
            s.writeToStream(out);
        }
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        if (data.method_10545("dots")) {
            this.readBuffer(new class_2540(Unpooled.copiedBuffer((byte[])data.method_10547("dots"))));
        }
    }

    private void readBuffer(class_2540 in) {
        int howMany = in.readByte();
        if (howMany == 0) {
            this.dots = null;
            return;
        }
        this.dots = new ArrayList<Splotch>(howMany);
        for (int x = 0; x < howMany; ++x) {
            this.dots.add(new Splotch(in));
        }
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        this.writeBuffer(data);
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        super.readFromStream(data);
        this.readBuffer(data);
        return true;
    }

    public void neighborChanged() {
        if (this.dots == null) {
            return;
        }
        for (class_2350 side : class_2350.values()) {
            if (this.isSideValid(side)) continue;
            this.removeSide(side);
        }
        this.updateData();
    }

    public boolean isSideValid(class_2350 side) {
        class_2338 p = this.field_11867.method_10093(side);
        class_2680 blk = this.field_11863.method_8320(p);
        return blk.method_26206((class_1922)this.field_11863, p, side.method_10153());
    }

    private void removeSide(class_2350 side) {
        this.dots.removeIf(s -> s.getSide() == side);
        this.markForUpdate();
        this.saveChanges();
    }

    private void updateData() {
        if (this.dots.isEmpty()) {
            this.dots = null;
        }
        if (this.dots == null) {
            this.field_11863.method_8650(this.field_11867, false);
        } else {
            int lumenCount = 0;
            for (Splotch dot : this.dots) {
                if (dot.isLumen() && ++lumenCount >= 2) break;
            }
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)PaintSplotchesBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lumenCount)));
        }
    }

    public void cleanSide(class_2350 side) {
        if (this.dots == null) {
            return;
        }
        this.removeSide(side);
        this.updateData();
    }

    public void addBlot(class_1799 type, class_2350 side, class_243 hitVec) {
        class_2338 p = this.field_11867.method_10093(side);
        class_2680 blk = this.field_11863.method_8320(p);
        if (blk.method_26206((class_1922)this.field_11863, p, side.method_10153())) {
            PaintBallItem ipb = (PaintBallItem)type.method_7909();
            AEColor col = ipb.getColor();
            boolean lit = ipb.isLumen();
            if (this.dots == null) {
                this.dots = new ArrayList<Splotch>();
            }
            if (this.dots.size() > 20) {
                this.dots.remove(0);
            }
            this.dots.add(new Splotch(col, lit, side, hitVec));
            this.updateData();
            this.markForUpdate();
            this.saveChanges();
        }
    }

    public Collection<Splotch> getDots() {
        if (this.dots == null) {
            return Collections.emptyList();
        }
        return this.dots;
    }

    @Override
    public Object getRenderAttachmentData() {
        return new PaintSplotches(this.getDots());
    }
}

