/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fuzs.universalenchants.core.CommonAbstractions;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1743;
import net.minecraft.class_1819;
import net.minecraft.class_1882;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1900;
import net.minecraft.class_4059;
import net.minecraft.class_7923;

public class AdditionalEnchantmentDataProvider {
    static final String ENCHANTMENT_CATEGORY_PREFIX = "Universal Enchants".toUpperCase(Locale.ROOT).replace(" ", "_") + "_";
    public static final class_1886 AXE_ENCHANTMENT_CATEGORY = CommonAbstractions.INSTANCE.createEnchantmentCategory(ENCHANTMENT_CATEGORY_PREFIX + "AXE", item -> item instanceof class_1743);
    public static final class_1886 HORSE_ARMOR_ENCHANTMENT_CATEGORY = CommonAbstractions.INSTANCE.createEnchantmentCategory(ENCHANTMENT_CATEGORY_PREFIX + "HORSE_ARMOR", item -> item instanceof class_4059);
    public static final class_1886 SHIELD_ENCHANTMENT_CATEGORY = CommonAbstractions.INSTANCE.createEnchantmentCategory(ENCHANTMENT_CATEGORY_PREFIX + "SHIELD", item -> item instanceof class_1819);
    public static final AdditionalEnchantmentDataProvider INSTANCE = new AdditionalEnchantmentDataProvider();
    private final List<AdditionalEnchantmentsData> additionalEnchantmentsData = ImmutableList.of((Object)new AdditionalEnchantmentsData(class_1886.field_9074, class_1893.field_9106), (Object)new AdditionalEnchantmentsData(AXE_ENCHANTMENT_CATEGORY, class_1893.field_9118, class_1893.field_9123, class_1893.field_9112, class_1893.field_9121, class_1893.field_9124, class_1893.field_9110, class_1893.field_9115, class_1893.field_9106), (Object)new AdditionalEnchantmentsData(class_1886.field_9073, class_1893.field_9118, class_1893.field_9123, class_1893.field_9112, class_1893.field_9121, class_1893.field_9124, class_1893.field_9110, class_1893.field_9115, class_1893.field_9098, class_1893.field_9132), (Object)new AdditionalEnchantmentsData(class_1886.field_9070, class_1893.field_9132, class_1893.field_9108, class_1893.field_9098, class_1893.field_9110), (Object)new AdditionalEnchantmentsData(class_1886.field_9081, class_1893.field_9126, class_1893.field_9116, class_1893.field_9103, class_1893.field_9125, class_1893.field_9110), (Object)new AdditionalEnchantmentsData(HORSE_ARMOR_ENCHANTMENT_CATEGORY, class_1893.field_9111, class_1893.field_9095, class_1893.field_9129, class_1893.field_9107, class_1893.field_9096, class_1893.field_9127, class_1893.field_9097, class_1893.field_9128, class_1893.field_9122, class_1893.field_9113, class_1893.field_23071, class_1893.field_9109), (Object)new AdditionalEnchantmentsData(SHIELD_ENCHANTMENT_CATEGORY, class_1893.field_9097, class_1893.field_9121));
    private Map<class_1887, List<DataEntry<?>>> defaultCategoryEntries;

    private AdditionalEnchantmentDataProvider() {
    }

    public void initialize() {
    }

    public Map<class_1887, List<DataEntry<?>>> getEnchantmentDataEntries() {
        if (this.defaultCategoryEntries == null) {
            Map<class_1887, DataEntry.Builder> builders = class_7923.field_41176.method_10220().collect(Collectors.toMap(Function.identity(), CommonAbstractions.INSTANCE::defaultEnchantmentDataBuilder));
            this.additionalEnchantmentsData.forEach(data -> data.addToBuilder(builders));
            AdditionalEnchantmentDataProvider.setupAdditionalCompatibility(builders);
            this.defaultCategoryEntries = (Map)builders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((DataEntry.Builder)e.getValue()).build()));
        }
        return this.defaultCategoryEntries;
    }

    private static void setupAdditionalCompatibility(Map<class_1887, DataEntry.Builder> builders) {
        AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, class_1893.field_9125, class_1893.field_9101, false);
        AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, class_1893.field_9108, class_1893.field_9132, false);
        for (class_1887 enchantment : class_7923.field_41176) {
            if (enchantment instanceof class_1882 && enchantment != class_1893.field_9118) {
                AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, class_1893.field_9118, enchantment, false);
                AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, class_1893.field_9106, enchantment, true);
            }
            if (!(enchantment instanceof class_1900) || enchantment == class_1893.field_9111 || enchantment == class_1893.field_9129) continue;
            AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, class_1893.field_9111, enchantment, false);
        }
    }

    private static void applyIncompatibilityToBoth(Map<class_1887, DataEntry.Builder> builders, class_1887 enchantment, class_1887 other, boolean add) {
        BiConsumer<class_1887, class_1887> operation = (e1, e2) -> {
            DataEntry.Builder builder = (DataEntry.Builder)builders.get(e1);
            if (builder == null) {
                return;
            }
            if (add) {
                builder.add((class_1887)e2);
            } else {
                builder.remove((class_1887)e2);
            }
        };
        operation.accept(enchantment, other);
        operation.accept(other, enchantment);
    }

    private record AdditionalEnchantmentsData(class_1886 category, List<class_1887> enchantments) {
        AdditionalEnchantmentsData(class_1886 category, class_1887 ... enchantments) {
            this(category, (List<class_1887>)ImmutableList.copyOf((Object[])enchantments));
        }

        public void addToBuilder(Map<class_1887, DataEntry.Builder> builders) {
            for (class_1887 enchantment : this.enchantments) {
                if (!builders.containsKey(enchantment)) continue;
                builders.get(enchantment).add(this.category);
            }
        }
    }
}

