/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.universalenchants.capability.ArrowLootingCapability;
import fuzs.universalenchants.init.ModRegistry;
import fuzs.universalenchants.mixin.accessor.AbstractArrowAccessor;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class ItemCompatHandler {
    public static EventResult onArrowLoose(class_1657 player, class_1799 stack, class_1937 level, MutableInt charge, boolean hasAmmo) {
        if (hasAmmo && class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)stack) > 0) {
            float velocity = class_1753.method_7722((int)charge.getAsInt());
            if (!level.field_9236 && velocity >= 0.1f) {
                class_1799 itemstack = player.method_18808(stack);
                class_1744 arrowitem = (class_1744)(itemstack.method_7909() instanceof class_1744 ? itemstack.method_7909() : class_1802.field_8107);
                float[] shotPitches = ItemCompatHandler.getShotPitches(level.field_9229, velocity);
                for (int i = 0; i < 2; ++i) {
                    class_1665 abstractarrow = arrowitem.method_7702(level, itemstack, (class_1309)player);
                    abstractarrow.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, velocity * 3.0f, 1.5f);
                    ItemCompatHandler.applyPowerEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyPunchEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyFlameEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyPiercingEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyLootingEnchantment(abstractarrow, stack);
                    abstractarrow.field_7572 = class_1665.class_1666.field_7594;
                    level.method_8649((class_1297)abstractarrow);
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, shotPitches[i + 1]);
                }
            }
        }
        return EventResult.PASS;
    }

    private static float[] getShotPitches(class_5819 random, float velocity) {
        boolean flag = random.method_43056();
        return new float[]{1.0f, ItemCompatHandler.getRandomShotPitch(flag, random, velocity), ItemCompatHandler.getRandomShotPitch(!flag, random, velocity)};
    }

    private static float getRandomShotPitch(boolean p_150798_, class_5819 random, float velocity) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f * velocity;
    }

    public static EventResult onUseItemTick(class_1309 entity, class_1799 useItem, MutableInt useItemRemaining) {
        class_1792 item2 = useItem.method_7909();
        int duration2 = useItem.method_7935() - useItemRemaining.getAsInt();
        if (item2 instanceof class_1753 && duration2 < 20 || item2 instanceof class_1835 && duration2 < 10) {
            int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)useItem);
            useItemRemaining.mapInt(duration -> duration - quickChargeLevel);
        }
        return EventResult.PASS;
    }

    public static void onLootingLevel(class_1309 entity, @Nullable class_1282 damageSource, MutableInt lootingLevel) {
        if (damageSource == null) {
            return;
        }
        class_1297 source = damageSource.method_5526();
        if (source instanceof class_1665) {
            if (source instanceof class_1685) {
                class_1799 stack = ((AbstractArrowAccessor)source).callGetPickupItem();
                int level = class_1890.method_8225((class_1887)class_1893.field_9110, (class_1799)stack);
                if (level > 0) {
                    lootingLevel.accept(level);
                }
            } else {
                lootingLevel.accept((int)ModRegistry.ARROW_LOOTING_CAPABILITY.maybeGet((Object)source).map(ArrowLootingCapability::getLevel).orElse((byte)0).byteValue());
            }
        }
    }

    public static Optional<class_3902> onShieldBlock(class_1309 blocker, class_1282 source, float amount) {
        class_1297 class_12972;
        if (!source.method_48789(class_8103.field_42247) && (class_12972 = source.method_5526()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            int level = class_1890.method_8225((class_1887)class_1893.field_9097, (class_1799)blocker.method_6030());
            class_1893.field_9097.method_8178(blocker, (class_1297)attacker, level);
        }
        return Optional.empty();
    }

    public static void applyPowerEnchantment(class_1665 arrow, class_1799 stack) {
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack);
        if (powerLevel > 0) {
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
    }

    public static void applyPunchEnchantment(class_1665 arrow, class_1799 stack) {
        int punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack);
        if (punchLevel > 0) {
            arrow.method_7449(punchLevel);
        }
    }

    public static void applyFlameEnchantment(class_1665 arrow, class_1799 stack) {
        if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0) {
            arrow.method_5639(100);
        }
    }

    public static void applyPiercingEnchantment(class_1665 arrow, class_1799 stack) {
        int pierceLevel = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)stack);
        if (pierceLevel > 0) {
            arrow.method_7451((byte)pierceLevel);
        }
    }

    public static void applyLootingEnchantment(class_1665 arrow, class_1799 stack) {
        int level = class_1890.method_8225((class_1887)class_1893.field_9110, (class_1799)stack);
        if (level > 0) {
            ModRegistry.ARROW_LOOTING_CAPABILITY.maybeGet((Object)arrow).ifPresent(capability -> capability.setLevel((byte)level));
        }
    }
}

