/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.recipes.ban;

import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.aether.recipe.serializer.PlacementBanRecipeSerializer;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1865;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class BlockBanRecipe
extends AbstractPlacementBanRecipe<class_2680, BlockStateIngredient> {
    public BlockBanRecipe(class_2960 id, @Nullable class_5321<class_1959> biomeKey, @Nullable class_6862<class_1959> biomeTag, BlockStateIngredient bypassBlock, BlockStateIngredient ingredient) {
        super((class_3956)AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get(), id, biomeKey, biomeTag, bypassBlock, ingredient);
    }

    public BlockBanRecipe(class_2960 id, @Nullable class_5321<class_1959> biomeKey, @Nullable class_6862<class_1959> biomeTag, BlockStateIngredient bypassBlock) {
        this(id, biomeKey, biomeTag, bypassBlock, BlockStateIngredient.EMPTY);
    }

    public boolean banBlock(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.matches(level, pos.method_10074(), state) && AetherEventDispatch.isBlockPlacementBanned((class_1936)level, pos, state)) {
            AetherEventDispatch.onPlacementSpawnParticles((class_1936)level, pos, null, null, state);
            return true;
        }
        return false;
    }

    public class_1865<?> method_8119() {
        return (class_1865)AetherRecipeSerializers.BLOCK_PLACEMENT_BAN.get();
    }

    public static class Serializer
    extends PlacementBanRecipeSerializer<class_2680, BlockStateIngredient, BlockBanRecipe> {
        public Serializer() {
            super(BlockBanRecipe::new);
        }

        @Override
        public BlockBanRecipe fromJson(class_2960 id, JsonObject json) {
            BlockBanRecipe recipe = (BlockBanRecipe)super.fromJson(id, json);
            if (!json.has("ingredient")) {
                throw new JsonSyntaxException("Missing ingredient, expected to find an object or array");
            }
            JsonArray jsonElement = class_3518.method_15264((JsonObject)json, (String)"ingredient") ? class_3518.method_15261((JsonObject)json, (String)"ingredient") : class_3518.method_15296((JsonObject)json, (String)"ingredient");
            BlockStateIngredient ingredient = BlockStateIngredient.fromJson((JsonElement)jsonElement);
            return new BlockBanRecipe(id, recipe.getBiomeKey(), recipe.getBiomeTag(), recipe.getBypassBlock(), ingredient);
        }

        @Override
        @Nullable
        public BlockBanRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            class_5321 biomeKey = BlockStateRecipeUtil.readBiomeKey((class_2540)buffer);
            class_6862 biomeTag = BlockStateRecipeUtil.readBiomeTag((class_2540)buffer);
            BlockStateIngredient bypassBlock = BlockStateIngredient.fromNetwork((class_2540)buffer);
            BlockStateIngredient ingredient = BlockStateIngredient.fromNetwork((class_2540)buffer);
            return new BlockBanRecipe(id, (class_5321<class_1959>)biomeKey, (class_6862<class_1959>)biomeTag, bypassBlock, ingredient);
        }

        @Override
        public void toNetwork(class_2540 buffer, BlockBanRecipe recipe) {
            super.toNetwork(buffer, recipe);
            ((BlockStateIngredient)recipe.getIngredient()).toNetwork(buffer);
        }
    }
}

