/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.client.gui.screen.perks.MoaSkinsScreen;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.layers.MoaEmissiveLayer;
import com.aetherteam.aether.client.renderer.entity.layers.MoaHatEmissiveLayer;
import com.aetherteam.aether.client.renderer.entity.layers.MoaHatLayer;
import com.aetherteam.aether.client.renderer.entity.layers.MoaSaddleEmissiveLayer;
import com.aetherteam.aether.client.renderer.entity.layers.MoaSaddleLayer;
import com.aetherteam.aether.client.renderer.entity.model.MoaModel;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_927;
import org.jetbrains.annotations.Nullable;

public class MoaRenderer
extends class_927<Moa, MoaModel> {
    private static final class_2960 DEFAULT_TEXTURE = new class_2960("aether", "textures/entity/mobs/moa/white_moa.png");
    private static final class_2960 MOS_TEXTURE = new class_2960("aether", "textures/entity/mobs/moa/mos.png");
    private static final class_2960 RAPTOR_TEXTURE = new class_2960("aether", "textures/entity/mobs/moa/raptor.png");

    public MoaRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new MoaModel(context.method_32167(AetherModelLayers.MOA)), 0.7f);
        this.method_4046(new MoaEmissiveLayer((class_3883<Moa, MoaModel>)this));
        this.method_4046(new MoaHatLayer((class_3883<Moa, MoaModel>)this, new MoaModel(context.method_32167(AetherModelLayers.MOA_HAT))));
        this.method_4046(new MoaHatEmissiveLayer((class_3883<Moa, MoaModel>)this, new MoaModel(context.method_32167(AetherModelLayers.MOA_HAT))));
        this.method_4046(new MoaSaddleLayer((class_3883<Moa, MoaModel>)this, new MoaModel(context.method_32167(AetherModelLayers.MOA_SADDLE))));
        this.method_4046(new MoaSaddleEmissiveLayer((class_3883<Moa, MoaModel>)this, new MoaModel(context.method_32167(AetherModelLayers.MOA_SADDLE))));
    }

    protected void scale(Moa moa, class_4587 poseStack, float partialTicks) {
        float moaScale = moa.method_6109() ? 1.0f : 1.8f;
        poseStack.method_22905(moaScale, moaScale, moaScale);
        if (moa.isSitting()) {
            poseStack.method_22904(0.0, 0.5, 0.0);
        }
    }

    protected float getBob(Moa moa, float partialTicks) {
        return ((MoaModel)this.field_4737).setupWingsAnimation(moa, partialTicks);
    }

    public class_2960 getTextureLocation(Moa moa) {
        return MoaRenderer.getTexture(moa);
    }

    public static class_2960 getTexture(Moa moa) {
        class_2960 moaSkin = MoaRenderer.getMoaSkinLocation(moa);
        if (moaSkin != null) {
            return moaSkin;
        }
        if (moa.method_16914() && moa.method_5477().getString().equals("Mos")) {
            return MOS_TEXTURE;
        }
        if (moa.method_16914() && moa.method_5477().getString().equals("Raptor__") && moa.getMoaType() == AetherMoaTypes.BLUE.get() || moa.getRider() != null && moa.getRider().equals(UUID.fromString("c3e6871e-8e60-490a-8a8d-2bbe35ad1604"))) {
            return RAPTOR_TEXTURE;
        }
        MoaType moaType = moa.getMoaType();
        return moaType == null ? DEFAULT_TEXTURE : moaType.getMoaTexture();
    }

    @Nullable
    private static class_2960 getMoaSkinLocation(Moa moa) {
        MoaSkinsScreen moaSkinsScreen;
        UUID lastRiderUUID = moa.getLastRider();
        UUID moaUUID = moa.getMoaUUID();
        Map userSkinsData = ClientMoaSkinPerkData.INSTANCE.getClientPerkData();
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof MoaSkinsScreen && (moaSkinsScreen = (MoaSkinsScreen)class_4372).getSelectedSkin() != null && moaSkinsScreen.getPreviewMoa() != null && moaSkinsScreen.getPreviewMoa().getMoaUUID() != null && moaSkinsScreen.getPreviewMoa().getMoaUUID().equals(moaUUID)) {
            return moaSkinsScreen.getSelectedSkin().getSkinLocation();
        }
        if (userSkinsData.containsKey(lastRiderUUID) && ((MoaData)userSkinsData.get(lastRiderUUID)).moaSkin() != null && ((MoaData)userSkinsData.get(lastRiderUUID)).moaUUID() != null && ((MoaData)userSkinsData.get(lastRiderUUID)).moaUUID().equals(moaUUID)) {
            return ((MoaData)userSkinsData.get(lastRiderUUID)).moaSkin().getSkinLocation();
        }
        return null;
    }
}

