/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.fabric.mixin.impl;

import glitchcore.fabric.network.FabricPacketWrapper;
import glitchcore.fabric.network.IFabricPacketHandler;
import glitchcore.network.CustomPacket;
import glitchcore.network.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.jodah.typetools.TypeResolver;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PacketHandler.class}, remap=false, priority=0)
public abstract class MixinPacketHandler
implements IFabricPacketHandler {
    @Shadow
    @Final
    private class_2960 channelName;
    @Unique
    private Map<Class<?>, FabricPacketWrapper> wrappers = new HashMap();

    @Overwrite
    public <T extends CustomPacket<T>> void register(class_2960 name, CustomPacket<T> packet) {
        this.wrappers.put(MixinPacketHandler.getPacketDataType(packet), this.createPacketWrapper(name, packet));
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToPlayer(T packet, class_3222 player) {
        FabricPacket fPacket = this.createFabricPacket(packet);
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)fPacket);
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToAll(T packet, MinecraftServer server) {
        FabricPacket fPacket = this.createFabricPacket(packet);
        class_2540 buf = PacketByteBufs.create();
        fPacket.write(buf);
        server.method_3760().method_14581(ServerPlayNetworking.createS2CPacket((class_2960)fPacket.getType().getId(), (class_2540)buf));
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToServer(T packet) {
        throw new UnsupportedOperationException("Attempted to call sendToServer from server");
    }

    @Overwrite
    private void init() {
    }

    @Override
    public <T extends CustomPacket<T>> FabricPacket createFabricPacket(T packet) {
        Class<?> dataType = MixinPacketHandler.getPacketDataType(packet);
        if (!this.wrappers.containsKey(dataType)) {
            throw new RuntimeException("Unregistered packet of type " + dataType);
        }
        return this.wrappers.get(dataType).createPacket(packet);
    }

    private static <T extends CustomPacket<T>> Class<?> getPacketDataType(CustomPacket<T> packet) {
        Class dataType = TypeResolver.resolveRawArgument(CustomPacket.class, packet.getClass());
        if (dataType == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Failed to resolve packet data type: " + packet);
        }
        return dataType;
    }
}

