/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.ModernUI;
import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.annotation.CallSuper;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.core.Context;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.util.DataSetObserver;
import icyllis.modernui.view.FocusFinder;
import icyllis.modernui.view.KeyEvent;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.VelocityTracker;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewConfiguration;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.widget.EdgeEffect;
import icyllis.modernui.widget.OverScroller;
import icyllis.modernui.widget.PagerAdapter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ViewPager
extends ViewGroup {
    private static final Marker MARKER = MarkerManager.getMarker((String)"ViewPager");
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int MIN_FLING_VELOCITY = 400;
    private int mExpectedAdapterCount;
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    PagerAdapter mAdapter;
    int mCurItem;
    private OverScroller mScroller;
    private boolean mIsScrollStarted;
    private PagerObserver mObserver;
    private int mPageMargin;
    private Drawable mMarginDrawable;
    private int mTopPageBounds;
    private int mBottomPageBounds;
    private float mFirstOffset = -3.4028235E38f;
    private float mLastOffset = Float.MAX_VALUE;
    private boolean mInLayout;
    private boolean mPopulatePending;
    private int mOffscreenPageLimit = 1;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private int mDefaultGutterSize;
    private int mGutterSize;
    private int mTouchSlop;
    private float mLastMotionX;
    private float mLastMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mFlingDistance;
    private int mCloseEnough;
    private static final int CLOSE_ENOUGH = 2;
    private boolean mFakeDragging;
    private long mFakeDragBeginTime;
    private EdgeEffect mLeftEdge;
    private EdgeEffect mRightEdge;
    private boolean mFirstLayout = true;
    private boolean mCalledSuper;
    private int mDecorChildCount;
    private List<OnPageChangeListener> mOnPageChangeListeners;
    private OnPageChangeListener mInternalPageChangeListener;
    private List<OnAdapterChangeListener> mAdapterChangeListeners;
    private PageTransformer mPageTransformer;
    private int mPageTransformerLayerType;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private static final ViewPositionComparator sPositionComparator = new ViewPositionComparator();
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private final Runnable mEndScrollRunnable = () -> {
        this.setScrollState(0);
        this.populate();
    };
    private int mScrollState = 0;

    public ViewPager(Context context) {
        super(context);
        this.initViewPager(context);
    }

    void initViewPager(Context context) {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        this.mScroller = new OverScroller(TimeInterpolator.DECELERATE_QUINTIC);
        ViewConfiguration configuration = ViewConfiguration.get(context);
        float density = 1.0f;
        this.mTouchSlop = 8;
        this.mMinimumVelocity = 400;
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffect();
        this.mRightEdge = new EdgeEffect();
        this.mFlingDistance = 25;
        this.mCloseEnough = 2;
        this.mDefaultGutterSize = 16;
    }

    @Override
    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    void setScrollState(int newState) {
        if (this.mScrollState == newState) {
            return;
        }
        this.mScrollState = newState;
        if (this.mPageTransformer != null) {
            this.enableLayers(newState != 0);
        }
        this.dispatchOnScrollStateChanged(newState);
    }

    public void setAdapter(@Nullable PagerAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.setViewPagerObserver(null);
            this.mAdapter.startUpdate(this);
            for (int i = 0; i < this.mItems.size(); ++i) {
                ItemInfo ii = this.mItems.get(i);
                this.mAdapter.destroyItem(this, ii.position, ii.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        PagerAdapter oldAdapter = this.mAdapter;
        this.mAdapter = adapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.setViewPagerObserver(this.mObserver);
            this.mPopulatePending = false;
            boolean wasFirstLayout = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (!wasFirstLayout) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
        if (this.mAdapterChangeListeners != null && !this.mAdapterChangeListeners.isEmpty()) {
            int count = this.mAdapterChangeListeners.size();
            for (int i = 0; i < count; ++i) {
                this.mAdapterChangeListeners.get(i).onAdapterChanged(this, oldAdapter, adapter);
            }
        }
    }

    private void removeNonDecorViews() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDecor) continue;
            this.removeViewAt(i);
            --i;
        }
    }

    @Nullable
    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void addOnAdapterChangeListener(@NonNull OnAdapterChangeListener listener) {
        if (this.mAdapterChangeListeners == null) {
            this.mAdapterChangeListeners = new ArrayList<OnAdapterChangeListener>();
        }
        this.mAdapterChangeListeners.add(listener);
    }

    public void removeOnAdapterChangeListener(@NonNull OnAdapterChangeListener listener) {
        if (this.mAdapterChangeListeners != null) {
            this.mAdapterChangeListeners.remove(listener);
        }
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public void setCurrentItem(int item) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, !this.mFirstLayout, false);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, smoothScroll, false);
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        this.setCurrentItemInternal(item, smoothScroll, always, 0);
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always, int velocity) {
        boolean dispatchSelected;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            return;
        }
        if (!always && this.mCurItem == item && this.mItems.size() != 0) {
            return;
        }
        if (item < 0) {
            item = 0;
        } else if (item >= this.mAdapter.getCount()) {
            item = this.mAdapter.getCount() - 1;
        }
        int pageLimit = this.mOffscreenPageLimit;
        if (item > this.mCurItem + pageLimit || item < this.mCurItem - pageLimit) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                this.mItems.get((int)i).scrolling = true;
            }
        }
        boolean bl = dispatchSelected = this.mCurItem != item;
        if (this.mFirstLayout) {
            this.mCurItem = item;
            if (dispatchSelected) {
                this.dispatchOnPageSelected(item);
            }
            this.requestLayout();
        } else {
            this.populate(item);
            this.scrollToItem(item, smoothScroll, velocity, dispatchSelected);
        }
    }

    private void scrollToItem(int item, boolean smoothScroll, int velocity, boolean dispatchSelected) {
        ItemInfo curInfo = this.infoForPosition(item);
        int destX = 0;
        if (curInfo != null) {
            int width = this.getClientWidth();
            destX = (int)((float)width * Math.max(this.mFirstOffset, Math.min(curInfo.offset, this.mLastOffset)));
        }
        if (smoothScroll) {
            this.smoothScrollTo(destX, 0, velocity);
            if (dispatchSelected) {
                this.dispatchOnPageSelected(item);
            }
        } else {
            if (dispatchSelected) {
                this.dispatchOnPageSelected(item);
            }
            this.completeScroll(false);
            this.scrollTo(destX, 0);
            this.pageScrolled(destX);
        }
    }

    public void addOnPageChangeListener(@NonNull OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(listener);
    }

    public void removeOnPageChangeListener(@NonNull OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.remove(listener);
        }
    }

    public void clearOnPageChangeListeners() {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.clear();
        }
    }

    public void setPageTransformer(boolean reverseDrawingOrder, @Nullable PageTransformer transformer) {
        this.setPageTransformer(reverseDrawingOrder, transformer, 1);
    }

    public void setPageTransformer(boolean reverseDrawingOrder, @Nullable PageTransformer transformer, int pageLayerType) {
        boolean hasTransformer = transformer != null;
        boolean needsPopulate = hasTransformer == (this.mPageTransformer == null);
        this.mPageTransformer = transformer;
        this.setChildrenDrawingOrderEnabled(hasTransformer);
        if (hasTransformer) {
            this.mDrawingOrder = reverseDrawingOrder ? 2 : 1;
            this.mPageTransformerLayerType = pageLayerType;
        } else {
            this.mDrawingOrder = 0;
        }
        if (needsPopulate) {
            this.populate();
        }
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener listener) {
        OnPageChangeListener oldListener = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = listener;
        return oldListener;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public void setOffscreenPageLimit(int limit) {
        if (limit < 1) {
            limit = 1;
        }
        if (limit != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = limit;
            this.populate();
        }
    }

    public void setPageMargin(int marginPixels) {
        int oldMargin = this.mPageMargin;
        this.mPageMargin = marginPixels;
        int width = this.getWidth();
        this.recomputeScrollPosition(width, width, marginPixels, oldMargin);
        this.requestLayout();
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    public void setPageMarginDrawable(@Nullable Drawable d) {
        this.mMarginDrawable = d;
        if (d != null) {
            this.refreshDrawableState();
        }
        this.setWillNotDraw(d == null);
        this.invalidate();
    }

    public void setEdgeEffectColor(int color) {
        this.setLeftEdgeEffectColor(color);
        this.setRightEdgeEffectColor(color);
    }

    public void setLeftEdgeEffectColor(int color) {
        this.mLeftEdge.setColor(color);
    }

    public void setRightEdgeEffectColor(int color) {
        this.mRightEdge.setColor(color);
    }

    public int getLeftEdgeEffectColor() {
        return this.mLeftEdge.getColor();
    }

    public int getRightEdgeEffectColor() {
        return this.mRightEdge.getColor();
    }

    public void setLeftEdgeEffectBlendMode(@Nullable BlendMode blendMode) {
        this.mLeftEdge.setBlendMode(blendMode);
    }

    public void setRightEdgeEffectBlendMode(@Nullable BlendMode blendMode) {
        this.mRightEdge.setBlendMode(blendMode);
    }

    @Nullable
    public BlendMode getLeftEdgeEffectBlendMode() {
        return this.mLeftEdge.getBlendMode();
    }

    @Nullable
    public BlendMode getRightEdgeEffectBlendMode() {
        return this.mRightEdge.getBlendMode();
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.mMarginDrawable;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.mMarginDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        return (float)Math.sin(f *= 0.47123894f);
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        int duration;
        int sx;
        boolean wasScrolling;
        if (this.getChildCount() == 0) {
            return;
        }
        boolean bl = wasScrolling = this.mScroller != null && !this.mScroller.isFinished();
        if (wasScrolling) {
            sx = this.mIsScrollStarted ? this.mScroller.getCurrX() : this.mScroller.getStartX();
            this.mScroller.abortAnimation();
        } else {
            sx = this.getScrollX();
        }
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollState(2);
        int width = this.getClientWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        velocity = Math.abs(velocity);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageWidth = (float)width * this.mAdapter.getPageWidth(this.mCurItem);
            float pageDelta = (float)Math.abs(dx) / (pageWidth + (float)this.mPageMargin);
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 600);
        this.mIsScrollStarted = false;
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        this.postInvalidateOnAnimation();
    }

    ItemInfo addNewItem(int position, int index) {
        ItemInfo ii = new ItemInfo();
        ii.position = position;
        ii.object = this.mAdapter.instantiateItem(this, position);
        ii.widthFactor = this.mAdapter.getPageWidth(position);
        if (index < 0 || index >= this.mItems.size()) {
            this.mItems.add(ii);
        } else {
            this.mItems.add(index, ii);
        }
        return ii;
    }

    void dataSetChanged() {
        int adapterCount;
        this.mExpectedAdapterCount = adapterCount = this.mAdapter.getCount();
        boolean needPopulate = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < adapterCount;
        int newCurrItem = this.mCurItem;
        boolean isUpdating = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            int newPos = this.mAdapter.getItemPosition(ii.object);
            if (newPos == -1) continue;
            if (newPos == -2) {
                this.mItems.remove(i);
                --i;
                if (!isUpdating) {
                    this.mAdapter.startUpdate(this);
                    isUpdating = true;
                }
                this.mAdapter.destroyItem(this, ii.position, ii.object);
                needPopulate = true;
                if (this.mCurItem != ii.position) continue;
                newCurrItem = Math.max(0, Math.min(this.mCurItem, adapterCount - 1));
                continue;
            }
            if (ii.position == newPos) continue;
            if (ii.position == this.mCurItem) {
                newCurrItem = newPos;
            }
            ii.position = newPos;
            needPopulate = true;
        }
        if (isUpdating) {
            this.mAdapter.finishUpdate(this);
        }
        this.mItems.sort(null);
        if (needPopulate) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.isDecor) continue;
                lp.widthFactor = 0.0f;
            }
            this.setCurrentItemInternal(newCurrItem, false, true);
            this.requestLayout();
        }
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    void populate(int newCurrentItem) {
        ItemInfo ii;
        ItemInfo oldCurInfo = null;
        if (this.mCurItem != newCurrentItem) {
            oldCurInfo = this.infoForPosition(this.mCurItem);
            this.mCurItem = newCurrentItem;
        }
        if (this.mAdapter == null) {
            this.sortChildDrawingOrder();
            return;
        }
        if (this.mPopulatePending) {
            this.sortChildDrawingOrder();
            return;
        }
        this.mAdapter.startUpdate(this);
        int pageLimit = this.mOffscreenPageLimit;
        int startPos = Math.max(0, this.mCurItem - pageLimit);
        int N = this.mAdapter.getCount();
        int endPos = Math.min(N - 1, this.mCurItem + pageLimit);
        if (N != this.mExpectedAdapterCount) {
            throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + N + " Pager class: " + this.getClass() + " Problematic adapter: " + this.mAdapter.getClass());
        }
        int curIndex = -1;
        ItemInfo curItem = null;
        for (curIndex = 0; curIndex < this.mItems.size(); ++curIndex) {
            ItemInfo ii2 = this.mItems.get(curIndex);
            if (ii2.position < this.mCurItem) continue;
            if (ii2.position != this.mCurItem) break;
            curItem = ii2;
            break;
        }
        if (curItem == null && N > 0) {
            curItem = this.addNewItem(this.mCurItem, curIndex);
        }
        if (curItem != null) {
            float extraWidthLeft = 0.0f;
            int itemIndex = curIndex - 1;
            ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            int clientWidth = this.getClientWidth();
            float leftWidthNeeded = clientWidth <= 0 ? 0.0f : 2.0f - curItem.widthFactor + (float)this.getPaddingLeft() / (float)clientWidth;
            for (int pos = this.mCurItem - 1; pos >= 0; --pos) {
                if (extraWidthLeft >= leftWidthNeeded && pos < startPos) {
                    if (ii == null) break;
                    if (pos != ii.position || ii.scrolling) continue;
                    this.mItems.remove(itemIndex);
                    this.mAdapter.destroyItem(this, pos, ii.object);
                    --curIndex;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                if (ii != null && pos == ii.position) {
                    extraWidthLeft += ii.widthFactor;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                ii = this.addNewItem(pos, itemIndex + 1);
                extraWidthLeft += ii.widthFactor;
                ++curIndex;
                ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            }
            float extraWidthRight = curItem.widthFactor;
            itemIndex = curIndex + 1;
            if (extraWidthRight < 2.0f) {
                ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                float rightWidthNeeded = clientWidth <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)clientWidth + 2.0f;
                for (int pos = this.mCurItem + 1; pos < N; ++pos) {
                    if (extraWidthRight >= rightWidthNeeded && pos > endPos) {
                        if (ii == null) break;
                        if (pos != ii.position || ii.scrolling) continue;
                        this.mItems.remove(itemIndex);
                        this.mAdapter.destroyItem(this, pos, ii.object);
                        ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    if (ii != null && pos == ii.position) {
                        extraWidthRight += ii.widthFactor;
                        ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    ii = this.addNewItem(pos, itemIndex);
                    extraWidthRight += ii.widthFactor;
                    ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                }
            }
            this.calculatePageOffsets(curItem, curIndex, oldCurInfo);
            this.mAdapter.setPrimaryItem(this, this.mCurItem, curItem.object);
        }
        this.mAdapter.finishUpdate(this);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ItemInfo ii3;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.childIndex = i;
            if (lp.isDecor || lp.widthFactor != 0.0f || (ii3 = this.infoForChild(child)) == null) continue;
            lp.widthFactor = ii3.widthFactor;
            lp.position = ii3.position;
        }
        this.sortChildDrawingOrder();
        if (this.hasFocus()) {
            View currentFocused = this.findFocus();
            ItemInfo itemInfo = ii = currentFocused != null ? this.infoForAnyChild(currentFocused) : null;
            if (ii == null || ii.position != this.mCurItem) {
                View child;
                for (int i = 0; !(i >= this.getChildCount() || (ii = this.infoForChild(child = this.getChildAt(i))) != null && ii.position == this.mCurItem && child.requestFocus(2)); ++i) {
                }
            }
        }
    }

    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            if (this.mDrawingOrderedChildren == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                this.mDrawingOrderedChildren.clear();
            }
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                this.mDrawingOrderedChildren.add(child);
            }
            this.mDrawingOrderedChildren.sort(sPositionComparator);
        }
    }

    private void calculatePageOffsets(ItemInfo curItem, int curIndex, ItemInfo oldCurInfo) {
        float marginOffset;
        int N = this.mAdapter.getCount();
        int width = this.getClientWidth();
        float f = marginOffset = width > 0 ? (float)this.mPageMargin / (float)width : 0.0f;
        if (oldCurInfo != null) {
            int oldCurPosition = oldCurInfo.position;
            if (oldCurPosition < curItem.position) {
                itemIndex = 0;
                ii = null;
                offset = oldCurInfo.offset + oldCurInfo.widthFactor + marginOffset;
                for (pos = oldCurPosition + 1; pos <= curItem.position && itemIndex < this.mItems.size(); ++pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos > ii.position && itemIndex < this.mItems.size() - 1) {
                        ii = this.mItems.get(++itemIndex);
                    }
                    while (pos < ii.position) {
                        offset += this.mAdapter.getPageWidth(pos) + marginOffset;
                        ++pos;
                    }
                    ii.offset = offset;
                    offset += ii.widthFactor + marginOffset;
                }
            } else if (oldCurPosition > curItem.position) {
                itemIndex = this.mItems.size() - 1;
                ii = null;
                offset = oldCurInfo.offset;
                for (pos = oldCurPosition - 1; pos >= curItem.position && itemIndex >= 0; --pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos < ii.position && itemIndex > 0) {
                        ii = this.mItems.get(--itemIndex);
                    }
                    while (pos > ii.position) {
                        offset -= this.mAdapter.getPageWidth(pos) + marginOffset;
                        --pos;
                    }
                    ii.offset = offset -= ii.widthFactor + marginOffset;
                }
            }
        }
        int itemCount = this.mItems.size();
        float offset = curItem.offset;
        int pos = curItem.position - 1;
        this.mFirstOffset = curItem.position == 0 ? curItem.offset : -3.4028235E38f;
        this.mLastOffset = curItem.position == N - 1 ? curItem.offset + curItem.widthFactor - 1.0f : Float.MAX_VALUE;
        int i = curIndex - 1;
        while (i >= 0) {
            ItemInfo ii = this.mItems.get(i);
            while (pos > ii.position) {
                offset -= this.mAdapter.getPageWidth(pos--) + marginOffset;
            }
            ii.offset = offset -= ii.widthFactor + marginOffset;
            if (ii.position == 0) {
                this.mFirstOffset = offset;
            }
            --i;
            --pos;
        }
        offset = curItem.offset + curItem.widthFactor + marginOffset;
        pos = curItem.position + 1;
        i = curIndex + 1;
        while (i < itemCount) {
            ItemInfo ii = this.mItems.get(i);
            while (pos < ii.position) {
                offset += this.mAdapter.getPageWidth(pos++) + marginOffset;
            }
            if (ii.position == N - 1) {
                this.mLastOffset = offset + ii.widthFactor - 1.0f;
            }
            ii.offset = offset;
            offset += ii.widthFactor + marginOffset;
            ++i;
            ++pos;
        }
    }

    @Override
    protected int getChildDrawingOrder(int childCount, int i) {
        int index = this.mDrawingOrder == 2 ? childCount - 1 - i : i;
        return ((LayoutParams)this.mDrawingOrderedChildren.get((int)index).getLayoutParams()).childIndex;
    }

    @Override
    public void addView(@NonNull View child, int index, @NonNull ViewGroup.LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        LayoutParams lp = (LayoutParams)params;
        lp.isDecor |= ViewPager.isDecorView(child);
        if (this.mInLayout) {
            if (lp.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            lp.needsMeasure = true;
            this.addViewInLayout(child, index, params);
        } else {
            super.addView(child, index, params);
        }
    }

    private static boolean isDecorView(@NonNull View view) {
        Class<?> clazz = view.getClass();
        return clazz.getAnnotation(DecorView.class) != null;
    }

    @Override
    public void removeView(@NonNull View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    ItemInfo infoForChild(View child) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!this.mAdapter.isViewFromObject(child, ii.object)) continue;
            return ii;
        }
        return null;
    }

    ItemInfo infoForAnyChild(View child) {
        ViewParent parent;
        while ((parent = child.getParent()) != this) {
            if (!(parent instanceof View)) {
                return null;
            }
            child = (View)((Object)parent);
        }
        return this.infoForChild(child);
    }

    ItemInfo infoForPosition(int position) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (ii.position != position) continue;
            return ii;
        }
        return null;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(ViewPager.getDefaultSize(0, widthMeasureSpec), ViewPager.getDefaultSize(0, heightMeasureSpec));
        int measuredWidth = this.getMeasuredWidth();
        int maxGutterSize = measuredWidth / 10;
        this.mGutterSize = Math.min(maxGutterSize, this.mDefaultGutterSize);
        int childWidthSize = measuredWidth - this.getPaddingLeft() - this.getPaddingRight();
        int childHeightSize = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            boolean consumeHorizontal;
            LayoutParams lp;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) == null || !lp.isDecor) continue;
            int hgrav = lp.gravity & 7;
            int vgrav = lp.gravity & 0x70;
            int widthMode = Integer.MIN_VALUE;
            int heightMode = Integer.MIN_VALUE;
            boolean consumeVertical = vgrav == 48 || vgrav == 80;
            boolean bl = consumeHorizontal = hgrav == 3 || hgrav == 5;
            if (consumeVertical) {
                widthMode = 0x40000000;
            } else if (consumeHorizontal) {
                heightMode = 0x40000000;
            }
            int widthSize = childWidthSize;
            int heightSize = childHeightSize;
            if (lp.width != -2) {
                widthMode = 0x40000000;
                if (lp.width != -1) {
                    widthSize = lp.width;
                }
            }
            if (lp.height != -2) {
                heightMode = 0x40000000;
                if (lp.height != -1) {
                    heightSize = lp.height;
                }
            }
            int widthSpec = MeasureSpec.makeMeasureSpec(widthSize, widthMode);
            int heightSpec = MeasureSpec.makeMeasureSpec(heightSize, heightMode);
            child.measure(widthSpec, heightSpec);
            if (consumeVertical) {
                childHeightSize -= child.getMeasuredHeight();
                continue;
            }
            if (!consumeHorizontal) continue;
            childWidthSize -= child.getMeasuredWidth();
        }
        int childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(childWidthSize, 0x40000000);
        int childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(childHeightSize, 0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            LayoutParams lp;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) != null && lp.isDecor) continue;
            int widthSpec = MeasureSpec.makeMeasureSpec((int)((float)childWidthSize * lp.widthFactor), 0x40000000);
            child.measure(widthSpec, childHeightMeasureSpec);
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.recomputeScrollPosition(w, oldw, this.mPageMargin, this.mPageMargin);
        }
    }

    private void recomputeScrollPosition(int width, int oldWidth, int margin, int oldMargin) {
        if (oldWidth > 0 && !this.mItems.isEmpty()) {
            if (!this.mScroller.isFinished()) {
                this.mScroller.setFinalX(this.getCurrentItem() * this.getClientWidth());
            } else {
                int widthWithMargin = width - this.getPaddingLeft() - this.getPaddingRight() + margin;
                int oldWidthWithMargin = oldWidth - this.getPaddingLeft() - this.getPaddingRight() + oldMargin;
                int xpos = this.getScrollX();
                float pageOffset = (float)xpos / (float)oldWidthWithMargin;
                int newOffsetPixels = (int)(pageOffset * (float)widthWithMargin);
                this.scrollTo(newOffsetPixels, this.getScrollY());
            }
        } else {
            ItemInfo ii = this.infoForPosition(this.mCurItem);
            float scrollOffset = ii != null ? Math.min(ii.offset, this.mLastOffset) : 0.0f;
            int scrollPos = (int)(scrollOffset * (float)(width - this.getPaddingLeft() - this.getPaddingRight()));
            if (scrollPos != this.getScrollX()) {
                this.completeScroll(false);
                this.scrollTo(scrollPos, this.getScrollY());
            }
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int width = r - l;
        int height = b - t;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int scrollX = this.getScrollX();
        int decorCount = 0;
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (!lp.isDecor) continue;
            int hgrav = lp.gravity & 7;
            int vgrav = lp.gravity & 0x70;
            switch (hgrav) {
                default: {
                    childLeft = paddingLeft;
                    break;
                }
                case 3: {
                    childLeft = paddingLeft;
                    paddingLeft += child.getMeasuredWidth();
                    break;
                }
                case 1: {
                    childLeft = Math.max((width - child.getMeasuredWidth()) / 2, paddingLeft);
                    break;
                }
                case 5: {
                    childLeft = width - paddingRight - child.getMeasuredWidth();
                    paddingRight += child.getMeasuredWidth();
                }
            }
            switch (vgrav) {
                default: {
                    childTop = paddingTop;
                    break;
                }
                case 48: {
                    childTop = paddingTop;
                    paddingTop += child.getMeasuredHeight();
                    break;
                }
                case 16: {
                    childTop = Math.max((height - child.getMeasuredHeight()) / 2, paddingTop);
                    break;
                }
                case 80: {
                    childTop = height - paddingBottom - child.getMeasuredHeight();
                    paddingBottom += child.getMeasuredHeight();
                }
            }
            child.layout(childLeft += scrollX, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
            ++decorCount;
        }
        int childWidth = width - paddingLeft - paddingRight;
        for (int i = 0; i < count; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDecor || (ii = this.infoForChild(child)) == null) continue;
            int loff = (int)((float)childWidth * ii.offset);
            int childLeft = paddingLeft + loff;
            int childTop = paddingTop;
            if (lp.needsMeasure) {
                lp.needsMeasure = false;
                int widthSpec = MeasureSpec.makeMeasureSpec((int)((float)childWidth * lp.widthFactor), 0x40000000);
                int heightSpec = MeasureSpec.makeMeasureSpec(height - paddingTop - paddingBottom, 0x40000000);
                child.measure(widthSpec, heightSpec);
            }
            child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
        }
        this.mTopPageBounds = paddingTop;
        this.mBottomPageBounds = height - paddingBottom;
        this.mDecorChildCount = decorCount;
        if (this.mFirstLayout) {
            this.scrollToItem(this.mCurItem, false, 0, false);
        }
        this.mFirstLayout = false;
    }

    @Override
    public void computeScroll() {
        this.mIsScrollStarted = true;
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
                if (!this.pageScrolled(x)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, y);
                }
            }
            this.postInvalidateOnAnimation();
            return;
        }
        this.completeScroll(true);
    }

    private boolean pageScrolled(int xpos) {
        if (this.mItems.size() == 0) {
            if (this.mFirstLayout) {
                return false;
            }
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            return false;
        }
        ItemInfo ii = this.infoForCurrentScrollPosition();
        int width = this.getClientWidth();
        int widthWithMargin = width + this.mPageMargin;
        float marginOffset = (float)this.mPageMargin / (float)width;
        int currentPage = ii.position;
        float pageOffset = ((float)xpos / (float)width - ii.offset) / (ii.widthFactor + marginOffset);
        int offsetPixels = (int)(pageOffset * (float)widthWithMargin);
        this.mCalledSuper = false;
        this.onPageScrolled(currentPage, pageOffset, offsetPixels);
        if (!this.mCalledSuper) {
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        return true;
    }

    @CallSuper
    protected void onPageScrolled(int position, float offset, int offsetPixels) {
        int scrollX;
        if (this.mDecorChildCount > 0) {
            scrollX = this.getScrollX();
            int paddingLeft = this.getPaddingLeft();
            int paddingRight = this.getPaddingRight();
            int width = this.getWidth();
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (!lp.isDecor) continue;
                int hgrav = lp.gravity & 7;
                switch (hgrav) {
                    default: {
                        int childLeft = paddingLeft;
                        break;
                    }
                    case 3: {
                        int childLeft = paddingLeft;
                        paddingLeft += child.getWidth();
                        break;
                    }
                    case 1: {
                        int childLeft = Math.max((width - child.getMeasuredWidth()) / 2, paddingLeft);
                        break;
                    }
                    case 5: {
                        int childLeft = width - paddingRight - child.getMeasuredWidth();
                        paddingRight += child.getMeasuredWidth();
                    }
                }
                int childOffset = (childLeft += scrollX) - child.getLeft();
                if (childOffset == 0) continue;
                child.offsetLeftAndRight(childOffset);
            }
        }
        this.dispatchOnPageScrolled(position, offset, offsetPixels);
        if (this.mPageTransformer != null) {
            scrollX = this.getScrollX();
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.isDecor) continue;
                float transformPos = (float)(child.getLeft() - scrollX) / (float)this.getClientWidth();
                this.mPageTransformer.transformPage(child, transformPos);
            }
        }
        this.mCalledSuper = true;
    }

    private void dispatchOnPageScrolled(int position, float offset, int offsetPixels) {
        if (this.mOnPageChangeListeners != null) {
            int z = this.mOnPageChangeListeners.size();
            for (int i = 0; i < z; ++i) {
                OnPageChangeListener listener = this.mOnPageChangeListeners.get(i);
                if (listener == null) continue;
                listener.onPageScrolled(position, offset, offsetPixels);
            }
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(position, offset, offsetPixels);
        }
    }

    private void dispatchOnPageSelected(int position) {
        if (this.mOnPageChangeListeners != null) {
            int z = this.mOnPageChangeListeners.size();
            for (int i = 0; i < z; ++i) {
                OnPageChangeListener listener = this.mOnPageChangeListeners.get(i);
                if (listener == null) continue;
                listener.onPageSelected(position);
            }
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(position);
        }
    }

    private void dispatchOnScrollStateChanged(int state) {
        if (this.mOnPageChangeListeners != null) {
            int z = this.mOnPageChangeListeners.size();
            for (int i = 0; i < z; ++i) {
                OnPageChangeListener listener = this.mOnPageChangeListeners.get(i);
                if (listener == null) continue;
                listener.onPageScrollStateChanged(state);
            }
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    private void completeScroll(boolean postEvents) {
        boolean needPopulate;
        boolean bl = needPopulate = this.mScrollState == 2;
        if (needPopulate) {
            boolean wasScrolling;
            boolean bl2 = wasScrolling = !this.mScroller.isFinished();
            if (wasScrolling) {
                this.mScroller.abortAnimation();
                int oldX = this.getScrollX();
                int oldY = this.getScrollY();
                int x = this.mScroller.getCurrX();
                int y = this.mScroller.getCurrY();
                if (oldX != x || oldY != y) {
                    this.scrollTo(x, y);
                    if (x != oldX) {
                        this.pageScrolled(x);
                    }
                }
            }
        }
        this.mPopulatePending = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!ii.scrolling) continue;
            needPopulate = true;
            ii.scrolling = false;
        }
        if (needPopulate) {
            if (postEvents) {
                this.postOnAnimation(this.mEndScrollRunnable);
            } else {
                this.mEndScrollRunnable.run();
            }
        }
    }

    private boolean isGutterDrag(float x, float dx) {
        return x < (float)this.mGutterSize && dx > 0.0f || x > (float)(this.getWidth() - this.mGutterSize) && dx < 0.0f;
    }

    private void enableLayers(boolean enable) {
        int childCount = this.getChildCount();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 3 || action == 1) {
            this.resetTouch();
            return false;
        }
        if (action != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (action) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                float x = ev.getX();
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = ev.getY();
                float yDiff = Math.abs(y - this.mInitialMotionY);
                if (dx != 0.0f && !this.isGutterDrag(this.mLastMotionX, dx) && this.canScroll(this, false, (int)dx, (int)x, (int)y)) {
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    this.mIsUnableToDrag = true;
                    return false;
                }
                if (xDiff > (float)this.mTouchSlop && xDiff * 0.5f > yDiff) {
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    this.mLastMotionX = dx > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                    this.mLastMotionY = y;
                } else if (yDiff > (float)this.mTouchSlop) {
                    this.mIsUnableToDrag = true;
                }
                if (!this.mIsBeingDragged || !this.performDrag(x)) break;
                this.postInvalidateOnAnimation();
                break;
            }
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = 0;
                this.mIsUnableToDrag = false;
                this.mIsScrollStarted = true;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll(false);
                this.mIsBeingDragged = false;
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsBeingDragged;
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        if (this.mFakeDragging) {
            return true;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        boolean needsInvalidate = false;
        switch (action) {
            case 0: {
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = 0;
                break;
            }
            case 2: {
                float x;
                if (!this.mIsBeingDragged) {
                    x = ev.getX();
                    float xDiff = Math.abs(x - this.mLastMotionX);
                    float y = ev.getY();
                    float yDiff = Math.abs(y - this.mLastMotionY);
                    if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                        this.mIsBeingDragged = true;
                        this.requestParentDisallowInterceptTouchEvent(true);
                        this.mLastMotionX = x - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                        this.mLastMotionY = y;
                        this.setScrollState(1);
                        ViewParent parent = this.getParent();
                        if (parent != null) {
                            parent.requestDisallowInterceptTouchEvent(true);
                        }
                    }
                }
                if (!this.mIsBeingDragged) break;
                x = ev.getX();
                needsInvalidate = this.performDrag(x);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getXVelocity();
                this.mPopulatePending = true;
                int width = this.getClientWidth();
                int scrollX = this.getScrollX();
                ItemInfo ii = this.infoForCurrentScrollPosition();
                float marginOffset = (float)this.mPageMargin / (float)width;
                int currentPage = ii.position;
                float pageOffset = ((float)scrollX / (float)width - ii.offset) / (ii.widthFactor + marginOffset);
                float x = ev.getX();
                int totalDelta = (int)(x - this.mInitialMotionX);
                int nextPage = this.determineTargetPage(currentPage, pageOffset, initialVelocity, totalDelta);
                this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                needsInvalidate = this.resetTouch();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.scrollToItem(this.mCurItem, true, 0, false);
                needsInvalidate = this.resetTouch();
            }
        }
        if (needsInvalidate) {
            this.postInvalidateOnAnimation();
        }
        return true;
    }

    private boolean resetTouch() {
        this.mActivePointerId = -1;
        this.endDrag();
        this.mLeftEdge.onRelease();
        this.mRightEdge.onRelease();
        boolean needsInvalidate = this.mLeftEdge.isFinished() || this.mRightEdge.isFinished();
        return needsInvalidate;
    }

    private void requestParentDisallowInterceptTouchEvent(boolean disallowIntercept) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    private boolean performDrag(float x) {
        boolean needsInvalidate = false;
        float deltaX = this.mLastMotionX - x;
        this.mLastMotionX = x;
        float oldScrollX = this.getScrollX();
        float scrollX = oldScrollX + deltaX;
        int width = this.getClientWidth();
        float leftBound = (float)width * this.mFirstOffset;
        float rightBound = (float)width * this.mLastOffset;
        boolean leftAbsolute = true;
        boolean rightAbsolute = true;
        ItemInfo firstItem = this.mItems.get(0);
        ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
        if (firstItem.position != 0) {
            leftAbsolute = false;
            leftBound = firstItem.offset * (float)width;
        }
        if (lastItem.position != this.mAdapter.getCount() - 1) {
            rightAbsolute = false;
            rightBound = lastItem.offset * (float)width;
        }
        if (scrollX < leftBound) {
            if (leftAbsolute) {
                float over = leftBound - scrollX;
                this.mLeftEdge.onPull(Math.abs(over) / (float)width);
                needsInvalidate = true;
            }
            scrollX = leftBound;
        } else if (scrollX > rightBound) {
            if (rightAbsolute) {
                float over = scrollX - rightBound;
                this.mRightEdge.onPull(Math.abs(over) / (float)width);
                needsInvalidate = true;
            }
            scrollX = rightBound;
        }
        this.mLastMotionX += scrollX - (float)((int)scrollX);
        this.scrollTo((int)scrollX, this.getScrollY());
        this.pageScrolled((int)scrollX);
        return needsInvalidate;
    }

    private ItemInfo infoForCurrentScrollPosition() {
        int width = this.getClientWidth();
        float scrollOffset = width > 0 ? (float)this.getScrollX() / (float)width : 0.0f;
        float marginOffset = width > 0 ? (float)this.mPageMargin / (float)width : 0.0f;
        int lastPos = -1;
        float lastOffset = 0.0f;
        float lastWidth = 0.0f;
        boolean first = true;
        ItemInfo lastItem = null;
        for (int i = 0; i < this.mItems.size(); ++i) {
            float offset;
            ItemInfo ii = this.mItems.get(i);
            if (!first && ii.position != lastPos + 1) {
                ii = this.mTempItem;
                ii.offset = lastOffset + lastWidth + marginOffset;
                ii.position = lastPos + 1;
                ii.widthFactor = this.mAdapter.getPageWidth(ii.position);
                --i;
            }
            float leftBound = offset = ii.offset;
            float rightBound = offset + ii.widthFactor + marginOffset;
            if (first || scrollOffset >= leftBound) {
                if (scrollOffset < rightBound || i == this.mItems.size() - 1) {
                    return ii;
                }
            } else {
                return lastItem;
            }
            first = false;
            lastPos = ii.position;
            lastOffset = offset;
            lastWidth = ii.widthFactor;
            lastItem = ii;
        }
        return lastItem;
    }

    private int determineTargetPage(int currentPage, float pageOffset, int velocity, int deltaX) {
        int targetPage;
        if (Math.abs(deltaX) > this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity) {
            targetPage = velocity > 0 ? currentPage : currentPage + 1;
        } else {
            float truncator = currentPage >= this.mCurItem ? 0.4f : 0.6f;
            targetPage = currentPage + (int)(pageOffset + truncator);
        }
        if (this.mItems.size() > 0) {
            ItemInfo firstItem = this.mItems.get(0);
            ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
            targetPage = Math.max(firstItem.position, Math.min(targetPage, lastItem.position));
        }
        return targetPage;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        boolean needsInvalidate = false;
        int overScrollMode = this.getOverScrollMode();
        if (overScrollMode == 0 || overScrollMode == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            int restoreCount;
            if (!this.mLeftEdge.isFinished()) {
                restoreCount = canvas.save();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                int width = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate(-height + this.getPaddingTop(), this.mFirstOffset * (float)width);
                this.mLeftEdge.setSize(height, width);
                needsInvalidate |= this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mRightEdge.isFinished()) {
                restoreCount = canvas.save();
                int width = this.getWidth();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate(-this.getPaddingTop(), -(this.mLastOffset + 1.0f) * (float)width);
                this.mRightEdge.setSize(height, width);
                needsInvalidate |= this.mRightEdge.draw(canvas);
                canvas.restoreToCount(restoreCount);
            }
        } else {
            this.mLeftEdge.finish();
            this.mRightEdge.finish();
        }
        if (needsInvalidate) {
            this.postInvalidateOnAnimation();
        }
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int scrollX = this.getScrollX();
            int width = this.getWidth();
            float marginOffset = (float)this.mPageMargin / (float)width;
            int itemIndex = 0;
            ItemInfo ii = this.mItems.get(0);
            float offset = ii.offset;
            int itemCount = this.mItems.size();
            int firstPos = ii.position;
            int lastPos = this.mItems.get((int)(itemCount - 1)).position;
            for (int pos = firstPos; pos < lastPos; ++pos) {
                float drawAt;
                while (pos > ii.position && itemIndex < itemCount) {
                    ii = this.mItems.get(++itemIndex);
                }
                if (pos == ii.position) {
                    drawAt = (ii.offset + ii.widthFactor) * (float)width;
                    offset = ii.offset + ii.widthFactor + marginOffset;
                } else {
                    float widthFactor = this.mAdapter.getPageWidth(pos);
                    drawAt = (offset + widthFactor) * (float)width;
                    offset += widthFactor + marginOffset;
                }
                if (drawAt + (float)this.mPageMargin > (float)scrollX) {
                    this.mMarginDrawable.setBounds(Math.round(drawAt), this.mTopPageBounds, Math.round(drawAt + (float)this.mPageMargin), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (drawAt > (float)(scrollX + width)) break;
            }
        }
    }

    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long time = Core.timeNanos();
        MotionEvent ev = MotionEvent.obtain(time, 0, 0.0f, 0.0f, 0);
        this.mVelocityTracker.addMovement(ev);
        ev.recycle();
        this.mFakeDragBeginTime = time;
        return true;
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        if (this.mAdapter != null) {
            VelocityTracker velocityTracker = this.mVelocityTracker;
            velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
            int initialVelocity = (int)velocityTracker.getXVelocity();
            this.mPopulatePending = true;
            int width = this.getClientWidth();
            int scrollX = this.getScrollX();
            ItemInfo ii = this.infoForCurrentScrollPosition();
            int currentPage = ii.position;
            float pageOffset = ((float)scrollX / (float)width - ii.offset) / ii.widthFactor;
            int totalDelta = (int)(this.mLastMotionX - this.mInitialMotionX);
            int nextPage = this.determineTargetPage(currentPage, pageOffset, initialVelocity, totalDelta);
            this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
        }
        this.endDrag();
        this.mFakeDragging = false;
    }

    public void fakeDragBy(float xOffset) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        if (this.mAdapter == null) {
            return;
        }
        this.mLastMotionX += xOffset;
        float oldScrollX = this.getScrollX();
        float scrollX = oldScrollX - xOffset;
        int width = this.getClientWidth();
        float leftBound = (float)width * this.mFirstOffset;
        float rightBound = (float)width * this.mLastOffset;
        ItemInfo firstItem = this.mItems.get(0);
        ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
        if (firstItem.position != 0) {
            leftBound = firstItem.offset * (float)width;
        }
        if (lastItem.position != this.mAdapter.getCount() - 1) {
            rightBound = lastItem.offset * (float)width;
        }
        if (scrollX < leftBound) {
            scrollX = leftBound;
        } else if (scrollX > rightBound) {
            scrollX = rightBound;
        }
        this.mLastMotionX += scrollX - (float)((int)scrollX);
        this.scrollTo((int)scrollX, this.getScrollY());
        this.pageScrolled((int)scrollX);
        long time = Core.timeNanos();
        MotionEvent ev = MotionEvent.obtain(time, 2, this.mLastMotionX, 0.0f, 0);
        this.mVelocityTracker.addMovement(ev);
        ev.recycle();
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public boolean canScrollHorizontally(int direction) {
        if (this.mAdapter == null) {
            return false;
        }
        int width = this.getClientWidth();
        int scrollX = this.getScrollX();
        if (direction < 0) {
            return scrollX > (int)((float)width * this.mFirstOffset);
        }
        if (direction > 0) {
            return scrollX < (int)((float)width * this.mLastOffset);
        }
        return false;
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally(-dx);
    }

    @Override
    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(@NonNull KeyEvent event) {
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 263: {
                    if (event.hasModifiers(4)) {
                        handled = this.pageLeft();
                        break;
                    }
                    handled = this.arrowScroll(17);
                    break;
                }
                case 262: {
                    if (event.hasModifiers(4)) {
                        handled = this.pageRight();
                        break;
                    }
                    handled = this.arrowScroll(66);
                    break;
                }
                case 258: {
                    if (event.hasNoModifiers()) {
                        handled = this.arrowScroll(2);
                        break;
                    }
                    if (!event.hasModifiers(1)) break;
                    handled = this.arrowScroll(1);
                }
            }
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        } else if (currentFocused != null) {
            boolean isChild = false;
            ViewParent parent = currentFocused.getParent();
            while (parent instanceof ViewGroup) {
                if (parent == this) {
                    isChild = true;
                    break;
                }
                parent = parent.getParent();
            }
            if (!isChild) {
                StringBuilder sb = new StringBuilder();
                sb.append(currentFocused.getClass().getSimpleName());
                ViewParent parent2 = currentFocused.getParent();
                while (parent2 instanceof ViewGroup) {
                    sb.append(" => ").append(parent2.getClass().getSimpleName());
                    parent2 = parent2.getParent();
                }
                ModernUI.LOGGER.warn(MARKER, "arrowScroll tried to find focus based on non-child current focused view " + sb);
                currentFocused = null;
            }
        }
        boolean handled = false;
        View nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, direction);
        if (nextFocused != null && nextFocused != currentFocused) {
            if (direction == 17) {
                int nextLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).left;
                int currLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).left;
                handled = currentFocused != null && nextLeft >= currLeft ? this.pageLeft() : nextFocused.requestFocus();
            } else if (direction == 66) {
                int nextLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).left;
                int currLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).left;
                handled = currentFocused != null && nextLeft <= currLeft ? this.pageRight() : nextFocused.requestFocus();
            }
        } else if (direction == 17 || direction == 1) {
            handled = this.pageLeft();
        } else if (direction == 66 || direction == 2) {
            handled = this.pageRight();
        }
        if (handled) {
            // empty if block
        }
        return handled;
    }

    private Rect getChildRectInPagerCoordinates(Rect outRect, View child) {
        if (outRect == null) {
            outRect = new Rect();
        }
        if (child == null) {
            outRect.set(0, 0, 0, 0);
            return outRect;
        }
        outRect.left = child.getLeft();
        outRect.right = child.getRight();
        outRect.top = child.getTop();
        outRect.bottom = child.getBottom();
        ViewParent parent = child.getParent();
        while (parent != this && parent instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            outRect.left += group.getLeft();
            outRect.right += group.getRight();
            outRect.top += group.getTop();
            outRect.bottom += group.getBottom();
            parent = group.getParent();
        }
        return outRect;
    }

    boolean pageLeft() {
        if (this.mCurItem > 0) {
            this.setCurrentItem(this.mCurItem - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        if (this.mAdapter != null && this.mCurItem < this.mAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    @Override
    public void addFocusables(@NonNull ArrayList<View> views, int direction, int focusableMode) {
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ItemInfo ii;
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
                child.addFocusables(views, direction, focusableMode);
            }
        }
        if (descendantFocusability != 262144 || focusableCount == views.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            views.add(this);
        }
    }

    @Override
    public void addTouchables(@NonNull ArrayList<View> views) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
            child.addTouchables(views);
        }
    }

    @Override
    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int count = this.getChildCount();
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        for (int i = index; i != end; i += increment) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    @NonNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NonNull ViewGroup.LayoutParams p) {
        return this.generateDefaultLayoutParams();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    static class ItemInfo
    implements Comparable<ItemInfo> {
        Object object;
        int position;
        boolean scrolling;
        float widthFactor;
        float offset;

        ItemInfo() {
        }

        @Override
        public int compareTo(@NonNull ItemInfo o) {
            return this.position - o.position;
        }
    }

    public static interface PageTransformer {
        public void transformPage(@NonNull View var1, float var2);
    }

    private class PagerObserver
    implements DataSetObserver {
        PagerObserver() {
        }

        @Override
        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        @Override
        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static interface OnAdapterChangeListener {
        public void onAdapterChanged(@NonNull ViewPager var1, @Nullable PagerAdapter var2, @Nullable PagerAdapter var3);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public boolean isDecor;
        public int gravity;
        float widthFactor = 0.0f;
        boolean needsMeasure;
        int position;
        int childIndex;

        public LayoutParams() {
            super(-1, -1);
        }
    }

    public static interface OnPageChangeListener {
        default public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        default public void onPageSelected(int position) {
        }

        default public void onPageScrollStateChanged(int state) {
        }
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        @Override
        public int compare(View lhs, View rhs) {
            LayoutParams llp = (LayoutParams)lhs.getLayoutParams();
            LayoutParams rlp = (LayoutParams)rhs.getLayoutParams();
            if (llp.isDecor != rlp.isDecor) {
                return llp.isDecor ? 1 : -1;
            }
            return llp.position - rlp.position;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface DecorView {
    }
}

