/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.core.Context;
import icyllis.modernui.graphics.drawable.LayerDrawable;
import icyllis.modernui.graphics.drawable.ScaleDrawable;
import icyllis.modernui.graphics.drawable.ShapeDrawable;
import icyllis.modernui.util.ColorStateList;
import icyllis.modernui.util.StateSet;
import icyllis.modernui.widget.AbsSeekBar;

public class SeekBar
extends AbsSeekBar {
    private OnSeekBarChangeListener mOnSeekBarChangeListener;

    public SeekBar(Context context) {
        super(context);
        this.setFocusable(true);
        if (this.getClass() == SeekBar.class) {
            ShapeDrawable shape = new ShapeDrawable();
            shape.setShape(3);
            shape.setStroke(this.dp(2.0f), -3300456);
            shape.setSize(-1, this.dp(2.0f));
            shape.setCornerRadius(1.0f);
            ScaleDrawable track = new ScaleDrawable(shape, 3, 1.0f, -1.0f);
            ShapeDrawable shape2 = new ShapeDrawable();
            shape2.setShape(3);
            shape2.setStroke(this.dp(2.0f), -12632257);
            shape2.setSize(-1, this.dp(2.0f));
            shape2.setCornerRadius(1.0f);
            ShapeDrawable secondaryTrack = shape2;
            LayerDrawable progress = new LayerDrawable(secondaryTrack, track);
            progress.setId(0, 16908303);
            progress.setId(1, 16908301);
            this.setProgressDrawable(progress);
            ShapeDrawable thumb = new ShapeDrawable();
            thumb.setShape(1);
            thumb.setSize(this.dp(12.0f), this.dp(12.0f));
            thumb.setColor(-3300456);
            int[][] stateSet = new int[][]{StateSet.get(16), StateSet.get(64), StateSet.WILD_CARD};
            int[] colors = new int[]{-2132943395, -2132943395, -8355712};
            thumb.setStroke(this.dp(1.5f), new ColorStateList(stateSet, colors));
            thumb.setUseLevelForShape(false);
            this.setThumb(thumb);
            this.setPadding(this.dp(16.0f), 0, this.dp(16.0f), 0);
        }
    }

    @Override
    void onProgressRefresh(float scale, boolean fromUser, int progress) {
        super.onProgressRefresh(scale, fromUser, progress);
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onProgressChanged(this, progress, fromUser);
        }
    }

    public void setOnSeekBarChangeListener(OnSeekBarChangeListener l) {
        this.mOnSeekBarChangeListener = l;
    }

    @Override
    void onStartTrackingTouch() {
        super.onStartTrackingTouch();
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStartTrackingTouch(this);
        }
    }

    @Override
    void onStopTrackingTouch() {
        super.onStopTrackingTouch();
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStopTrackingTouch(this);
        }
    }

    public static interface OnSeekBarChangeListener {
        default public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        }

        default public void onStartTrackingTouch(SeekBar seekBar) {
        }

        default public void onStopTrackingTouch(SeekBar seekBar) {
        }
    }
}

