/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.util;

import icyllis.modernui.util.Parcel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class IOStreamParcel
extends Parcel
implements AutoCloseable {
    private final InputStream mIn;
    private final OutputStream mOut;
    private final byte[] mTmpBuffer = new byte[8];

    public IOStreamParcel(InputStream in, OutputStream out) {
        this.mIn = in;
        this.mOut = out;
    }

    @Override
    protected void ensureCapacity(int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void position(int newPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void limit(int newLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBytes(byte[] src, int off, int len) {
        try {
            this.mOut.write(src, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeByte(int v) {
        try {
            this.mOut.write(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeShort(int v) {
        this.mTmpBuffer[0] = (byte)(v >>> 8);
        this.mTmpBuffer[1] = (byte)v;
        try {
            this.mOut.write(this.mTmpBuffer, 0, 2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeInt(int v) {
        this.mTmpBuffer[0] = (byte)(v >>> 24);
        this.mTmpBuffer[1] = (byte)(v >>> 16);
        this.mTmpBuffer[2] = (byte)(v >>> 8);
        this.mTmpBuffer[3] = (byte)v;
        try {
            this.mOut.write(this.mTmpBuffer, 0, 4);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeLong(long v) {
        this.mTmpBuffer[0] = (byte)(v >>> 56);
        this.mTmpBuffer[1] = (byte)(v >>> 48);
        this.mTmpBuffer[2] = (byte)(v >>> 40);
        this.mTmpBuffer[3] = (byte)(v >>> 32);
        this.mTmpBuffer[4] = (byte)(v >>> 24);
        this.mTmpBuffer[5] = (byte)(v >>> 16);
        this.mTmpBuffer[6] = (byte)(v >>> 8);
        this.mTmpBuffer[7] = (byte)v;
        try {
            this.mOut.write(this.mTmpBuffer, 0, 8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readBytes(byte[] dst, int off, int len) {
        try {
            int count;
            for (int n = 0; n < len; n += count) {
                count = this.mIn.read(dst, off + n, len - n);
                if (count >= 0) continue;
                throw new RuntimeException("Not enough data");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readByte() {
        try {
            int ch = this.mIn.read();
            if (ch < 0) {
                throw new RuntimeException("Not enough data");
            }
            return (byte)ch;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            int ch1 = this.mIn.read();
            int ch2 = this.mIn.read();
            if ((ch1 | ch2) < 0) {
                throw new RuntimeException("Not enough data");
            }
            return (short)((ch1 << 8) + ch2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            int ch1 = this.mIn.read();
            int ch2 = this.mIn.read();
            int ch3 = this.mIn.read();
            int ch4 = this.mIn.read();
            if ((ch1 | ch2 | ch3 | ch4) < 0) {
                throw new RuntimeException("Not enough data");
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong() {
        this.readBytes(this.mTmpBuffer, 0, 8);
        return ((long)this.mTmpBuffer[0] << 56) + ((long)(this.mTmpBuffer[1] & 0xFF) << 48) + ((long)(this.mTmpBuffer[2] & 0xFF) << 40) + ((long)(this.mTmpBuffer[3] & 0xFF) << 32) + ((long)(this.mTmpBuffer[4] & 0xFF) << 24) + (long)((this.mTmpBuffer[5] & 0xFF) << 16) + (long)((this.mTmpBuffer[6] & 0xFF) << 8) + (long)(this.mTmpBuffer[7] & 0xFF);
    }

    @Override
    public void close() throws IOException {
        this.mIn.close();
        this.mOut.close();
    }
}

