/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.util;

import icyllis.arc3d.core.FP16;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.graphics.MathUtil;

public final class Half
extends Number
implements Comparable<Half> {
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    public static final short EPSILON = 5120;
    public static final int MAX_EXPONENT = 15;
    public static final int MIN_EXPONENT = -14;
    public static final short LOWEST_VALUE = -1025;
    public static final short MAX_VALUE = 31743;
    public static final short MIN_NORMAL = 1024;
    public static final short MIN_VALUE = 1;
    public static final short NaN = 32256;
    public static final short NEGATIVE_INFINITY = -1024;
    public static final short NEGATIVE_ZERO = Short.MIN_VALUE;
    public static final short POSITIVE_INFINITY = 31744;
    public static final short POSITIVE_ZERO = 0;
    private final short value;

    public Half(short value) {
        this.value = value;
    }

    public Half(float value) {
        this.value = Half.toHalf(value);
    }

    public Half(double value) {
        this.value = Half.toHalf((float)value);
    }

    public Half(@NonNull String value) throws NumberFormatException {
        this.value = Half.toHalf(Float.parseFloat(value));
    }

    public short halfValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)Half.toFloat(this.value);
    }

    @Override
    public short shortValue() {
        return (short)Half.toFloat(this.value);
    }

    @Override
    public int intValue() {
        return (int)Half.toFloat(this.value);
    }

    @Override
    public long longValue() {
        return (long)Half.toFloat(this.value);
    }

    @Override
    public float floatValue() {
        return Half.toFloat(this.value);
    }

    @Override
    public double doubleValue() {
        return Half.toFloat(this.value);
    }

    public boolean isNaN() {
        return Half.isNaN(this.value);
    }

    public boolean equals(Object o) {
        return o instanceof Half && Half.halfToIntBits(((Half)o).value) == Half.halfToIntBits(this.value);
    }

    public int hashCode() {
        return Half.hashCode(this.value);
    }

    @NonNull
    public String toString() {
        return Half.toString(this.value);
    }

    @Override
    public int compareTo(@NonNull Half h) {
        return Half.compare(this.value, h.value);
    }

    public static int hashCode(short h) {
        return Half.halfToIntBits(h);
    }

    public static int compare(short x, short y) {
        return FP16.compare(x, y);
    }

    public static short halfToShortBits(short h) {
        return (h & Short.MAX_VALUE) > 31744 ? (short)32256 : (short)h;
    }

    public static int halfToIntBits(short h) {
        return (h & Short.MAX_VALUE) > 31744 ? 32256 : h & 0xFFFF;
    }

    public static int halfToRawIntBits(short h) {
        return h & 0xFFFF;
    }

    public static short intBitsToHalf(int bits) {
        return (short)(bits & 0xFFFF);
    }

    public static short copySign(short magnitude, short sign) {
        return (short)(sign & 0x8000 | magnitude & Short.MAX_VALUE);
    }

    public static short abs(short h) {
        return (short)(h & Short.MAX_VALUE);
    }

    public static short round(short h) {
        return FP16.rint(h);
    }

    public static short ceil(short h) {
        return FP16.ceil(h);
    }

    public static short floor(short h) {
        return FP16.floor(h);
    }

    public static short trunc(short h) {
        return FP16.trunc(h);
    }

    public static short min(short x, short y) {
        return FP16.min(x, y);
    }

    public static short max(short x, short y) {
        return FP16.max(x, y);
    }

    public static boolean less(short x, short y) {
        return FP16.less(x, y);
    }

    public static boolean lessEquals(short x, short y) {
        return FP16.lessEquals(x, y);
    }

    public static boolean greater(short x, short y) {
        return FP16.greater(x, y);
    }

    public static boolean greaterEquals(short x, short y) {
        return FP16.greaterEquals(x, y);
    }

    public static boolean equals(short x, short y) {
        return FP16.equals(x, y);
    }

    public static int getSign(short h) {
        return (h & 0x8000) == 0 ? 1 : -1;
    }

    public static int getExponent(short h) {
        return (h >>> 10 & 0x1F) - 15;
    }

    public static int getSignificand(short h) {
        return h & 0x3FF;
    }

    public static boolean isInfinite(short h) {
        return FP16.isInfinite(h);
    }

    public static boolean isNaN(short h) {
        return FP16.isNaN(h);
    }

    public static boolean isNormalized(short h) {
        return FP16.isNormalized(h);
    }

    public static float toFloat(short h) {
        return MathUtil.halfToFloat(h);
    }

    public static short toHalf(float f) {
        return MathUtil.floatToHalf(f);
    }

    @NonNull
    public static Half valueOf(short h) {
        return new Half(h);
    }

    @NonNull
    public static Half valueOf(float f) {
        return new Half(f);
    }

    @NonNull
    public static Half valueOf(@NonNull String s) {
        return new Half(s);
    }

    public static short parseHalf(@NonNull String s) throws NumberFormatException {
        return Half.toHalf(Float.parseFloat(s));
    }

    @NonNull
    public static String toString(short h) {
        return Float.toString(Half.toFloat(h));
    }

    @NonNull
    public static String toHexString(short h) {
        return FP16.toHexString(h);
    }
}

