/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text.method;

import icyllis.modernui.graphics.Rect;
import icyllis.modernui.text.Editable;
import icyllis.modernui.text.GetChars;
import icyllis.modernui.text.NoCopySpan;
import icyllis.modernui.text.Spannable;
import icyllis.modernui.text.Spanned;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.text.TextWatcher;
import icyllis.modernui.text.method.TransformationMethod;
import icyllis.modernui.text.style.UpdateLayout;
import icyllis.modernui.view.View;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PasswordTransformationMethod
implements TransformationMethod,
TextWatcher {
    private static final PasswordTransformationMethod sInstance = new PasswordTransformationMethod();
    private static final char DOT = '\u2022';

    private PasswordTransformationMethod() {
    }

    public static PasswordTransformationMethod getInstance() {
        return sInstance;
    }

    @Override
    @Nonnull
    public CharSequence getTransformation(@Nonnull CharSequence source, @Nonnull View view) {
        if (source instanceof Spannable) {
            Spannable sp = (Spannable)source;
            List<ViewReference> vr = sp.getSpans(0, sp.length(), ViewReference.class);
            for (ViewReference r : vr) {
                sp.removeSpan(r);
            }
            PasswordTransformationMethod.removeVisibleSpans(sp);
            sp.setSpan(new ViewReference(view), 0, 0, 34);
        }
        return new PasswordCharSequence(source);
    }

    @Override
    public void onFocusChanged(@Nonnull View view, @Nonnull CharSequence sourceText, boolean focused, int direction, @Nullable Rect previouslyFocusedRect) {
        if (!focused && sourceText instanceof Spannable) {
            PasswordTransformationMethod.removeVisibleSpans((Spannable)sourceText);
        }
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (s instanceof Spannable) {
            Spannable sp = (Spannable)s;
            List<ViewReference> vr = sp.getSpans(0, s.length(), ViewReference.class);
            if (vr.isEmpty()) {
                return;
            }
            View v = null;
            for (int i = 0; v == null && i < vr.size(); ++i) {
                v = (View)vr.get(i).get();
            }
            if (v == null) {
                return;
            }
            if (count > 0) {
                PasswordTransformationMethod.removeVisibleSpans(sp);
                if (count == 1) {
                    Visible visible = new Visible(sp, this);
                    sp.setSpan(visible, start, start + count, 33);
                    v.postDelayed(visible, 1500L);
                }
            }
        }
    }

    @Override
    public void afterTextChanged(Editable s) {
    }

    private static void removeVisibleSpans(@Nonnull Spannable sp) {
        List<Visible> old = sp.getSpans(0, sp.length(), Visible.class);
        for (Visible visible : old) {
            sp.removeSpan(visible);
        }
    }

    private static class ViewReference
    extends WeakReference<View>
    implements NoCopySpan {
        private ViewReference(View v) {
            super(v);
        }
    }

    private static class PasswordCharSequence
    implements CharSequence,
    GetChars {
        private final CharSequence mSource;

        public PasswordCharSequence(CharSequence source) {
            this.mSource = source;
        }

        @Override
        public int length() {
            return this.mSource.length();
        }

        @Override
        public char charAt(int i) {
            CharSequence charSequence = this.mSource;
            if (charSequence instanceof Spanned) {
                Spanned sp = (Spanned)charSequence;
                List<Visible> visible = sp.getSpans(0, sp.length(), Visible.class);
                for (Visible value : visible) {
                    if (sp.getSpanStart(value.mTransformer) < 0) continue;
                    int st = sp.getSpanStart(value);
                    int en = sp.getSpanEnd(value);
                    if (i < st || i >= en) continue;
                    return this.mSource.charAt(i);
                }
            }
            return '\u2022';
        }

        @Override
        @Nonnull
        public CharSequence subSequence(int start, int end) {
            char[] buf = new char[end - start];
            this.getChars(start, end, buf, 0);
            return new String(buf);
        }

        @Override
        @Nonnull
        public String toString() {
            char[] buf = new char[this.mSource.length()];
            this.getChars(0, this.mSource.length(), buf, 0);
            return new String(buf);
        }

        @Override
        public void getChars(int start, int end, char[] dest, int off) {
            TextUtils.getChars(this.mSource, start, end, dest, off);
            int count = 0;
            int[] starts = null;
            int[] ends = null;
            CharSequence charSequence = this.mSource;
            if (charSequence instanceof Spanned) {
                Spanned sp = (Spanned)charSequence;
                List<Visible> visible = sp.getSpans(0, sp.length(), Visible.class);
                count = visible.size();
                starts = new int[count];
                ends = new int[count];
                for (int i = 0; i < count; ++i) {
                    if (sp.getSpanStart(visible.get((int)i).mTransformer) < 0) continue;
                    starts[i] = sp.getSpanStart(visible.get(i));
                    ends[i] = sp.getSpanEnd(visible.get(i));
                }
            }
            for (int i = start; i < end; ++i) {
                boolean visible = false;
                for (int a = 0; a < count; ++a) {
                    if (i < starts[a] || i >= ends[a]) continue;
                    visible = true;
                    break;
                }
                if (visible) continue;
                dest[i - start + off] = 8226;
            }
        }
    }

    private static class Visible
    implements UpdateLayout,
    Runnable {
        private final Spannable mText;
        private final PasswordTransformationMethod mTransformer;

        public Visible(Spannable sp, PasswordTransformationMethod ptm) {
            this.mText = sp;
            this.mTransformer = ptm;
        }

        @Override
        public void run() {
            this.mText.removeSpan(this);
        }
    }
}

