/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.Bitmap;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.graphics.text.FontCollection;
import icyllis.modernui.graphics.text.FontFamily;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.text.BitmapFont;
import icyllis.modernui.mc.text.Color3i;
import icyllis.modernui.mc.text.EffectRenderType;
import icyllis.modernui.mc.text.FormattedLayoutKey;
import icyllis.modernui.mc.text.FormattedTextWrapper;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.ModernStringSplitter;
import icyllis.modernui.mc.text.ModernTextRenderer;
import icyllis.modernui.mc.text.ReorderTextHandler;
import icyllis.modernui.mc.text.SpaceFont;
import icyllis.modernui.mc.text.StandardFontSet;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutProcessor;
import icyllis.modernui.mc.text.TextRenderType;
import icyllis.modernui.mc.text.VanillaLayoutKey;
import icyllis.modernui.mc.text.mixin.AccessFontManager;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.text.Typeface;
import icyllis.modernui.util.Pools;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1041;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_377;
import net.minecraft.class_378;
import net.minecraft.class_386;
import net.minecraft.class_389;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7166;
import net.minecraft.class_8523;
import net.minecraft.class_8541;
import net.minecraft.class_8557;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class TextLayoutEngine
extends FontResourceManager
implements MuiModApi.OnWindowResizeListener,
MuiModApi.OnDebugDumpListener {
    public static final Marker MARKER = MarkerManager.getMarker((String)"TextLayout");
    public static volatile boolean sFixedResolution = false;
    public static volatile int sTextDirection = 1;
    public static volatile int sCacheLifespan = 6;
    public static boolean sCurrentInWorldRendering;
    public static volatile boolean sUseTextShadersInWorld;
    public static volatile boolean sRawUseTextShadersInWorld;
    public static final class_2960 SANS_SERIF;
    public static final class_2960 SERIF;
    public static final class_2960 MONOSPACED;
    private static final class_2960 INTERNAL_DEFAULT;
    private final GlyphManager mGlyphManager;
    public static final int COMPUTE_ADVANCES = 1;
    public static final int COMPUTE_LINE_BOUNDARIES = 4;
    public static final int DEFAULT_FONT_BEHAVIOR_IGNORE_ALL = 0;
    public static final int DEFAULT_FONT_BEHAVIOR_KEEP_ASCII = 1;
    public static final int DEFAULT_FONT_BEHAVIOR_KEEP_OTHER = 2;
    public static final int DEFAULT_FONT_BEHAVIOR_KEEP_ALL = 3;
    public static final int DEFAULT_FONT_BEHAVIOR_ONLY_INCLUDE = 4;
    public static final int DEFAULT_FONT_BEHAVIOR_ONLY_EXCLUDE = 5;
    public static volatile int sDefaultFontBehavior;
    public static volatile List<? extends String> sDefaultFontRuleSet;
    public static volatile boolean sUseComponentCache;
    public static volatile boolean sAllowAsyncLayout;
    private final VanillaLayoutKey mVanillaLookupKey = new VanillaLayoutKey();
    private Map<VanillaLayoutKey, TextLayout> mVanillaCache = new HashMap<VanillaLayoutKey, TextLayout>();
    private Map<class_5250, TextLayout> mComponentCache = new HashMap<class_5250, TextLayout>();
    private final FormattedLayoutKey.Lookup mFormattedLayoutKey = new FormattedLayoutKey.Lookup();
    private Map<FormattedLayoutKey, TextLayout> mFormattedCache = new HashMap<FormattedLayoutKey, TextLayout>();
    private final TextLayoutProcessor mProcessor = new TextLayoutProcessor(this);
    private final Pools.Pool<TextLayoutProcessor> mProcessorPool = Pools.newSynchronizedPool(3);
    private final HashMap<class_2960, FontCollection> mFontCollections = new HashMap();
    private FontCollection mRawDefaultFontCollection;
    private final ConcurrentHashMap<class_2960, FontCollection> mRegisteredFonts = new ConcurrentHashMap();
    public static final int DEFAULT_MIN_PIXEL_DENSITY_FOR_SDF = 4;
    public static volatile int sMinPixelDensityForSDF;
    private volatile int mResLevel = 2;
    private TextDirectionHeuristic mTextDirectionHeuristic = TextDirectionHeuristics.FIRSTSTRONG_LTR;
    private class_378 mVanillaFontManager;
    private final ModernTextRenderer mTextRenderer;
    private final ModernStringSplitter mStringSplitter;
    private Boolean mForceUnicodeFont;
    private int mTimer;

    public TextLayoutEngine() {
        this.mGlyphManager = GlyphManager.getInstance();
        this.mGlyphManager.addAtlasInvalidationCallback(invalidationInfo -> {
            if (invalidationInfo.resize()) {
                this.invalidateStrikeCache();
            } else {
                this.reload();
            }
        });
        this.mTextRenderer = new ModernTextRenderer(this);
        this.mStringSplitter = new ModernStringSplitter(this, (ch, style) -> {
            throw new UnsupportedOperationException("Modern Text Engine");
        });
        ModernUI.LOGGER.info(ModernUI.MARKER, "Created TextLayoutEngine");
    }

    @Nonnull
    public static TextLayoutEngine getInstance() {
        return (TextLayoutEngine)FontResourceManager.getInstance();
    }

    @Nonnull
    public ModernTextRenderer getTextRenderer() {
        return this.mTextRenderer;
    }

    @Nonnull
    public ModernStringSplitter getStringSplitter() {
        return this.mStringSplitter;
    }

    public FontCollection getRawDefaultFontCollection() {
        return this.mRawDefaultFontCollection;
    }

    @RenderThread
    public void invalidateStrikeCache() {
        TextRenderType.clear(false);
        if (this.mVanillaFontManager != null) {
            Map<class_2960, class_377> fontSets = ((AccessFontManager)this.mVanillaFontManager).getFontSets();
            for (class_377 fontSet : fontSets.values()) {
                if (!(fontSet instanceof StandardFontSet)) continue;
                StandardFontSet standardFontSet = (StandardFontSet)fontSet;
                standardFontSet.invalidateCache(this.mResLevel);
            }
        }
    }

    public void clear() {
        int count = this.getCacheCount();
        this.mVanillaCache.clear();
        this.mComponentCache.clear();
        this.mFormattedCache.clear();
        this.mVanillaCache = new HashMap<VanillaLayoutKey, TextLayout>();
        this.mComponentCache = new HashMap<class_5250, TextLayout>();
        this.mFormattedCache = new HashMap<FormattedLayoutKey, TextLayout>();
        TextRenderType.clear(false);
        if (count > 0) {
            ModernUI.LOGGER.debug(MARKER, "Cleanup {} text layout entries", (Object)count);
        }
    }

    @RenderThread
    public void reload() {
        class_1041 window = class_310.method_1551().method_22683();
        int scale = window != null ? Math.round((float)window.method_4495()) : 2;
        this.internalReload(scale);
    }

    private void internalReload(int scale) {
        Locale locale;
        this.clear();
        int oldLevel = this.mResLevel;
        this.mResLevel = sFixedResolution ? 2 : Math.min(scale, 8);
        class_315 opts = class_310.method_1551().field_1690;
        if (opts != null) {
            this.mForceUnicodeFont = (Boolean)opts.method_42437().method_41753();
        }
        boolean layoutRtl = TextUtils.getLayoutDirectionFromLocale(locale = ModernUI.getSelectedLocale()) == 1;
        this.mTextDirectionHeuristic = switch (sTextDirection) {
            case 2 -> TextDirectionHeuristics.ANYRTL_LTR;
            case 3 -> TextDirectionHeuristics.LTR;
            case 4 -> TextDirectionHeuristics.RTL;
            case 5 -> TextDirectionHeuristics.LOCALE;
            case 6 -> TextDirectionHeuristics.FIRSTSTRONG_LTR;
            case 7 -> TextDirectionHeuristics.FIRSTSTRONG_RTL;
            default -> layoutRtl ? TextDirectionHeuristics.FIRSTSTRONG_RTL : TextDirectionHeuristics.FIRSTSTRONG_LTR;
        };
        this.mFontCollections.putIfAbsent(SANS_SERIF, Typeface.SANS_SERIF);
        this.mFontCollections.putIfAbsent(SERIF, Typeface.SERIF);
        this.mFontCollections.putIfAbsent(MONOSPACED, Typeface.MONOSPACED);
        if (sDefaultFontBehavior == 0 || sDefaultFontBehavior == 4 && (sDefaultFontRuleSet == null || sDefaultFontRuleSet.isEmpty())) {
            this.mFontCollections.put(class_310.field_1740, ModernUI.getSelectedTypeface());
        } else {
            LinkedHashSet<FontFamily> defaultFonts = new LinkedHashSet<FontFamily>();
            this.populateDefaultFonts(defaultFonts, sDefaultFontBehavior);
            defaultFonts.addAll(ModernUI.getSelectedTypeface().getFamilies());
            this.mFontCollections.put(class_310.field_1740, new FontCollection(defaultFonts.toArray(new FontFamily[0])));
        }
        if (this.mVanillaFontManager != null) {
            class_377 class_3772;
            Object standardFontSet;
            Map<class_2960, class_377> fontSets = ((AccessFontManager)this.mVanillaFontManager).getFontSets();
            class_377 class_37722 = fontSets.get(class_310.field_1740);
            if (class_37722 instanceof StandardFontSet) {
                standardFontSet = (StandardFontSet)class_37722;
                ((StandardFontSet)((Object)standardFontSet)).reload(this.mFontCollections.get(class_310.field_1740), this.mResLevel);
            }
            if ((class_3772 = fontSets.get(class_310.field_24211)) instanceof StandardFontSet) {
                standardFontSet = (StandardFontSet)class_3772;
                ((StandardFontSet)((Object)standardFontSet)).reload(ModernUI.getSelectedTypeface(), this.mResLevel);
            }
            for (Map.Entry entry : fontSets.entrySet()) {
                Object v;
                if (((class_2960)entry.getKey()).equals((Object)class_310.field_1740) || ((class_2960)entry.getKey()).equals((Object)class_310.field_24211) || !((v = entry.getValue()) instanceof StandardFontSet)) continue;
                StandardFontSet standardFontSet2 = (StandardFontSet)((Object)v);
                standardFontSet2.invalidateCache(this.mResLevel);
            }
            if (!fontSets.containsKey(class_310.field_24211)) {
                StandardFontSet fontSet = new StandardFontSet(class_310.method_1551().method_1531(), class_310.field_24211);
                fontSet.reload(ModernUI.getSelectedTypeface(), this.mResLevel);
                fontSets.put(class_310.field_24211, fontSet);
            }
        }
        ModernUI.LOGGER.info(MARKER, "Reloaded text layout engine, res level: {} to {}, locale: {}, layout RTL: {}", (Object)oldLevel, (Object)this.mResLevel, (Object)locale, (Object)layoutRtl);
    }

    @Override
    @RenderThread
    public void reloadAll() {
        super.reloadAll();
        this.mGlyphManager.reload();
        ModernUI.LOGGER.info(GlyphManager.MARKER, "Reloaded glyph manager");
        this.reload();
    }

    @Override
    public void onWindowResize(int width, int height, int newScale, int oldScale) {
        if (Core.getRenderThread() != null) {
            boolean reload;
            boolean bl = reload = newScale != oldScale;
            if (!reload) {
                Boolean forceUnicodeFont = (Boolean)class_310.method_1551().field_1690.method_42437().method_41753();
                boolean bl2 = reload = !Objects.equals(this.mForceUnicodeFont, forceUnicodeFont);
            }
            if (reload) {
                this.internalReload(newScale);
            }
        }
    }

    @Override
    public void onDebugDump(@Nonnull PrintWriter pw) {
        pw.print("TextLayoutEngine: ");
        pw.print("CacheCount=" + this.getCacheCount());
        long memorySize = this.getCacheMemorySize();
        pw.println(", CacheSize=" + TextUtils.binaryCompact(memorySize) + " (" + memorySize + " bytes)");
    }

    @Nonnull
    public TextLayoutEngine injectFontManager(@Nonnull class_378 manager) {
        this.mVanillaFontManager = manager;
        return this;
    }

    private void populateDefaultFonts(Set<FontFamily> set, int behavior) {
        if (this.mRawDefaultFontCollection == null) {
            return;
        }
        if (behavior == 4 || behavior == 5) {
            Pattern pattern = null;
            List<? extends String> rules = sDefaultFontRuleSet;
            if (rules != null && !rules.isEmpty()) {
                try {
                    pattern = Pattern.compile(rules.stream().distinct().collect(Collectors.joining("|")));
                }
                catch (PatternSyntaxException e) {
                    ModernUI.LOGGER.warn(MARKER, "Illegal default font rules: {}", rules, (Object)e);
                }
            }
            boolean exclusive = behavior == 5;
            for (FontFamily family : this.mRawDefaultFontCollection.getFamilies()) {
                String name = family.getFamilyName();
                boolean matches = pattern != null && pattern.matcher(name).matches();
                if (!(matches ^ exclusive)) continue;
                set.add(family);
            }
        } else {
            block12: for (FontFamily family : this.mRawDefaultFontCollection.getFamilies()) {
                switch (family.getFamilyName()) {
                    case "minecraft:font/nonlatin_european.png": 
                    case "minecraft:font/accented.png": 
                    case "minecraft:font/ascii.png": 
                    case "minecraft:include/space / minecraft:space": {
                        if ((behavior & 1) == 0) continue block12;
                        set.add(family);
                        continue block12;
                    }
                }
                if ((behavior & 2) == 0) continue;
                set.add(family);
            }
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> method_25931(@Nonnull class_3302.class_4045 preparationBarrier, @Nonnull class_3300 resourceManager, @Nonnull class_3695 preparationProfiler, @Nonnull class_3695 reloadProfiler, @Nonnull Executor preparationExecutor, @Nonnull Executor reloadExecutor) {
        preparationProfiler.method_16065();
        preparationProfiler.method_16066();
        return ((CompletableFuture)this.prepareResources(resourceManager, preparationExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(results -> {
            reloadProfiler.method_16065();
            reloadProfiler.method_15396("reload");
            this.applyResources((LoadResults)results);
            reloadProfiler.method_15407();
            reloadProfiler.method_16066();
        }, reloadExecutor);
    }

    @Nonnull
    private CompletableFuture<LoadResults> prepareResources(@Nonnull class_3300 resourceManager, @Nonnull Executor preparationExecutor) {
        LoadResults results = new LoadResults();
        CompletableFuture<Void> loadFonts = CompletableFuture.runAsync(() -> TextLayoutEngine.loadFonts(resourceManager, results), preparationExecutor);
        CompletableFuture<Void> loadEmojis = CompletableFuture.runAsync(() -> TextLayoutEngine.loadEmojis(resourceManager, results), preparationExecutor);
        CompletableFuture<Void> loadShortcodes = CompletableFuture.runAsync(() -> TextLayoutEngine.loadShortcodes(resourceManager, results), preparationExecutor);
        return CompletableFuture.allOf(loadFonts, loadEmojis, loadShortcodes).thenApply(__ -> results);
    }

    private void applyResources(@Nonnull LoadResults results) {
        this.closeFonts();
        this.mFontCollections.clear();
        this.mFontCollections.putAll(this.mRegisteredFonts);
        this.mFontCollections.putAll(results.mFontCollections);
        this.mRawDefaultFontCollection = this.mFontCollections.get(class_310.field_1740);
        if (this.mVanillaFontManager != null) {
            Map<class_2960, class_377> fontSets = ((AccessFontManager)this.mVanillaFontManager).getFontSets();
            fontSets.values().forEach(class_377::close);
            fontSets.clear();
            class_1060 textureManager = class_310.method_1551().method_1531();
            this.mFontCollections.forEach((fontName, fontCollection) -> {
                StandardFontSet fontSet = new StandardFontSet(textureManager, (class_2960)fontName);
                fontSet.reload((FontCollection)fontCollection, this.mResLevel);
                fontSets.put((class_2960)fontName, fontSet);
            });
        } else {
            ModernUI.LOGGER.warn(MARKER, "Where is font manager?");
        }
        if (this.mRawDefaultFontCollection == null) {
            throw new IllegalStateException("Default font failed to load");
        }
        super.applyResources(results);
    }

    @Override
    public void close() {
        this.mGlyphManager.closeAtlases();
        this.closeFonts();
        TextRenderType.clear(true);
        EffectRenderType.clear();
    }

    private void closeFonts() {
        for (FontCollection fontCollection : this.mFontCollections.values()) {
            for (FontFamily family : fontCollection.getFamilies()) {
                Font font = family.getClosestMatch(0);
                if (!(font instanceof BitmapFont)) continue;
                BitmapFont bitmapFont = (BitmapFont)font;
                bitmapFont.close();
            }
        }
        if (this.mRawDefaultFontCollection != null) {
            for (FontFamily family : this.mRawDefaultFontCollection.getFamilies()) {
                Font font = family.getClosestMatch(0);
                if (!(font instanceof BitmapFont)) continue;
                BitmapFont bitmapFont = (BitmapFont)font;
                bitmapFont.close();
            }
        }
    }

    @Override
    public void onFontRegistered(@Nonnull FontFamily f) {
        super.onFontRegistered(f);
        String name = f.getFamilyName();
        try {
            String newName = name.toLowerCase(Locale.ROOT).replaceAll(" ", "-");
            FontCollection fc = new FontCollection(f);
            class_2960 location = ModernUIMod.location(newName);
            if (this.mRegisteredFonts.putIfAbsent(location, fc) == null) {
                ModernUI.LOGGER.info(MARKER, "Redirect registered font '{}' to '{}'", (Object)name, (Object)location);
            }
        }
        catch (Exception e) {
            ModernUI.LOGGER.warn(MARKER, "Failed to redirect registered font '{}'", (Object)name);
        }
    }

    private static boolean isUnicodeFont(@Nonnull class_2960 name) {
        if (name.equals((Object)class_310.field_24211)) {
            return true;
        }
        if (name.method_12836().equals("minecraft")) {
            return name.method_12832().equals("include/unifont");
        }
        return false;
    }

    private static void loadFonts(@Nonnull class_3300 resources, @Nonnull LoadResults results) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        ArrayList<RawFontBundle> bundles = new ArrayList<RawFontBundle>();
        for (Map.Entry entry : resources.method_41265("font", res -> res.method_12832().endsWith(".json")).entrySet()) {
            String path;
            class_2960 location = (class_2960)entry.getKey();
            class_2960 name2 = location.method_45136((path = location.method_12832()).substring(5, path.length() - 5));
            if (TextLayoutEngine.isUnicodeFont(name2)) continue;
            RawFontBundle bundle2 = new RawFontBundle(name2);
            bundles.add(bundle2);
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonArray providers = class_3518.method_15261((JsonObject)Objects.requireNonNull((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)), (String)"providers");
                        for (int i = 0; i < providers.size(); ++i) {
                            JsonObject metadata = class_3518.method_15295((JsonElement)providers.get(i), (String)("providers[" + i + "]"));
                            class_389 definition = (class_389)class_156.method_47526((DataResult)class_389.field_44801.parse((DynamicOps)JsonOps.INSTANCE, (Object)metadata), JsonParseException::new);
                            TextLayoutEngine.loadSingleFont(resources, name2, bundle2, resource.method_14480(), i, metadata, definition);
                        }
                        ModernUI.LOGGER.info(MARKER, "Loaded raw font '{}' in pack: '{}'", (Object)name2, (Object)resource.method_14480());
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    ModernUI.LOGGER.warn(MARKER, "Failed to load font '{}' in pack: '{}'", (Object)name2, (Object)resource.method_14480(), (Object)e);
                }
            }
            ModernUI.LOGGER.info(MARKER, "Loaded raw font bundle: '{}', font set: [{}]", (Object)location, (Object)bundle2.families.stream().map(object -> {
                if (object instanceof FontFamily) {
                    FontFamily family = (FontFamily)object;
                    return family.getFamilyName();
                }
                return object.toString();
            }).collect(Collectors.joining(",")));
        }
        class_8523 sorter = new class_8523();
        for (RawFontBundle bundle3 : bundles) {
            sorter.method_51486((Object)bundle3.name, (class_8523.class_8524)bundle3);
        }
        HashMap<class_2960, FontCollection> map = new HashMap<class_2960, FontCollection>();
        map.put(INTERNAL_DEFAULT, ModernUI.getSelectedTypeface());
        sorter.method_51487((name, bundle) -> {
            if (TextLayoutEngine.isUnicodeFont(name)) {
                return;
            }
            LinkedHashSet<FontFamily> set = new LinkedHashSet<FontFamily>();
            for (Object object : bundle.families) {
                if (object instanceof FontFamily) {
                    FontFamily family = (FontFamily)object;
                    set.add(family);
                    continue;
                }
                class_2960 reference = (class_2960)object;
                FontCollection resolved = (FontCollection)map.get(reference);
                if (resolved != null) {
                    set.addAll(resolved.getFamilies());
                    continue;
                }
                ModernUI.LOGGER.warn(MARKER, "Failed to resolve font: {}", (Object)reference);
            }
            if (!set.isEmpty()) {
                map.put((class_2960)name, new FontCollection(set.toArray(new FontFamily[0])));
                ModernUI.LOGGER.info(MARKER, "Loaded font: '{}', font set: [{}]", name, (Object)set.stream().map(FontFamily::getFamilyName).collect(Collectors.joining(",")));
            } else {
                ModernUI.LOGGER.warn(MARKER, "Ignore font: '{}', because it's empty", name);
            }
        });
        map.remove(INTERNAL_DEFAULT);
        results.mFontCollections = map;
    }

    private static void loadSingleFont(@Nonnull class_3300 resources, class_2960 name, RawFontBundle bundle, String sourcePackId, int index, JsonObject metadata, @Nonnull class_389 definition) {
        switch (definition.method_51731()) {
            case field_2312: {
                BitmapFont bitmapFont = BitmapFont.create((class_386.class_387)definition, resources);
                bundle.families.add(new FontFamily(bitmapFont));
                break;
            }
            case field_2317: {
                class_8557 ttf = (class_8557)definition;
                if (metadata.has("size")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'size={}' of providers[{}] in font '{}' in pack: '{}'", (Object)Float.valueOf(ttf.comp_1525()), (Object)index, (Object)name, (Object)sourcePackId);
                }
                if (metadata.has("oversample")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'oversample={}' of providers[{}] in font '{}' in pack: '{}'", (Object)Float.valueOf(ttf.comp_1526()), (Object)index, (Object)name, (Object)sourcePackId);
                }
                if (metadata.has("shift")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'shift={}' of providers[{}] in font '{}' in pack: '{}'", (Object)ttf.comp_1527(), (Object)index, (Object)name, (Object)sourcePackId);
                }
                if (metadata.has("skip")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'skip={}' of providers[{}] in font '{}' in pack: '{}'", (Object)ttf.comp_1528(), (Object)index, (Object)name, (Object)sourcePackId);
                }
                bundle.families.add(TextLayoutEngine.createTTF(ttf.comp_1524(), resources));
                break;
            }
            case field_37904: {
                SpaceFont spaceFont = SpaceFont.create(name, (class_7166.class_8554)definition);
                bundle.families.add(new FontFamily(spaceFont));
                break;
            }
            case field_2313: {
                bundle.families.add(INTERNAL_DEFAULT);
                break;
            }
            case field_44761: {
                class_2960 reference = ((class_8541)definition).comp_1523();
                if (!TextLayoutEngine.isUnicodeFont(reference)) {
                    bundle.families.add(reference);
                    bundle.dependencies.add(reference);
                    break;
                }
                if (name.equals((Object)class_310.field_1740)) break;
                bundle.families.add(INTERNAL_DEFAULT);
                break;
            }
            default: {
                ModernUI.LOGGER.info(MARKER, "Unknown provider type '{}' in font '{}' in pack: '{}'", (Object)definition.method_51731(), (Object)name, (Object)sourcePackId);
            }
        }
    }

    @Nonnull
    private static FontFamily createTTF(@Nonnull class_2960 file, class_3300 resources) {
        FontFamily fontFamily;
        block8: {
            class_2960 location = file.method_45138("font/");
            InputStream stream = resources.open(location);
            try {
                fontFamily = FontFamily.createFamily(stream, false);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return fontFamily;
    }

    public static int adjustPixelDensityForSDF(int resLevel) {
        return Math.max(resLevel, sMinPixelDensityForSDF);
    }

    @Nonnull
    public TextLayout lookupVanillaLayout(@Nonnull String text) {
        return this.lookupVanillaLayout(text, class_2583.field_24360, 0);
    }

    @Nonnull
    public TextLayout lookupVanillaLayout(@Nonnull String text, @Nonnull class_2583 style) {
        return this.lookupVanillaLayout(text, style, 0);
    }

    @Nonnull
    public TextLayout lookupVanillaLayout(@Nonnull String text, @Nonnull class_2583 style, int computeFlags) {
        if (text.isEmpty()) {
            return TextLayout.EMPTY;
        }
        if (!RenderSystem.isOnRenderThread()) {
            if (sAllowAsyncLayout) {
                TextLayoutProcessor proc = this.mProcessorPool.acquire();
                if (proc == null) {
                    proc = new TextLayoutProcessor(this);
                }
                TextLayout layout = proc.createVanillaLayout(text, style, this.mResLevel, computeFlags);
                this.mProcessorPool.release(proc);
                return layout;
            }
            return (TextLayout)class_310.method_1551().method_5385(() -> this.lookupVanillaLayout(text, style, computeFlags)).join();
        }
        TextLayout layout = this.mVanillaCache.get(this.mVanillaLookupKey.update(text, style));
        int nowFlags = 0;
        if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
            layout = this.mProcessor.createVanillaLayout(text, style, this.mResLevel, nowFlags | computeFlags);
            this.mVanillaCache.put(this.mVanillaLookupKey.copy(), layout);
            return layout;
        }
        return layout.get();
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull class_5348 text) {
        return this.lookupFormattedLayout(text, class_2583.field_24360, 0);
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull class_5348 text, @Nonnull class_2583 style) {
        return this.lookupFormattedLayout(text, style, 0);
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull class_5348 text, @Nonnull class_2583 style, int computeFlags) {
        TextLayout layout;
        if (text == class_5244.field_39003 || text == class_5348.field_25310) {
            return TextLayout.EMPTY;
        }
        if (!RenderSystem.isOnRenderThread()) {
            if (sAllowAsyncLayout) {
                TextLayoutProcessor proc = this.mProcessorPool.acquire();
                if (proc == null) {
                    proc = new TextLayoutProcessor(this);
                }
                TextLayout layout2 = proc.createTextLayout(text, style, this.mResLevel, computeFlags);
                this.mProcessorPool.release(proc);
                return layout2;
            }
            return (TextLayout)class_310.method_1551().method_5385(() -> this.lookupFormattedLayout(text, style, computeFlags)).join();
        }
        int nowFlags = 0;
        if (style.method_10967() && sUseComponentCache && text instanceof class_5250) {
            class_5250 component = (class_5250)text;
            layout = this.mComponentCache.get(component);
            if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                layout = this.mProcessor.createTextLayout(text, class_2583.field_24360, this.mResLevel, nowFlags | computeFlags);
                this.mComponentCache.put(component, layout);
                return layout;
            }
        } else {
            layout = this.mFormattedCache.get(this.mFormattedLayoutKey.update(text, style));
            if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                layout = this.mProcessor.createTextLayout(text, style, this.mResLevel, nowFlags | computeFlags);
                this.mFormattedCache.put(this.mFormattedLayoutKey.copy(), layout);
                return layout;
            }
        }
        return layout.get();
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull class_5481 sequence) {
        return this.lookupFormattedLayout(sequence, 0);
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull class_5481 sequence, int computeFlags) {
        if (sequence == class_5481.field_26385) {
            return TextLayout.EMPTY;
        }
        if (!RenderSystem.isOnRenderThread()) {
            if (sAllowAsyncLayout) {
                TextLayoutProcessor proc = this.mProcessorPool.acquire();
                if (proc == null) {
                    proc = new TextLayoutProcessor(this);
                }
                TextLayout layout = proc.createSequenceLayout(sequence, this.mResLevel, computeFlags);
                this.mProcessorPool.release(proc);
                return layout;
            }
            return (TextLayout)class_310.method_1551().method_5385(() -> this.lookupFormattedLayout(sequence, computeFlags)).join();
        }
        int nowFlags = 0;
        if (sequence instanceof FormattedTextWrapper) {
            TextLayout layout;
            class_5348 text = ((FormattedTextWrapper)sequence).mText;
            if (text == class_5244.field_39003 || text == class_5348.field_25310) {
                return TextLayout.EMPTY;
            }
            if (sUseComponentCache && text instanceof class_5250) {
                class_5250 component = (class_5250)text;
                layout = this.mComponentCache.get(component);
                if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                    layout = this.mProcessor.createTextLayout(text, class_2583.field_24360, this.mResLevel, nowFlags | computeFlags);
                    this.mComponentCache.put(component, layout);
                    return layout;
                }
            } else {
                layout = this.mFormattedCache.get(this.mFormattedLayoutKey.update(text, class_2583.field_24360));
                if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                    layout = this.mProcessor.createTextLayout(text, class_2583.field_24360, this.mResLevel, nowFlags | computeFlags);
                    this.mFormattedCache.put(this.mFormattedLayoutKey.copy(), layout);
                    return layout;
                }
            }
            return layout.get();
        }
        TextLayout layout = this.mFormattedCache.get(this.mFormattedLayoutKey.update(sequence));
        if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
            layout = this.mProcessor.createSequenceLayout(sequence, this.mResLevel, nowFlags | computeFlags);
            this.mFormattedCache.put(this.mFormattedLayoutKey.copy(), layout);
            return layout;
        }
        return layout.get();
    }

    @Deprecated
    public boolean handleSequence(class_5481 sequence, ReorderTextHandler.IConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public FontCollection getFontCollection(@Nonnull class_2960 fontName) {
        FontCollection fontCollection;
        if (this.mForceUnicodeFont == Boolean.TRUE && fontName.equals((Object)class_310.field_1740)) {
            fontName = class_310.field_24211;
        }
        return (fontCollection = this.mFontCollections.get(fontName)) != null ? fontCollection : ModernUI.getSelectedTypeface();
    }

    public void dumpBitmapFonts() {
        String basePath = Bitmap.saveDialogGet(Bitmap.SaveFormat.PNG, null, "BitmapFont");
        if (basePath != null) {
            basePath = basePath.substring(0, basePath.length() - 4);
        }
        int index = 0;
        IdentityHashMap<BitmapFont, Boolean> visited = new IdentityHashMap<BitmapFont, Boolean>();
        for (FontCollection fc : this.mFontCollections.values()) {
            for (FontFamily family : fc.getFamilies()) {
                BitmapFont bmf;
                Font font = family.getClosestMatch(0);
                if (!(font instanceof BitmapFont) || visited.put(bmf = (BitmapFont)font, Boolean.TRUE) != null) continue;
                if (basePath != null) {
                    bmf.dumpAtlas(index, basePath + "_" + index + ".png");
                } else {
                    bmf.dumpAtlas(index, null);
                }
                ++index;
            }
        }
    }

    @Deprecated
    @Nullable
    private GLBakedGlyph lookupEmoji(@Nonnull char[] buf, int start, int end) {
        return null;
    }

    public void onEndClientTick() {
        if (this.mTimer == 0) {
            boolean useTextShadersEffective;
            int lifespan = sCacheLifespan;
            Predicate<TextLayout> ticker = layout -> layout.tick(lifespan);
            this.mVanillaCache.values().removeIf(ticker);
            this.mComponentCache.values().removeIf(ticker);
            this.mFormattedCache.values().removeIf(ticker);
            boolean bl = useTextShadersEffective = sRawUseTextShadersInWorld && !ModernUIClient.areShadersEnabled();
            if (sUseTextShadersInWorld != useTextShadersEffective) {
                this.reload();
                sUseTextShadersInWorld = useTextShadersEffective;
            }
        }
        this.mTimer = (this.mTimer + 1) % 20;
    }

    public int getCacheCount() {
        return this.mVanillaCache.size() + this.mComponentCache.size() + this.mFormattedCache.size();
    }

    public int getCacheMemorySize() {
        int size = 0;
        for (TextLayout textLayout : this.mVanillaCache.values()) {
            size += textLayout.getMemorySize();
        }
        for (TextLayout textLayout : this.mComponentCache.values()) {
            size += textLayout.getMemorySize();
        }
        for (Map.Entry entry : this.mFormattedCache.entrySet()) {
            size += ((FormattedLayoutKey)entry.getKey()).getMemorySize();
            size += ((TextLayout)entry.getValue()).getMemorySize();
        }
        return size;
    }

    public void dumpLayoutCache() {
        int i = 0;
        for (Map.Entry<VanillaLayoutKey, TextLayout> entry : this.mVanillaCache.entrySet()) {
            ModernUI.LOGGER.info(MARKER, "VanillaCache {}\n{}\n{}", (Object)i, (Object)entry.getKey(), (Object)entry.getValue().toDetailedString());
            ++i;
        }
        for (Map.Entry<VanillaLayoutKey, TextLayout> entry : this.mComponentCache.entrySet()) {
            ModernUI.LOGGER.info(MARKER, "ComponentCache {}\n{}\n{}", (Object)i, (Object)entry.getKey(), (Object)entry.getValue().toDetailedString());
            ++i;
        }
        for (Map.Entry<Object, TextLayout> entry : this.mFormattedCache.entrySet()) {
            ModernUI.LOGGER.info(MARKER, "FormattedCache {}\n{}\n{}", (Object)i, entry.getKey(), (Object)entry.getValue().toDetailedString());
            ++i;
        }
    }

    public int getResLevel() {
        return this.mResLevel;
    }

    @Nonnull
    public TextDirectionHeuristic getTextDirectionHeuristic() {
        return this.mTextDirectionHeuristic;
    }

    @Deprecated
    private void cacheDigitGlyphs() {
    }

    @Nullable
    @Deprecated
    private TextLayout generateAndCache(VanillaLayoutKey key, @Nonnull CharSequence string, @Nonnull class_2583 style) {
        if (!RenderSystem.isOnRenderThread()) {
            return (TextLayout)class_310.method_1551().method_5385(() -> this.generateAndCache(key, string, style)).join();
        }
        return null;
    }

    @Nonnull
    @Deprecated
    private Entry getOrCacheString(@Nonnull String str) {
        RenderSystem.assertOnRenderThread();
        char[] text = str.toCharArray();
        Entry entry = new Entry();
        int length = this.extractFormattingCodes(entry, str, text);
        ArrayList<Glyph> glyphList = new ArrayList<Glyph>();
        entry.advance = this.layoutBidiString(glyphList, text, 0, length, entry.codes);
        entry.glyphs = new Glyph[glyphList.size()];
        entry.glyphs = glyphList.toArray(entry.glyphs);
        Arrays.sort(entry.glyphs);
        boolean colorIndex = false;
        boolean shift = false;
        for (int glyphIndex = 0; glyphIndex < entry.glyphs.length; ++glyphIndex) {
            Glyph glyph = entry.glyphs[glyphIndex];
        }
        Key key = new Key();
        key.str = str;
        return entry;
    }

    @Deprecated
    private void layoutFont(TextLayoutProcessor data, char[] text, int start, int limit, int flag, Font font, boolean random, byte effect) {
    }

    @Deprecated
    private void layoutRandom(TextLayoutProcessor data, char[] text, int start, int limit, int flag, Font font, byte effect) {
    }

    @Deprecated
    private void insertColorState(@Nonnull TextLayoutProcessor data) {
    }

    @Deprecated
    private int extractFormattingCodes(Entry cacheEntry, @Nonnull String str, char[] text) {
        int next;
        ArrayList<FormattingCode> codeList = new ArrayList<FormattingCode>();
        int start = 0;
        int shift = 0;
        int fontStyle = 0;
        int renderStyle = 0;
        int colorCode = -1;
        while ((next = str.indexOf(167, start)) != -1 && next + 1 < str.length()) {
            System.arraycopy(text, next - shift + 2, text, next - shift, text.length - next - 2);
            int code = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(str.charAt(next + 1)));
            switch (code) {
                case 16: {
                    break;
                }
                case 17: {
                    fontStyle = (byte)(fontStyle | 1);
                    break;
                }
                case 18: {
                    renderStyle = (byte)(renderStyle | 2);
                    cacheEntry.needExtraRender = true;
                    break;
                }
                case 19: {
                    renderStyle = (byte)(renderStyle | 1);
                    cacheEntry.needExtraRender = true;
                    break;
                }
                case 20: {
                    fontStyle = (byte)(fontStyle | 2);
                    break;
                }
                case 21: {
                    fontStyle = 0;
                    renderStyle = 0;
                    colorCode = -1;
                    break;
                }
                default: {
                    if (code < 0) break;
                    colorCode = (byte)code;
                }
            }
            FormattingCode formatting = new FormattingCode();
            formatting.stringIndex = next;
            formatting.stripIndex = next - shift;
            formatting.color = Color3i.fromFormattingCode(colorCode);
            formatting.fontStyle = (byte)fontStyle;
            formatting.renderEffect = (byte)renderStyle;
            codeList.add(formatting);
            start = next + 2;
            shift += 2;
        }
        cacheEntry.codes = codeList.toArray(new FormattingCode[0]);
        return text.length - shift;
    }

    @Deprecated
    private float layoutBidiString(List<Glyph> glyphList, char[] text, int start, int limit, FormattingCode[] codes) {
        float advance = 0.0f;
        if (Bidi.requiresBidi((char[])text, (int)start, (int)limit)) {
            Bidi bidi = new Bidi(text, start, null, 0, limit - start, 126);
            if (bidi.isRightToLeft()) {
                return this.layoutStyle(glyphList, text, start, limit, 0, advance, codes);
            }
            int runCount = bidi.getRunCount();
            byte[] levels = new byte[runCount];
            Object[] ranges = new Integer[runCount];
            for (int index = 0; index < runCount; ++index) {
                levels[index] = (byte)bidi.getRunLevel(index);
                ranges[index] = index;
            }
            Bidi.reorderVisually((byte[])levels, (int)0, (Object[])ranges, (int)0, (int)runCount);
            for (int visualIndex = 0; visualIndex < runCount; ++visualIndex) {
                int logicalIndex = (Integer)ranges[visualIndex];
                int layoutFlag = 0;
                advance = this.layoutStyle(glyphList, text, start + bidi.getRunStart(logicalIndex), start + bidi.getRunLimit(logicalIndex), layoutFlag, advance, codes);
            }
            return advance;
        }
        return this.layoutStyle(glyphList, text, start, limit, 0, advance, codes);
    }

    @Deprecated
    private float layoutStyle(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, FormattingCode[] codes) {
        boolean currentFontStyle = false;
        return advance;
    }

    @Deprecated
    private float layoutString(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, int style) {
        while (start < limit) {
            int next = 0;
            if (next == start) {
                // empty if block
            }
            start = ++next;
        }
        return advance;
    }

    @Deprecated
    private float layoutFont(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, Font font) {
        Object vector = null;
        Object glyph = null;
        boolean numGlyphs = true;
        return advance;
    }

    static {
        sUseTextShadersInWorld = true;
        sRawUseTextShadersInWorld = true;
        SANS_SERIF = ModernUIMod.location("sans-serif");
        SERIF = ModernUIMod.location("serif");
        MONOSPACED = ModernUIMod.location("monospace");
        INTERNAL_DEFAULT = ModernUIMod.location("internal-default");
        sDefaultFontBehavior = 0;
        sUseComponentCache = true;
        sAllowAsyncLayout = true;
        sMinPixelDensityForSDF = 4;
    }

    private static final class LoadResults
    extends FontResourceManager.LoadResults {
        volatile Map<class_2960, FontCollection> mFontCollections;

        private LoadResults() {
        }
    }

    private static final class RawFontBundle
    implements class_8523.class_8524<class_2960> {
        final class_2960 name;
        Set<Object> families = new LinkedHashSet<Object>();
        Set<class_2960> dependencies = new HashSet<class_2960>();

        RawFontBundle(class_2960 name) {
            this.name = name;
        }

        public void method_51478(@Nonnull Consumer<class_2960> visitor) {
            this.dependencies.forEach(visitor);
        }

        public void method_51480(@Nonnull Consumer<class_2960> visitor) {
        }
    }

    @Deprecated
    private static class Entry {
        public WeakReference<Key> keyRef;
        public float advance;
        public Glyph[] glyphs;
        public FormattingCode[] codes;
        public boolean needExtraRender;

        private Entry() {
        }
    }

    @Deprecated
    private static class FormattingCode
    implements Comparable<Integer> {
        public static final byte UNDERLINE = 1;
        public static final byte STRIKETHROUGH = 2;
        public int stringIndex;
        public int stripIndex;
        public byte fontStyle;
        @Nullable
        public Color3i color;
        public byte renderEffect;

        private FormattingCode() {
        }

        @Override
        public int compareTo(@Nonnull Integer i) {
            return Integer.compare(this.stringIndex, i);
        }
    }

    @Deprecated
    private static class Glyph
    implements Comparable<Glyph> {
        int stringIndex;
        int texture;
        int x;
        int y;
        float advance;

        private Glyph() {
        }

        @Override
        public int compareTo(Glyph o) {
            return Integer.compare(this.stringIndex, o.stringIndex);
        }
    }

    @Deprecated
    private static class Key {
        public String str;

        private Key() {
        }

        public int hashCode() {
            int code = 0;
            int length = this.str.length();
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                int c = this.str.charAt(index);
                if (c >= 48 && c <= 57 && !colorCode) {
                    c = 48;
                }
                code = code * 31 + c;
                colorCode = c == 167;
            }
            return code;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            String other = o.toString();
            int length = this.str.length();
            if (length != other.length()) {
                return false;
            }
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                char c2;
                char c1 = this.str.charAt(index);
                if (c1 != (c2 = other.charAt(index)) && (c1 < '0' || c1 > '9' || c2 < '0' || c2 > '9' || colorCode)) {
                    return false;
                }
                colorCode = c1 == '\u00a7';
            }
            return true;
        }

        public String toString() {
            return this.str;
        }
    }
}

