/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutEngine;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_156;
import net.minecraft.class_2178;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class MuiTextCommand {
    public static final class_2960 JB_MONO = ModernUIMod.location("jetbrains-mono-medium");

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"modernui").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"text").then(ClientCommandManager.literal((String)"layout").then(ClientCommandManager.argument((String)"message", (ArgumentType)class_2178.method_9281()).executes(ctx -> {
            MuiTextCommand.layout((FabricClientCommandSource)ctx.getSource(), (class_2561)ctx.getArgument("message", class_2561.class));
            return 1;
        })))).then(ClientCommandManager.literal((String)"splitLines").then(ClientCommandManager.argument((String)"width", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(ClientCommandManager.argument((String)"message", (ArgumentType)class_2178.method_9281()).executes(ctx -> {
            MuiTextCommand.splitLines((FabricClientCommandSource)ctx.getSource(), (class_2561)ctx.getArgument("message", class_2561.class), ((Float)ctx.getArgument("width", Float.class)).floatValue());
            return 1;
        }))))));
    }

    private static void layout(FabricClientCommandSource source, class_2561 component) {
        TextLayout layout = TextLayoutEngine.getInstance().lookupFormattedLayout((class_5348)component, class_2583.field_24360, 5);
        StringBuilder b = new StringBuilder();
        char[] chars = layout.getTextBuf();
        b.append("chars (logical order): ").append(chars.length).append('\n');
        float[] advances = layout.getAdvances();
        b.append("advances (normalized, cluster-based, logical order)\n");
        b.append("LB=line break, GB=grapheme break, NB=non-breaking\n");
        int[] lineBoundaries = layout.getLineBoundaries();
        int lineBoundaryIndex = 0;
        int nextLineBoundary = lineBoundaries[lineBoundaryIndex++];
        int i = 0;
        while (i < chars.length) {
            int j;
            b.append(String.format(" %04X ", i));
            int lim = Math.min(i + 8, chars.length);
            for (j = i; j < lim; ++j) {
                b.append(String.format("\\u%04X", chars[j]));
            }
            b.append("\n      ");
            for (j = i; j < lim; ++j) {
                b.append(String.format(" %5.1f", Float.valueOf(advances[j])));
            }
            b.append("\n      ");
            for (j = i; j < lim; ++j) {
                if (j == nextLineBoundary) {
                    b.append("LB    ");
                    nextLineBoundary = lineBoundaries[lineBoundaryIndex++];
                    continue;
                }
                if (advances[j] != 0.0f) {
                    b.append("GB    ");
                    continue;
                }
                b.append("NB    ");
            }
            b.append('\n');
            i = lim;
        }
        int[] glyphs = layout.getGlyphs();
        b.append("glyphs (font/slot/glyph, visual order): ").append(glyphs.length).append('\n');
        float[] positions = layout.getPositions();
        byte[] fontIndices = layout.getFontIndices();
        b.append("positions (normalized x/y, visual order)\n");
        int[] glyphFlags = layout.getGlyphFlags();
        b.append("B=bold, I=italic, U=underline, S=strikethrough\n");
        b.append("O=obfuscated, E=color emoji, M=embedded bitmap\n");
        int i2 = 0;
        while (i2 < glyphs.length) {
            int j;
            b.append(String.format(" %04X ", i2));
            int lim = Math.min(i2 + 4, glyphs.length);
            for (j = i2; j < lim; ++j) {
                int idx = fontIndices == null ? 0 : fontIndices[j] & 0xFF;
                b.append(String.format(" %02X %02X %04X ", idx, glyphs[j] >>> 24, glyphs[j] & 0xFFFF));
            }
            b.append("\n      ");
            for (j = i2; j < lim; ++j) {
                b.append(String.format("%6.1f,%4.1f ", Float.valueOf(positions[j << 1]), Float.valueOf(positions[j << 1 | 1])));
            }
            b.append("\n      ");
            for (j = i2; j < lim; ++j) {
                int flag = glyphFlags[j];
                b.append(' ');
                TextLayout.toFlagString(b, flag);
                b.append("    ");
            }
            b.append('\n');
            i2 = lim;
        }
        Font[] fonts = layout.getFontVector();
        for (int i3 = 0; i3 < fonts.length; ++i3) {
            b.append(String.format(" %02X: %s\n", i3, fonts[i3].getFamilyName()));
        }
        b.append("total advance: ");
        b.append(layout.getTotalAdvance());
        b.append('\n');
        String result = b.toString();
        source.sendFeedback(component);
        source.sendFeedback((class_2561)class_2561.method_43470((String)result).method_10862(class_2583.field_24360.method_27704(JB_MONO)));
        class_156.method_27958().execute(() -> ModernUI.LOGGER.info(TextLayoutEngine.MARKER, result));
    }

    private static void splitLines(FabricClientCommandSource source, class_2561 component, float width) {
        class_5250 b = class_2561.method_43473();
        int[] lineNum = new int[]{0};
        TextLayoutEngine.getInstance().getStringSplitter().computeLineBreaks((class_5348)component, width, class_2583.field_24360, (line, notFirstLine) -> {
            String lineString = line.getString();
            int len = lineString.length();
            Object[] objectArray = new Object[3];
            int n = lineNum[0];
            lineNum[0] = n + 1;
            objectArray[0] = n;
            objectArray[1] = len;
            objectArray[2] = notFirstLine;
            b.method_10852((class_2561)class_2561.method_43470((String)String.format("Line %d, chars: %d, inWrappedLine: %b\nText: ", objectArray)).method_10862(class_2583.field_24360.method_27704(JB_MONO)));
            b.method_27693(lineString);
            StringBuilder ib = new StringBuilder();
            ib.append("\nUTF16: ");
            for (int i = 0; i < len; ++i) {
                ib.append("\\u");
                String s = Integer.toHexString(lineString.charAt(i));
                ib.append("0".repeat(4 - s.length()));
                ib.append(s);
            }
            ib.append('\n');
            b.method_10852((class_2561)class_2561.method_43470((String)ib.toString()).method_10862(class_2583.field_24360.method_27704(JB_MONO)));
        });
        String result = b.getString();
        source.sendFeedback(component);
        source.sendFeedback((class_2561)b);
        class_156.method_27958().execute(() -> ModernUI.LOGGER.info(TextLayoutEngine.MARKER, result));
    }
}

