/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.fabric;

import icyllis.modernui.ModernUI;
import icyllis.modernui.animation.LayoutTransition;
import icyllis.modernui.animation.ObjectAnimator;
import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.animation.ValueAnimator;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.core.Context;
import icyllis.modernui.core.Core;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.Color;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.text.FontFamily;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.fabric.Config;
import icyllis.modernui.mc.ui.FourColorPicker;
import icyllis.modernui.mc.ui.ThemeControl;
import icyllis.modernui.text.Editable;
import icyllis.modernui.text.InputFilter;
import icyllis.modernui.text.SpannableString;
import icyllis.modernui.text.Typeface;
import icyllis.modernui.text.method.DigitsInputFilter;
import icyllis.modernui.text.style.ForegroundColorSpan;
import icyllis.modernui.util.DataSet;
import icyllis.modernui.view.LayoutInflater;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.AdapterView;
import icyllis.modernui.widget.ArrayAdapter;
import icyllis.modernui.widget.Button;
import icyllis.modernui.widget.EditText;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.LinearLayout;
import icyllis.modernui.widget.LinearPagerIndicator;
import icyllis.modernui.widget.PagerAdapter;
import icyllis.modernui.widget.ScrollView;
import icyllis.modernui.widget.SeekBar;
import icyllis.modernui.widget.Spinner;
import icyllis.modernui.widget.SwitchButton;
import icyllis.modernui.widget.TextView;
import icyllis.modernui.widget.Toast;
import icyllis.modernui.widget.ViewPager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraftforge.common.ForgeConfigSpec;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class PreferencesFragment
extends Fragment {
    LinearLayout mTooltipCategory;
    LinearLayout mTextLayoutCategory;
    LinearLayout mTextRenderingCategory;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
        ViewPager pager = new ViewPager(this.getContext());
        pager.setAdapter(new ThePagerAdapter());
        pager.setFocusableInTouchMode(true);
        pager.setKeyboardNavigationCluster(true);
        pager.setEdgeEffectColor(-3300456);
        pager.setLeftEdgeEffectBlendMode(BlendMode.SRC_OVER);
        pager.setRightEdgeEffectBlendMode(BlendMode.SRC_OVER);
        LinearPagerIndicator indicator = new LinearPagerIndicator(this.getContext());
        indicator.setPager(pager);
        indicator.setLineWidth(pager.dp(4.0f));
        indicator.setLineColor(-3300456);
        ViewPager.LayoutParams lp = new ViewPager.LayoutParams();
        lp.height = pager.dp(30.0f);
        lp.isDecor = true;
        lp.gravity = 81;
        pager.addView((View)indicator, lp);
        FrameLayout.LayoutParams lp2 = new FrameLayout.LayoutParams(pager.dp(720.0f), -1);
        lp2.gravity = 17;
        pager.setLayoutParams(lp2);
        return pager;
    }

    public static LinearLayout createSecondPage(Context context) {
        LinearLayout content = new LinearLayout(context);
        content.setOrientation(1);
        LayoutTransition transition = new LayoutTransition();
        transition.enableTransitionType(4);
        content.setLayoutTransition(transition);
        LinearLayout category = PreferencesFragment.createCategoryList(context, "modernui.center.category.font");
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(1);
        int dp6 = layout.dp(6.0f);
        LinearLayout firstLine = new LinearLayout(context);
        firstLine.setOrientation(0);
        TextView title = new TextView(context);
        title.setText(class_1074.method_4662((String)"modernui.center.font.firstFont", (Object[])new Object[0]));
        title.setTextAlignment(5);
        title.setTextSize(14.0f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        firstLine.addView((View)title, params);
        TextView value = new TextView(context);
        Runnable onFontChanged = () -> {
            FontFamily first = ModernUIClient.getInstance().getFirstFontFamily();
            if (first != null) {
                value.setText(first.getFamilyName(value.getTextLocale()));
            } else {
                value.setText("NONE");
            }
        };
        onFontChanged.run();
        value.setTextAlignment(6);
        value.setTextSize(14.0f);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -2);
        firstLine.addView((View)value, params2);
        firstLine.setOnClickListener(new PreferredFontCollapsed(layout, onFontChanged));
        ThemeControl.addBackground(firstLine);
        layout.addView(firstLine);
        params = new LinearLayout.LayoutParams(-1, -2);
        params.gravity = 17;
        params.setMargins(dp6, layout.dp(3.0f), dp6, layout.dp(3.0f));
        category.addView((View)layout, params);
        LinearLayout option = PreferencesFragment.createStringListOption(context, "modernui.center.font.fallbackFonts", Config.CLIENT.mFallbackFontFamilyList, () -> {
            Config.CLIENT.saveAndReloadAsync();
            PreferencesFragment.reloadDefaultTypeface(context, () -> {});
        });
        category.addView(option);
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.font.colorEmoji", Config.CLIENT.mUseColorEmoji, () -> {
            Config.CLIENT.saveAndReloadAsync();
            PreferencesFragment.reloadDefaultTypeface(context, () -> {});
        }));
        category.addView(PreferencesFragment.createStringListOption(context, "modernui.center.font.fontRegistrationList", Config.CLIENT.mFontRegistrationList, () -> {
            Config.CLIENT.saveAsync();
            Toast.makeText(context, class_1074.method_4662((String)"gui.modernui.restart_to_work", (Object[])new Object[0]), 0).show();
        }));
        content.addView(category);
        LinearLayout list = PreferencesFragment.createCategoryList(context, "modernui.center.category.system");
        list.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.system.forceRtlLayout", Config.CLIENT.mForceRtl, Config.CLIENT::saveAndReloadAsync));
        list.addView(PreferencesFragment.createFloatOption(context, "modernui.center.system.globalFontScale", 0.5f, 2.0f, 4, Config.CLIENT.mFontScale, 10.0f, Config.CLIENT::saveAndReloadAsync));
        option = PreferencesFragment.createInputBox(context, "modernui.center.system.globalAnimationScale");
        EditText input = (EditText)option.requireViewById(16908297);
        input.setText(Float.toString(ValueAnimator.sDurationScale));
        input.setFilters(DigitsInputFilter.getInstance(null, false, true), new InputFilter.LengthFilter(4));
        input.setOnFocusChangeListener((view, hasFocus) -> {
            if (!hasFocus) {
                EditText v = (EditText)view;
                double scale = Math.max(Math.min(Double.parseDouble(v.getText().toString()), 10.0), 0.1);
                v.setText(Double.toString(scale));
                if (scale != (double)ValueAnimator.sDurationScale) {
                    ValueAnimator.sDurationScale = (float)scale;
                }
            }
        });
        list.addView(option);
        list.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.system.developerMode", Config.COMMON.developerMode, Config.COMMON::saveAndReloadAsync));
        content.addView(list);
        content.setDividerDrawable(ThemeControl.makeDivider(content));
        content.setDividerPadding(content.dp(8.0f));
        content.setShowDividers(2);
        return content;
    }

    public LinearLayout createFirstPage(Context context) {
        LinearLayout content = new LinearLayout(context);
        content.setOrientation(1);
        LayoutTransition transition = new LayoutTransition();
        transition.enableTransitionType(4);
        content.setLayoutTransition(transition);
        Runnable saveFn = Config.CLIENT::saveAndReloadAsync;
        LinearLayout list = PreferencesFragment.createCategoryList(context, "modernui.center.category.screen");
        list.addView(PreferencesFragment.createGuiScaleOption(context));
        list.addView(PreferencesFragment.createColorOpacityOption(context, "modernui.center.screen.backgroundOpacity", Config.CLIENT.mBackgroundColor, saveFn));
        list.addView(PreferencesFragment.createIntegerOption(context, "modernui.center.screen.backgroundDuration", 0, 800, 3, 50, Config.CLIENT.mBackgroundDuration, saveFn));
        list.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.screen.blurEffect", Config.CLIENT.mBlurEffect, saveFn));
        list.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.screen.blurWithBackground", Config.CLIENT.mBlurWithBackground, saveFn));
        list.addView(PreferencesFragment.createIntegerOption(context, "modernui.center.screen.blurRadius", 0, 18, 2, 1, Config.CLIENT.mBlurRadius, saveFn));
        list.addView(PreferencesFragment.createSpinnerOption((Context)context, (String)"modernui.center.screen.windowMode", (Enum[])Config.Client.WindowMode.values(), Config.CLIENT.mWindowMode, (Runnable)saveFn));
        list.addView(PreferencesFragment.createIntegerOption(context, "modernui.center.screen.framerateInactive", 0, 255, 3, 5, Config.CLIENT.mFramerateInactive, saveFn));
        list.addView(PreferencesFragment.createIntegerOption(context, "modernui.center.screen.framerateMinimized", 0, 255, 3, 5, Config.CLIENT.mFramerateMinimized, saveFn));
        list.addView(PreferencesFragment.createFloatOption(context, "modernui.center.screen.masterVolumeInactive", 0.0f, 1.0f, 4, Config.CLIENT.mMasterVolumeInactive, 100.0f, saveFn));
        list.addView(PreferencesFragment.createFloatOption(context, "modernui.center.screen.masterVolumeMinimized", 0.0f, 1.0f, 4, Config.CLIENT.mMasterVolumeMinimized, 100.0f, saveFn));
        list.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.screen.inventoryPause", Config.CLIENT.mInventoryPause, saveFn));
        content.addView(list);
        boolean rawTextEngineEnabled = !Boolean.parseBoolean(ModernUIClient.getBootstrapProperty("modernui_mc_disableTextEngine"));
        LinearLayout list2 = PreferencesFragment.createCategoryList(context, "modernui.center.category.extension");
        list2.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.extension.ding", Config.CLIENT.mDing, saveFn));
        list2.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.emojiShortcodes", Config.CLIENT.mEmojiShortcodes, Config.CLIENT::saveAndReloadAsync));
        LinearLayout option = PreferencesFragment.createSwitchLayout(context, "modernui.center.extension.smoothScrolling");
        SwitchButton button = (SwitchButton)option.requireViewById(16908313);
        button.setChecked(!Boolean.parseBoolean(ModernUIClient.getBootstrapProperty("modernui_mc_disableSmoothScrolling")));
        button.setOnCheckedChangeListener((__, checked) -> {
            ModernUIClient.setBootstrapProperty("modernui_mc_disableSmoothScrolling", Boolean.toString(!checked));
            Toast.makeText(__.getContext(), class_1074.method_4662((String)"gui.modernui.restart_to_work", (Object[])new Object[0]), 0).show();
        });
        list2.addView(option);
        option = PreferencesFragment.createSwitchLayout(context, "modernui.center.text.enhancedTextField");
        button = (SwitchButton)option.requireViewById(16908313);
        button.setChecked(!Boolean.parseBoolean(ModernUIClient.getBootstrapProperty("modernui_mc_disableEnhancedTextField")));
        button.setOnCheckedChangeListener((__, checked) -> {
            ModernUIClient.setBootstrapProperty("modernui_mc_disableEnhancedTextField", Boolean.toString(!checked));
            Toast.makeText(__.getContext(), class_1074.method_4662((String)"gui.modernui.restart_to_work", (Object[])new Object[0]), 0).show();
        });
        list2.addView(option);
        option = PreferencesFragment.createSwitchLayout(context, "modernui.center.extension.tooltip");
        button = (SwitchButton)option.requireViewById(16908313);
        button.setChecked((Boolean)Config.CLIENT.mTooltip.get());
        button.setOnCheckedChangeListener((view, checked) -> {
            Config.CLIENT.mTooltip.set((Object)checked);
            saveFn.run();
            if (checked) {
                if (this.mTooltipCategory == null) {
                    this.mTooltipCategory = PreferencesFragment.createTooltipCategory(view.getContext());
                    content.addView((View)this.mTooltipCategory, 2);
                } else {
                    this.mTooltipCategory.setVisibility(0);
                }
            } else if (this.mTooltipCategory != null) {
                this.mTooltipCategory.setVisibility(8);
            }
        });
        list2.addView(option);
        option = PreferencesFragment.createSwitchLayout(context, "modernui.center.text.textEngine");
        button = (SwitchButton)option.requireViewById(16908313);
        button.setChecked(rawTextEngineEnabled);
        button.setOnCheckedChangeListener((view, checked) -> {
            ModernUIClient.setBootstrapProperty("modernui_mc_disableTextEngine", Boolean.toString(!checked));
            Toast.makeText(view.getContext(), class_1074.method_4662((String)"gui.modernui.restart_to_work", (Object[])new Object[0]), 0).show();
            if (checked) {
                if (this.mTextLayoutCategory == null) {
                    this.mTextLayoutCategory = PreferencesFragment.createTextLayoutCategory(view.getContext());
                    this.mTextRenderingCategory = PreferencesFragment.createTextRenderingCategory(view.getContext());
                    content.addView(this.mTextLayoutCategory);
                    content.addView(this.mTextRenderingCategory);
                } else {
                    this.mTextLayoutCategory.setVisibility(0);
                    this.mTextRenderingCategory.setVisibility(0);
                }
            } else if (this.mTextLayoutCategory != null) {
                this.mTextLayoutCategory.setVisibility(8);
                this.mTextRenderingCategory.setVisibility(8);
            }
        });
        list2.addView(option);
        content.addView(list2);
        if (((Boolean)Config.CLIENT.mTooltip.get()).booleanValue()) {
            this.mTooltipCategory = PreferencesFragment.createTooltipCategory(context);
            content.addView(this.mTooltipCategory);
        }
        if (rawTextEngineEnabled) {
            this.mTextLayoutCategory = PreferencesFragment.createTextLayoutCategory(context);
            content.addView(this.mTextLayoutCategory);
            this.mTextRenderingCategory = PreferencesFragment.createTextRenderingCategory(context);
            content.addView(this.mTextRenderingCategory);
        }
        content.setDividerDrawable(ThemeControl.makeDivider(content));
        content.setDividerPadding(content.dp(8.0f));
        content.setShowDividers(2);
        return content;
    }

    public static LinearLayout createTooltipCategory(Context context) {
        LinearLayout category = PreferencesFragment.createCategoryList(context, "modernui.center.category.tooltip");
        Runnable saveFn = Config.CLIENT::saveAndReloadAsync;
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.tooltip.centerTitle", Config.CLIENT.mCenterTooltipTitle, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.tooltip.titleBreak", Config.CLIENT.mTooltipTitleBreak, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.tooltip.exactPositioning", Config.CLIENT.mExactTooltipPositioning, saveFn));
        category.addView(PreferencesFragment.createIntegerOption(context, "modernui.center.tooltip.arrowScrollFactor", 0, 320, 3, 1, Config.CLIENT.mTooltipArrowScrollFactor, saveFn));
        category.addView(PreferencesFragment.createColorOpacityOption(context, "modernui.center.tooltip.backgroundOpacity", Config.CLIENT.mTooltipFill, saveFn));
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(1);
        int dp3 = layout.dp(3.0f);
        int dp6 = layout.dp(6.0f);
        Button title = new Button(context);
        title.setText(class_1074.method_4662((String)"modernui.center.tooltip.borderStyle", (Object[])new Object[0]));
        title.setTextAlignment(5);
        title.setTextSize(14.0f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        layout.addView((View)title, params);
        title.setOnClickListener(new TooltipBorderCollapsed(layout, saveFn));
        title.setPadding(dp3, 0, dp3, 0);
        ThemeControl.addBackground(title);
        params = new LinearLayout.LayoutParams(-1, -2);
        params.gravity = 17;
        params.setMargins(dp6, dp3, dp6, 0);
        category.addView((View)layout, params);
        return category;
    }

    public static LinearLayout createTextLayoutCategory(Context context) {
        LinearLayout category = PreferencesFragment.createCategoryList(context, "modernui.center.category.textLayout");
        Runnable saveFn = Config.TEXT::saveAndReloadAsync;
        category.addView(PreferencesFragment.createSpinnerOption((Context)context, (String)"modernui.center.text.defaultFontBehavior", (Enum[])Config.Text.DefaultFontBehavior.values(), Config.TEXT.mDefaultFontBehavior, (Runnable)saveFn));
        category.addView(PreferencesFragment.createStringListOption(context, "modernui.center.text.defaultFontRuleSet", Config.TEXT.mDefaultFontRuleSet, saveFn));
        category.addView(PreferencesFragment.createSpinnerOption((Context)context, (String)"modernui.center.text.bidiHeuristicAlgo", (Enum[])Config.Text.TextDirection.values(), Config.TEXT.mTextDirection, (Runnable)saveFn));
        category.addView(PreferencesFragment.createSpinnerOption((Context)context, (String)"modernui.center.text.lineBreakStyle", (Enum[])Config.Text.LineBreakStyle.values(), Config.TEXT.mLineBreakStyle, (Runnable)saveFn));
        category.addView(PreferencesFragment.createSpinnerOption((Context)context, (String)"modernui.center.text.lineBreakWordStyle", (Enum[])Config.Text.LineBreakWordStyle.values(), Config.TEXT.mLineBreakWordStyle, (Runnable)saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.allowAsyncLayout", Config.TEXT.mAllowAsyncLayout, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.useComponentCache", Config.TEXT.mUseComponentCache, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.fixedResolution", Config.TEXT.mFixedResolution, saveFn));
        category.addView(PreferencesFragment.createFloatOption(context, "modernui.center.text.baseFontSize", 6.5f, 9.5f, 5, Config.TEXT.mBaseFontSize, 10.0f, saveFn));
        category.addView(PreferencesFragment.createIntegerOption(context, "modernui.center.text.cacheLifespan", 2, 15, 2, 1, Config.TEXT.mCacheLifespan, saveFn));
        return category;
    }

    public static LinearLayout createTextRenderingCategory(Context context) {
        LinearLayout category = PreferencesFragment.createCategoryList(context, "modernui.center.category.textRendering");
        Runnable saveFn = Config.TEXT::saveAndReloadAsync;
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.font.antiAliasing", Config.TEXT.mAntiAliasing, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.font.linearMetrics", Config.TEXT.mLinearMetrics, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.textShadersInWorld", Config.TEXT.mUseTextShadersInWorld, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.allowSDFTextIn2D", Config.TEXT.mAllowSDFTextIn2D, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.smartSDFShaders", Config.TEXT.mSmartSDFShaders, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.computeDeviceFontSize", Config.TEXT.mComputeDeviceFontSize, saveFn));
        category.addView(PreferencesFragment.createIntegerOption(context, "modernui.center.text.minPixelDensityForSDF", 4, 10, 2, 1, Config.TEXT.mMinPixelDensityForSDF, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.font.linearSampling", Config.TEXT.mLinearSamplingA8Atlas, saveFn));
        category.addView(PreferencesFragment.createBooleanOption(context, "modernui.center.text.allowShadow", Config.TEXT.mAllowShadow, saveFn));
        category.addView(PreferencesFragment.createFloatOption(context, "modernui.center.text.shadowOffset", 0.2f, 2.0f, 5, Config.TEXT.mShadowOffset, 100.0f, saveFn));
        category.addView(PreferencesFragment.createFloatOption(context, "modernui.center.text.baselineShift", 4.0f, 10.0f, 5, Config.TEXT.mBaselineShift, 10.0f, saveFn));
        category.addView(PreferencesFragment.createFloatOption(context, "modernui.center.text.outlineOffset", 0.2f, 2.0f, 5, Config.TEXT.mOutlineOffset, 100.0f, saveFn));
        return category;
    }

    @NonNull
    public static LinearLayout createCategoryList(Context context, String name) {
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(1);
        int dp6 = layout.dp(6.0f);
        int dp12 = layout.dp(12.0f);
        int dp18 = layout.dp(18.0f);
        TextView title = new TextView(context);
        title.setId(16908310);
        title.setText(class_1074.method_4662((String)name, (Object[])new Object[0]));
        title.setTextSize(16.0f);
        title.setTextColor(-3300456);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 0x800003;
        params.setMargins(dp6, dp6, dp6, dp6);
        layout.addView((View)title, params);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-1, -2);
        params2.gravity = 17;
        params2.setMargins(dp12, dp12, dp12, dp18);
        layout.setLayoutParams(params2);
        return layout;
    }

    public static LinearLayout createSwitchLayout(Context context, String name) {
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(0);
        layout.setHorizontalGravity(0x800003);
        int dp3 = layout.dp(3.0f);
        int dp6 = layout.dp(6.0f);
        TextView title = new TextView(context);
        title.setText(class_1074.method_4662((String)name, (Object[])new Object[0]));
        title.setTextAlignment(5);
        title.setTextSize(14.0f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params.gravity = 16;
        layout.addView((View)title, params);
        SwitchButton button = new SwitchButton(context);
        button.setId(16908313);
        button.setCheckedColor(-3300456);
        params = new LinearLayout.LayoutParams(layout.dp(36.0f), layout.dp(16.0f));
        params.gravity = 16;
        params.setMargins(0, dp3, 0, dp3);
        layout.addView((View)button, params);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-1, -2);
        params2.gravity = 17;
        params2.setMargins(dp6, 0, dp6, 0);
        layout.setLayoutParams(params2);
        String tooltip = name + "_desc";
        if (class_1074.method_4663((String)tooltip)) {
            layout.setTooltipText(class_1074.method_4662((String)tooltip, (Object[])new Object[0]));
        }
        return layout;
    }

    public static LinearLayout createBooleanOption(Context context, String name, ForgeConfigSpec.BooleanValue config, Runnable saveFn) {
        LinearLayout layout = PreferencesFragment.createSwitchLayout(context, name);
        SwitchButton button = (SwitchButton)layout.requireViewById(16908313);
        button.setChecked((Boolean)config.get());
        button.setOnCheckedChangeListener((__, checked) -> {
            config.set((Object)checked);
            saveFn.run();
        });
        return layout;
    }

    public static <E extends Enum<E>> LinearLayout createSpinnerOption(Context context, String name, E[] values, ForgeConfigSpec.EnumValue<E> config, Runnable saveFn) {
        LinearLayout option = new LinearLayout(context);
        option.setOrientation(0);
        option.setHorizontalGravity(0x800003);
        int dp6 = option.dp(6.0f);
        TextView title = new TextView(context);
        title.setText(class_1074.method_4662((String)name, (Object[])new Object[0]));
        title.setTextAlignment(5);
        title.setTextSize(14.0f);
        String tooltip = name + "_desc";
        if (class_1074.method_4663((String)tooltip)) {
            title.setTooltipText(class_1074.method_4662((String)tooltip, (Object[])new Object[0]));
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params.gravity = 16;
        option.addView((View)title, params);
        Spinner spinner = new Spinner(context);
        spinner.setGravity(0x800005);
        spinner.setAdapter(new ArrayAdapter<E>(context, values));
        spinner.setSelection(((Enum)config.get()).ordinal());
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){
            final /* synthetic */ Enum[] val$values;
            final /* synthetic */ ForgeConfigSpec.EnumValue val$config;
            final /* synthetic */ Runnable val$saveFn;
            {
                this.val$values = enumArray;
                this.val$config = enumValue;
                this.val$saveFn = runnable;
            }

            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                Enum newValue = this.val$values[position];
                if (this.val$config.get() != newValue) {
                    this.val$config.set((Object)newValue);
                    this.val$saveFn.run();
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -2);
        params2.gravity = 16;
        option.addView((View)spinner, params2);
        LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams(-1, -2);
        params3.gravity = 17;
        params3.setMargins(dp6, 0, dp6, 0);
        option.setLayoutParams(params3);
        return option;
    }

    private static LinearLayout createGuiScaleOption(Context context) {
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(0);
        layout.setHorizontalGravity(0x800003);
        int dp3 = layout.dp(3.0f);
        int dp6 = layout.dp(6.0f);
        TextView title = new TextView(context);
        title.setText(class_1074.method_4662((String)"options.guiScale", (Object[])new Object[0]));
        title.setTextAlignment(5);
        title.setTextSize(14.0f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params.gravity = 8388627;
        layout.addView((View)title, params);
        SeekBar slider = new SeekBar(context);
        slider.setClickable(true);
        params = new LinearLayout.LayoutParams(slider.dp(200.0f), -2);
        params.gravity = 16;
        layout.addView((View)slider, params);
        final TextView tv = new TextView(context);
        tv.setTextAlignment(6);
        tv.setTextSize(14.0f);
        tv.setPadding(dp3, 0, dp3, 0);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -2);
        params2.gravity = 16;
        layout.addView((View)tv, params2);
        int curValue = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        tv.setText(PreferencesFragment.guiScaleToString(curValue));
        tv.setMinWidth(slider.dp(50.0f));
        slider.setMax(8);
        slider.setProgress(curValue);
        slider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                int newValue = seekBar.getProgress();
                tv.setText(PreferencesFragment.guiScaleToString(newValue));
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int newValue = seekBar.getProgress();
                Core.executeOnMainThread(() -> {
                    class_310 minecraft = class_310.method_1551();
                    minecraft.field_1690.method_42474().method_41748((Object)newValue);
                    if ((int)minecraft.method_22683().method_4495() != minecraft.method_22683().method_4476(newValue, false)) {
                        minecraft.method_15993();
                    }
                    minecraft.field_1690.method_1640();
                });
                tv.setText(PreferencesFragment.guiScaleToString(newValue));
            }
        });
        LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams(-1, -2);
        params3.gravity = 17;
        params3.setMargins(dp6, 0, dp6, 0);
        layout.setLayoutParams(params3);
        return layout;
    }

    private static CharSequence guiScaleToString(int value) {
        int r = MuiModApi.calcGuiScales();
        if (value == 0) {
            int auto = r >> 4 & 0xF;
            return "A (" + auto + ")";
        }
        String valueString = Integer.toString(value);
        int min = r >> 8 & 0xF;
        int max = r & 0xF;
        if (value < min || value > max) {
            String hint = value < min ? " (" + min + ")" : " (" + max + ")";
            SpannableString spannableString = new SpannableString(valueString + hint);
            spannableString.setSpan(new ForegroundColorSpan(-43691), 0, spannableString.length(), 33);
            return spannableString;
        }
        return valueString;
    }

    @NonNull
    public static LinearLayout createInputBox(Context context, String name) {
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(0);
        layout.setHorizontalGravity(0x800003);
        int dp3 = layout.dp(3.0f);
        int dp6 = layout.dp(6.0f);
        TextView title = new TextView(context);
        title.setText(class_1074.method_4662((String)name, (Object[])new Object[0]));
        title.setTextAlignment(5);
        title.setTextSize(14.0f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params.gravity = 8388627;
        layout.addView((View)title, params);
        EditText input = new EditText(context);
        input.setId(16908297);
        input.setTextAlignment(6);
        input.setTextSize(14.0f);
        input.setPadding(dp3, 0, dp3, 0);
        ThemeControl.addBackground(input);
        params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 16;
        layout.addView((View)input, params);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-1, -2);
        params2.gravity = 17;
        params2.setMargins(dp6, 0, dp6, 0);
        layout.setLayoutParams(params2);
        String tooltip = name + "_desc";
        if (class_1074.method_4663((String)tooltip)) {
            layout.setTooltipText(class_1074.method_4662((String)tooltip, (Object[])new Object[0]));
        }
        return layout;
    }

    public static LinearLayout createInputBoxWithSlider(Context context, String name) {
        LinearLayout layout = PreferencesFragment.createInputBox(context, name);
        SeekBar slider = new SeekBar(context);
        slider.setId(16908314);
        slider.setClickable(true);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(slider.dp(200.0f), -2);
        params.gravity = 16;
        layout.addView((View)slider, 1, params);
        return layout;
    }

    public static LinearLayout createIntegerOption(Context context, String name, int minValue, int maxValue, int maxLength, int stepSize, ForgeConfigSpec.IntValue config, Runnable saveFn) {
        return PreferencesFragment.createIntegerOption(context, name, minValue, maxValue, maxLength, stepSize, (Supplier<Integer>)config, arg_0 -> ((ForgeConfigSpec.IntValue)config).set(arg_0), saveFn);
    }

    public static LinearLayout createIntegerOption(Context context, String name, final int minValue, int maxValue, int maxLength, final int stepSize, final Supplier<Integer> getter, final Consumer<Integer> setter, final Runnable saveFn) {
        LinearLayout layout = PreferencesFragment.createInputBoxWithSlider(context, name);
        SeekBar slider = (SeekBar)layout.requireViewById(16908314);
        final EditText input = (EditText)layout.requireViewById(16908297);
        input.setFilters(DigitsInputFilter.getInstance((Locale)null), new InputFilter.LengthFilter(maxLength));
        int curValue = getter.get();
        input.setText(Integer.toString(curValue));
        input.setOnFocusChangeListener((view, hasFocus) -> {
            if (!hasFocus) {
                EditText v = (EditText)view;
                int newValue = MathUtil.clamp(Integer.parseInt(v.getText().toString()), minValue, maxValue);
                PreferencesFragment.replaceText(v, Integer.toString(newValue));
                if (newValue != (Integer)getter.get()) {
                    setter.accept(newValue);
                    int curProgress = (newValue - minValue) / stepSize;
                    slider.setProgress(curProgress, true);
                    saveFn.run();
                }
            }
        });
        input.setMinWidth(slider.dp(50.0f));
        int steps = (maxValue - minValue) / stepSize;
        slider.setMax(steps);
        slider.setProgress((curValue - minValue) / stepSize);
        slider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                int newValue = seekBar.getProgress() * stepSize + minValue;
                PreferencesFragment.replaceText(input, Integer.toString(newValue));
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int newValue = seekBar.getProgress() * stepSize + minValue;
                if (newValue != (Integer)getter.get()) {
                    setter.accept(newValue);
                    PreferencesFragment.replaceText(input, Integer.toString(newValue));
                    saveFn.run();
                }
            }
        });
        return layout;
    }

    public static LinearLayout createColorOpacityOption(Context context, String name, ForgeConfigSpec.ConfigValue<List<? extends String>> config, Runnable saveFn) {
        Supplier<Double> getter = () -> {
            List colors = (List)config.get();
            if (colors != null && !colors.isEmpty()) {
                try {
                    int color = Color.parseColor((String)colors.get(0));
                    return (float)(color >>> 24) / 255.0f;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return 1.0;
        };
        Consumer<Double> setter = d -> {
            int alpha = (int)(d.floatValue() * 255.0f + 0.5f);
            ArrayList<String> newList = new ArrayList<String>((Collection)config.get());
            if (newList.isEmpty()) {
                newList.add("#FF000000");
            }
            ListIterator<String> it = newList.listIterator();
            while (it.hasNext()) {
                int color = Color.parseColor((String)it.next());
                color = color & 0xFFFFFF | alpha << 24;
                it.set(String.format(Locale.ROOT, "#%08X", color));
            }
            config.set(newList);
        };
        return PreferencesFragment.createFloatOption(context, name, 0.0f, 1.0f, 4, getter, setter, 100.0f, saveFn);
    }

    public static LinearLayout createFloatOption(Context context, String name, float minValue, float maxValue, int maxLength, ForgeConfigSpec.DoubleValue config, float denominator, Runnable saveFn) {
        return PreferencesFragment.createFloatOption(context, name, minValue, maxValue, maxLength, (Supplier<Double>)config, arg_0 -> ((ForgeConfigSpec.DoubleValue)config).set(arg_0), denominator, saveFn);
    }

    private static String floatValueToString(float value, float denominator) {
        return Float.toString((float)Math.round(value * denominator) / denominator);
    }

    public static LinearLayout createFloatOption(Context context, String name, final float minValue, float maxValue, int maxLength, final Supplier<Double> getter, final Consumer<Double> setter, final float denominator, final Runnable saveFn) {
        LinearLayout layout = PreferencesFragment.createInputBoxWithSlider(context, name);
        SeekBar slider = (SeekBar)layout.requireViewById(16908314);
        final EditText input = (EditText)layout.requireViewById(16908297);
        input.setFilters(DigitsInputFilter.getInstance(null, minValue < 0.0f, true), new InputFilter.LengthFilter(maxLength));
        float curValue = getter.get().floatValue();
        input.setText(PreferencesFragment.floatValueToString(curValue, denominator));
        input.setOnFocusChangeListener((view, hasFocus) -> {
            if (!hasFocus) {
                EditText v = (EditText)view;
                float newValue = MathUtil.clamp(Float.parseFloat(v.getText().toString()), minValue, maxValue);
                PreferencesFragment.replaceText(v, PreferencesFragment.floatValueToString(newValue, denominator));
                if (newValue != ((Double)getter.get()).floatValue()) {
                    setter.accept(Double.valueOf(newValue));
                    int curProgress = Math.round((newValue - minValue) * denominator);
                    slider.setProgress(curProgress, true);
                    saveFn.run();
                }
            }
        });
        input.setMinWidth(slider.dp(50.0f));
        int steps = Math.round((maxValue - minValue) * denominator);
        slider.setMax(steps);
        int curProgress = Math.round((curValue - minValue) * denominator);
        slider.setProgress(curProgress);
        slider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                float newValue = (float)seekBar.getProgress() / denominator + minValue;
                PreferencesFragment.replaceText(input, PreferencesFragment.floatValueToString(newValue, denominator));
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                float newValue = (float)seekBar.getProgress() / denominator + minValue;
                if (newValue != ((Double)getter.get()).floatValue()) {
                    setter.accept(Double.valueOf(newValue));
                    PreferencesFragment.replaceText(input, PreferencesFragment.floatValueToString(newValue, denominator));
                    saveFn.run();
                }
            }
        });
        return layout;
    }

    public static LinearLayout createStringListOption(Context context, String name, ForgeConfigSpec.ConfigValue<List<? extends String>> config, Runnable saveFn) {
        LinearLayout option = new LinearLayout(context);
        option.setOrientation(0);
        option.setHorizontalGravity(0x800003);
        int dp3 = option.dp(3.0f);
        TextView title = new TextView(context);
        title.setText(class_1074.method_4662((String)name, (Object[])new Object[0]));
        title.setTextAlignment(5);
        title.setTextSize(14.0f);
        title.setMinWidth(option.dp(60.0f));
        String tooltip = name + "_desc";
        if (class_1074.method_4663((String)tooltip)) {
            title.setTooltipText(class_1074.method_4662((String)tooltip, (Object[])new Object[0]));
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -2, 2.0f);
        params.gravity = 8388627;
        option.addView((View)title, params);
        EditText input = new EditText(context);
        input.setId(16908297);
        input.setTextAlignment(6);
        input.setTextSize(14.0f);
        input.setPadding(dp3, 0, dp3, 0);
        input.setText(String.join((CharSequence)"\n", (Iterable)config.get()));
        input.setOnFocusChangeListener((view, hasFocus) -> {
            if (!hasFocus) {
                EditText v = (EditText)view;
                ArrayList<String> result = new ArrayList<String>();
                for (String s : v.getText().toString().split("\n")) {
                    String strip;
                    if (s.isBlank() || (strip = s.strip()).isEmpty() || result.contains(strip)) continue;
                    result.add(strip);
                }
                PreferencesFragment.replaceText(v, String.join((CharSequence)"\n", result));
                if (!Objects.equals(config.get(), result)) {
                    config.set(result);
                    saveFn.run();
                }
            }
        });
        ThemeControl.addBackground(input);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(0, -2, 5.0f);
        params2.gravity = 16;
        option.addView((View)input, params2);
        LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams(-1, -2);
        params3.gravity = 17;
        params3.setMargins(option.dp(6.0f), dp3, option.dp(6.0f), dp3);
        option.setLayoutParams(params3);
        return option;
    }

    private static void replaceText(@NonNull EditText editText, @NonNull CharSequence newText) {
        Editable text = editText.getText();
        text.replace(0, text.length(), newText);
    }

    private static void reloadDefaultTypeface(@NonNull Context context, @NonNull Runnable onFontChanged) {
        CompletableFuture future = class_310.method_1551().method_5385(() -> {
            Typeface oldTypeface = ModernUI.getSelectedTypeface();
            ModernUIClient client = ModernUIClient.getInstance();
            client.reloadTypeface();
            client.reloadFontStrike();
            return oldTypeface;
        });
        future.whenCompleteAsync((oldTypeface, throwable) -> {
            if (throwable == null) {
                onFontChanged.run();
                PreferencesFragment.refreshViewTypeface(UIManager.getInstance().getDecorView(), oldTypeface);
                Toast.makeText(context, class_1074.method_4662((String)"gui.modernui.font_reloaded", (Object[])new Object[0]), 0).show();
            }
        }, Core.getUiThreadExecutor());
    }

    private static void refreshViewTypeface(@NonNull ViewGroup vg, Typeface oldTypeface) {
        int cc = vg.getChildCount();
        for (int i = 0; i < cc; ++i) {
            TextView tv;
            View v = vg.getChildAt(i);
            if (v instanceof ViewGroup) {
                PreferencesFragment.refreshViewTypeface((ViewGroup)v, oldTypeface);
                continue;
            }
            if (!(v instanceof TextView) || (tv = (TextView)v).getTypeface() != oldTypeface) continue;
            tv.setTypeface(ModernUI.getSelectedTypeface());
        }
    }

    private class ThePagerAdapter
    extends PagerAdapter {
        private ThePagerAdapter() {
        }

        @Override
        public int getCount() {
            return 2;
        }

        @Override
        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            Context context = container.getContext();
            ScrollView sv = new ScrollView(context);
            if (position == 1) {
                sv.addView((View)PreferencesFragment.createSecondPage(context), -1, -2);
            } else {
                sv.addView((View)PreferencesFragment.this.createFirstPage(context), -1, -2);
                final ObjectAnimator animator = ObjectAnimator.ofFloat(sv, View.ROTATION_Y, container.isLayoutRtl() ? -45.0f : 45.0f, 0.0f);
                animator.setInterpolator(TimeInterpolator.DECELERATE);
                sv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                    @Override
                    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        animator.start();
                        v.removeOnLayoutChangeListener(this);
                    }
                });
            }
            sv.setEdgeEffectColor(-3300456);
            sv.setTopEdgeEffectBlendMode(BlendMode.SRC_OVER);
            sv.setBottomEdgeEffectBlendMode(BlendMode.SRC_OVER);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1, 1.0f);
            int dp6 = sv.dp(6.0f);
            params.setMargins(dp6, dp6, dp6, dp6);
            container.addView((View)sv, params);
            return sv;
        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }

        @Override
        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }
    }

    public static class PreferredFontCollapsed
    implements View.OnClickListener {
        final ViewGroup mParent;
        final Runnable mOnFontChanged;
        LinearLayout mContent;
        EditText mInput;
        Spinner mSpinner;

        public PreferredFontCollapsed(ViewGroup parent, Runnable onFontChanged) {
            this.mParent = parent;
            this.mOnFontChanged = onFontChanged;
        }

        @Override
        public void onClick(View v) {
            if (this.mContent != null) {
                this.mContent.setVisibility(this.mContent.getVisibility() == 8 ? 0 : 8);
                return;
            }
            this.mContent = new LinearLayout(this.mParent.getContext());
            this.mContent.setOrientation(1);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            params.setMargins(0, this.mContent.dp(6.0f), 0, 0);
            LinearLayout layout = PreferencesFragment.createInputBox(this.mParent.getContext(), "gui.modernui.configValue");
            EditText input = this.mInput = (EditText)layout.requireViewById(16908297);
            input.setText((CharSequence)Config.CLIENT.mFirstFontFamily.get());
            input.setOnFocusChangeListener((view, hasFocus) -> {
                if (!hasFocus) {
                    EditText v1 = (EditText)view;
                    String newValue = v1.getText().toString().strip();
                    this.applyNewValue(v1.getContext(), newValue);
                }
            });
            this.mContent.addView(layout);
            Spinner spinner = this.mSpinner = new Spinner(this.mParent.getContext());
            CompletableFuture.supplyAsync(() -> {
                List values = FontFamily.getSystemFontMap().values().stream().map(family -> new FontFamilyItem(family.getFamilyName(), family.getFamilyName(ModernUI.getSelectedLocale()))).sorted().collect(Collectors.toList());
                String chooseFont = class_1074.method_4662((String)"modernui.center.font.chooseFont", (Object[])new Object[0]);
                values.add(0, new FontFamilyItem(chooseFont, chooseFont));
                return values;
            }).thenAcceptAsync(values -> {
                this.mSpinner.setAdapter(new FontFamilyAdapter(this.mParent.getContext(), (List<FontFamilyItem>)values));
                this.mSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){
                    final /* synthetic */ List val$values;
                    {
                        this.val$values = list;
                    }

                    @Override
                    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                        if (position == 0) {
                            return;
                        }
                        String newValue = ((FontFamilyItem)this.val$values.get((int)position)).rootName;
                        boolean changed = this.applyNewValue(view.getContext(), newValue);
                        if (changed) {
                            mInput.setText(newValue);
                        }
                    }

                    @Override
                    public void onNothingSelected(AdapterView<?> parent) {
                    }
                });
                FontFamily first = ModernUIClient.getInstance().getFirstFontFamily();
                if (first != null) {
                    for (int i = 1; i < values.size(); ++i) {
                        FontFamilyItem candidate = (FontFamilyItem)values.get(i);
                        if (!candidate.rootName.equalsIgnoreCase(first.getFamilyName())) continue;
                        this.mSpinner.setSelection(i);
                        break;
                    }
                }
            }, Core.getUiThreadExecutor());
            this.mContent.addView((View)spinner, new LinearLayout.LayoutParams(params));
            Button openFile = new Button(this.mParent.getContext());
            openFile.setText(class_1074.method_4662((String)"modernui.center.font.openFontFile", (Object[])new Object[0]));
            openFile.setTextSize(14.0f);
            openFile.setOnClickListener(v1 -> CompletableFuture.runAsync(() -> {
                String path;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    PointerBuffer filters = stack.mallocPointer(4);
                    stack.nUTF8((CharSequence)"*.ttf", true);
                    filters.put(stack.getPointerAddress());
                    stack.nUTF8((CharSequence)"*.otf", true);
                    filters.put(stack.getPointerAddress());
                    stack.nUTF8((CharSequence)"*.ttc", true);
                    filters.put(stack.getPointerAddress());
                    stack.nUTF8((CharSequence)"*.otc", true);
                    filters.put(stack.getPointerAddress());
                    filters.rewind();
                    path = TinyFileDialogs.tinyfd_openFileDialog(null, null, (PointerBuffer)filters, (CharSequence)"TrueType/OpenType Fonts (*.ttf;*.otf;*.ttc;*.otc)", (boolean)false);
                }
                if (path != null) {
                    v1.post(() -> {
                        boolean changed = this.applyNewValue(v1.getContext(), path);
                        if (changed) {
                            this.mInput.setText(path);
                        }
                        this.mSpinner.setSelection(0);
                    });
                }
            }));
            this.mContent.addView((View)openFile, new LinearLayout.LayoutParams(params));
            this.mParent.addView((View)this.mContent, params);
        }

        private boolean applyNewValue(Context context, @NonNull String newValue) {
            if (!newValue.equals(Config.CLIENT.mFirstFontFamily.get())) {
                Config.CLIENT.mFirstFontFamily.set((Object)newValue);
                Config.CLIENT.saveAndReloadAsync();
                PreferencesFragment.reloadDefaultTypeface(context, this.mOnFontChanged);
                return true;
            }
            return false;
        }

        private static class FontFamilyAdapter
        extends ArrayAdapter<FontFamilyItem> {
            private final Context mContext;

            public FontFamilyAdapter(Context context, @NonNull List<FontFamilyItem> objects) {
                super(context, objects);
                this.mContext = context;
            }

            @Override
            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                TextView tv = convertView == null ? new TextView(this.mContext) : (TextView)convertView;
                FontFamilyItem item = (FontFamilyItem)this.getItem(position);
                tv.setText(item.localeName);
                tv.setTextSize(14.0f);
                tv.setTextAlignment(4);
                int dp4 = tv.dp(4.0f);
                tv.setPadding(dp4, dp4, dp4, dp4);
                return tv;
            }

            @Override
            @NonNull
            public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                return this.getView(position, convertView, parent);
            }
        }

        public record FontFamilyItem(String rootName, String localeName) implements Comparable<FontFamilyItem>
        {
            @Override
            public String toString() {
                return this.localeName;
            }

            @Override
            public int compareTo(@NonNull FontFamilyItem o) {
                return this.localeName.compareTo(o.localeName);
            }
        }
    }

    public static class TooltipBorderCollapsed
    implements View.OnClickListener {
        public static final String[][] PRESET_COLORS = new String[][]{{"#F0AADCF0", "#F0FFC3F7", "#F0BFF2B2", "#F0D27F3D"}, {"#F0AADCF0", "#F0DAD0F4", "#F0FFC3F7", "#F0DAD0F4"}, {"#F028007F", "#F028007F", "#F014003F", "#F014003F"}, {"#F0E0E0E0", "#F0B0B0B0", "#F0FFFFFF", "#F0B0B0B0"}};
        final ViewGroup mParent;
        final Runnable mSaveFn;
        LinearLayout mContent;
        FourColorPicker mColorPicker;
        ViewGroup mBorderWidth;
        ViewGroup mCornerRadius;
        ViewGroup mShadowRadius;
        ViewGroup mShadowAlpha;

        public TooltipBorderCollapsed(ViewGroup parent, Runnable saveFn) {
            this.mParent = parent;
            this.mSaveFn = saveFn;
        }

        @Override
        public void onClick(View v) {
            if (this.mContent != null) {
                this.mContent.setVisibility(this.mContent.getVisibility() == 8 ? 0 : 8);
                return;
            }
            this.mContent = new LinearLayout(this.mParent.getContext());
            this.mContent.setOrientation(1);
            LinearLayout option = PreferencesFragment.createSwitchLayout(this.mParent.getContext(), "modernui.center.tooltip.roundedShapes");
            SwitchButton button = (SwitchButton)option.requireViewById(16908313);
            boolean rounded = (Boolean)Config.CLIENT.mRoundedTooltip.get();
            button.setChecked(rounded);
            button.setOnCheckedChangeListener((__, checked) -> {
                Config.CLIENT.mRoundedTooltip.set((Object)checked);
                int visibility = checked ? 0 : 8;
                this.mBorderWidth.setVisibility(visibility);
                this.mCornerRadius.setVisibility(visibility);
                this.mShadowRadius.setVisibility(visibility);
                this.mShadowAlpha.setVisibility(visibility);
                this.mSaveFn.run();
            });
            this.mContent.addView(option);
            option = PreferencesFragment.createFloatOption(this.mParent.getContext(), "modernui.center.tooltip.borderWidth", 0.5f, 2.5f, 4, (Supplier<Double>)Config.CLIENT.mTooltipWidth, thickness -> {
                Config.CLIENT.mTooltipWidth.set(thickness);
                if (this.mColorPicker != null) {
                    this.mColorPicker.setThicknessFactor(thickness.floatValue() / 3.0f);
                }
            }, 100.0f, this.mSaveFn);
            if (!rounded) {
                option.setVisibility(8);
            }
            this.mBorderWidth = option;
            this.mContent.addView(option);
            option = PreferencesFragment.createFloatOption(this.mParent.getContext(), "modernui.center.tooltip.cornerRadius", 0.0f, 8.0f, 3, Config.CLIENT.mTooltipRadius, 10.0f, this.mSaveFn);
            if (!rounded) {
                option.setVisibility(8);
            }
            this.mCornerRadius = option;
            this.mContent.addView(option);
            option = PreferencesFragment.createFloatOption(this.mParent.getContext(), "modernui.center.tooltip.shadowRadius", 0.0f, 32.0f, 4, Config.CLIENT.mTooltipShadowRadius, 10.0f, this.mSaveFn);
            if (!rounded) {
                option.setVisibility(8);
            }
            this.mShadowRadius = option;
            this.mContent.addView(option);
            option = PreferencesFragment.createFloatOption(this.mParent.getContext(), "modernui.center.tooltip.shadowOpacity", 0.0f, 1.0f, 4, Config.CLIENT.mTooltipShadowAlpha, 100.0f, this.mSaveFn);
            if (!rounded) {
                option.setVisibility(8);
            }
            this.mShadowAlpha = option;
            this.mContent.addView(option);
            this.mContent.addView(PreferencesFragment.createBooleanOption(this.mParent.getContext(), "modernui.center.tooltip.adaptiveColors", Config.CLIENT.mAdaptiveTooltipColors, this.mSaveFn));
            this.mContent.addView(PreferencesFragment.createIntegerOption(this.mParent.getContext(), "modernui.center.tooltip.borderCycle", 0, 5000, 4, 100, Config.CLIENT.mTooltipCycle, this.mSaveFn));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            params.setMargins(0, this.mContent.dp(6.0f), 0, 0);
            LinearLayout buttonGroup = new LinearLayout(this.mParent.getContext());
            buttonGroup.setOrientation(0);
            int i = 0;
            while (i < 4) {
                Button button2 = new Button(this.mParent.getContext());
                button2.setText(class_1074.method_4662((String)"gui.modernui.preset_s", (Object[])new Object[]{i + 1}));
                int idx = i++;
                button2.setOnClickListener(__ -> this.mColorPicker.setColors(PRESET_COLORS[idx]));
                LinearLayout.LayoutParams p = new LinearLayout.LayoutParams(-2, -2, 1.0f);
                buttonGroup.addView((View)button2, p);
            }
            this.mContent.addView((View)buttonGroup, new LinearLayout.LayoutParams(params));
            this.mColorPicker = new FourColorPicker(this.mParent.getContext(), (Supplier<List<? extends String>>)Config.CLIENT.mTooltipStroke, arg_0 -> Config.CLIENT.mTooltipStroke.set(arg_0), this.mSaveFn);
            this.mContent.addView((View)this.mColorPicker, new LinearLayout.LayoutParams(params));
            this.mParent.addView((View)this.mContent, params);
        }
    }
}

