/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.fabric;

import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.core.Clipboard;
import icyllis.modernui.core.Context;
import icyllis.modernui.core.Core;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.text.LayoutCache;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.fabric.Config;
import icyllis.modernui.mc.fabric.PreferencesFragment;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.text.InputFilter;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.text.Typeface;
import icyllis.modernui.text.method.DigitsInputFilter;
import icyllis.modernui.util.DataSet;
import icyllis.modernui.view.LayoutInflater;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.Button;
import icyllis.modernui.widget.EditText;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.LinearLayout;
import icyllis.modernui.widget.ScrollView;
import icyllis.modernui.widget.SwitchButton;
import icyllis.modernui.widget.TextView;
import icyllis.modernui.widget.Toast;
import java.io.PrintWriter;
import java.io.Writer;
import net.minecraft.class_310;
import org.apache.commons.io.output.StringBuilderWriter;

public class AdvancedOptionsFragment
extends Fragment {
    ViewGroup mContent;
    TextView mUIManagerDump;
    TextView mMainGPUResourceDump;
    TextView mUIGPUResourceDump;
    TextView mPSOStatsDump;
    TextView mGPUStatsDump;

    public static Button createDebugButton(Context context, String text) {
        Button button = new Button(context);
        button.setText(text);
        button.setTextSize(14.0f);
        button.setGravity(0x800003);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(button.dp(6.0f), 0, button.dp(6.0f), 0);
        button.setLayoutParams(params);
        return button;
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
        Context context = this.requireContext();
        ScrollView sv = new ScrollView(context);
        sv.addView((View)this.createPage(context), -1, -2);
        sv.setEdgeEffectColor(-3300456);
        sv.setTopEdgeEffectBlendMode(BlendMode.SRC_OVER);
        sv.setBottomEdgeEffectBlendMode(BlendMode.SRC_OVER);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(sv.dp(720.0f), -1, 17);
        int dp6 = sv.dp(6.0f);
        params.setMargins(dp6, dp6, dp6, dp6);
        sv.setLayoutParams(params);
        return sv;
    }

    LinearLayout createPage(Context context) {
        LinearLayout content = new LinearLayout(context);
        content.setOrientation(1);
        this.mContent = content;
        int dp6 = content.dp(6.0f);
        LinearLayout category = PreferencesFragment.createCategoryList(context, "Developer");
        if (ModernUIMod.isDeveloperMode()) {
            LinearLayout option = PreferencesFragment.createInputBox(context, "Gamma");
            EditText input = (EditText)option.requireViewById(16908297);
            input.setText(((Double)class_310.method_1551().field_1690.method_42473().method_41753()).toString());
            input.setFilters(DigitsInputFilter.getInstance(input.getTextLocale(), false, true), new InputFilter.LengthFilter(6));
            input.setOnFocusChangeListener((view, hasFocus) -> {
                if (!hasFocus) {
                    EditText v = (EditText)view;
                    double gamma = Double.parseDouble(v.getText().toString());
                    v.setText(Double.toString(gamma));
                    class_310.method_1551().field_1690.method_42473().method_41748((Object)gamma);
                }
            });
            category.addView(option);
            category.addView(PreferencesFragment.createBooleanOption(context, "Remove telemetry session", Config.CLIENT.mRemoveTelemetry, Config.CLIENT::saveAndReloadAsync));
        }
        LinearLayout layout = PreferencesFragment.createSwitchLayout(context, "Show Layout Bounds");
        SwitchButton button = (SwitchButton)layout.requireViewById(16908313);
        button.setChecked(UIManager.getInstance().isShowingLayoutBounds());
        button.setOnCheckedChangeListener((__, checked) -> UIManager.getInstance().setShowingLayoutBounds(checked));
        category.addView(layout);
        Button button2 = AdvancedOptionsFragment.createDebugButton(context, "Take UI screenshot (Y)");
        button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> UIManager.getInstance().takeScreenshot()));
        category.addView(button2);
        button2 = AdvancedOptionsFragment.createDebugButton(context, "Dump UI manager (P)");
        button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> UIManager.getInstance().dump()));
        category.addView(button2);
        if (ModernUIMod.isTextEngineEnabled()) {
            button2 = AdvancedOptionsFragment.createDebugButton(context, "Dump font atlases (G)");
            button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> GlyphManager.getInstance().debug()));
            category.addView(button2);
            button2 = AdvancedOptionsFragment.createDebugButton(context, "Dump bitmap fonts (V)");
            button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> TextLayoutEngine.getInstance().dumpBitmapFonts()));
            category.addView(button2);
            button2 = AdvancedOptionsFragment.createDebugButton(context, "Dump text layout cache");
            button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> TextLayoutEngine.getInstance().dumpLayoutCache()));
            category.addView(button2);
            button2 = AdvancedOptionsFragment.createDebugButton(context, "Reload glyph manager");
            button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> GlyphManager.getInstance().reload()));
            category.addView(button2);
            button2 = AdvancedOptionsFragment.createDebugButton(context, "Reload text layout (MC)");
            button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> TextLayoutEngine.getInstance().reload()));
            category.addView(button2);
            button2 = AdvancedOptionsFragment.createDebugButton(context, "Reload full text engine");
            button2.setOnClickListener(__ -> ModernUIClient.getInstance().reloadFontStrike());
            category.addView(button2);
        }
        button2 = AdvancedOptionsFragment.createDebugButton(context, "Reset layout cache");
        button2.setOnClickListener(__ -> Core.executeOnMainThread(LayoutCache::clear));
        category.addView(button2);
        button2 = AdvancedOptionsFragment.createDebugButton(context, "Purge GPU resources on immediate context");
        button2.setOnClickListener(__ -> Core.executeOnMainThread(() -> Core.requireImmediateContext().freeGpuResources()));
        category.addView(button2);
        button2 = AdvancedOptionsFragment.createDebugButton(context, "Purge GPU resources on UI recording context");
        button2.setOnClickListener(__ -> Core.requireUiRecordingContext().freeGpuResources());
        category.addView(button2);
        button2 = AdvancedOptionsFragment.createDebugButton(context, "GC (F)");
        button2.setOnClickListener(__ -> System.gc());
        category.addView(button2);
        button2 = AdvancedOptionsFragment.createDebugButton(context, "Copy this page to clipboard");
        button2.setOnClickListener(__ -> {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < content.getChildCount(); ++i) {
                View patt10023$temp = content.getChildAt(i);
                if (!(patt10023$temp instanceof TextView)) continue;
                TextView tv = (TextView)patt10023$temp;
                sb.append(tv.getText());
                sb.append('\n');
            }
            if (!sb.isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
            }
            Core.executeOnMainThread(() -> Clipboard.setText(sb));
            Toast.makeText(context, "Copied to clipboard", 0).show();
        });
        category.addView(button2);
        content.addView(category);
        Typeface monoFont = Typeface.getSystemFont("JetBrains Mono Medium");
        if (monoFont == Typeface.SANS_SERIF) {
            monoFont = null;
        }
        TextView tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        this.mUIManagerDump = tv;
        content.addView(tv);
        tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        tv.setText("Rendering pipeline: Arc3D Granite (OpenGL)");
        content.addView(tv);
        tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        tv.setText("Rectangle packing algorithm: Skyline (silhouette)");
        content.addView(tv);
        tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        this.mMainGPUResourceDump = tv;
        content.addView(tv);
        tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        this.mUIGPUResourceDump = tv;
        content.addView(tv);
        tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        this.mPSOStatsDump = tv;
        content.addView(tv);
        tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        this.mGPUStatsDump = tv;
        content.addView(tv);
        tv = new TextView(context);
        tv.setTextSize(12.0f);
        tv.setPadding(dp6, dp6, dp6, dp6);
        if (monoFont != null) {
            tv.setTypeface(monoFont);
        }
        GLCaps caps = (GLCaps)Core.requireUiRecordingContext().getCaps();
        StringBuilder sb = new StringBuilder("GL Capabilities:\n");
        caps.dump(sb, false);
        tv.setText(sb);
        content.addView(tv);
        this.refreshPage();
        return content;
    }

    void refreshPage() {
        if (this.mUIManagerDump != null) {
            Core.executeOnMainThread(() -> {
                StringBuilder builder = new StringBuilder();
                try (PrintWriter w = new PrintWriter((Writer)new StringBuilderWriter(builder));){
                    UIManager.getInstance().dump(w, false);
                }
                String s = builder.toString();
                this.mUIManagerDump.post(() -> this.mUIManagerDump.setText(s));
            });
        }
        if (this.mMainGPUResourceDump != null) {
            Core.executeOnMainThread(() -> {
                ImmediateContext content = Core.requireImmediateContext();
                String s = "GPU Resource Cache (Immediate Context):\n" + String.format("Current budgeted resource bytes: %s (%s bytes)", TextUtils.binaryCompact(content.getCurrentBudgetedBytes()), content.getCurrentBudgetedBytes()) + "\n" + String.format("Current purgeable resource bytes: %s (%s bytes)", TextUtils.binaryCompact(content.getCurrentPurgeableBytes()), content.getCurrentPurgeableBytes()) + "\n" + String.format("Max budgeted resource bytes: %s (%s bytes)", TextUtils.binaryCompact(content.getMaxBudgetedBytes()), content.getMaxBudgetedBytes());
                this.mMainGPUResourceDump.post(() -> this.mMainGPUResourceDump.setText(s));
            });
        }
        if (this.mUIGPUResourceDump != null) {
            RecordingContext content = Core.requireUiRecordingContext();
            String s = "GPU Resource Cache (UI Recording Context):\n" + String.format("Current budgeted resource bytes: %s (%s bytes)", TextUtils.binaryCompact(content.getCurrentBudgetedBytes()), content.getCurrentBudgetedBytes()) + "\n" + String.format("Current purgeable resource bytes: %s (%s bytes)", TextUtils.binaryCompact(content.getCurrentPurgeableBytes()), content.getCurrentPurgeableBytes()) + "\n" + String.format("Max budgeted resource bytes: %s (%s bytes)", TextUtils.binaryCompact(content.getMaxBudgetedBytes()), content.getMaxBudgetedBytes());
            this.mUIGPUResourceDump.setText(s);
        }
        if (this.mContent != null) {
            this.mContent.postDelayed(this::refreshPage, 5000L);
        }
    }
}

