/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.audio.FFT;
import icyllis.modernui.audio.Track;
import icyllis.modernui.audio.VorbisPullDecoder;
import icyllis.modernui.core.Core;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class MusicPlayer {
    private static volatile MusicPlayer sInstance;
    private Track mCurrentTrack;
    private FFT mFFT;
    private float mGain = 1.0f;
    private String mName;
    private Consumer<Track> mOnTrackLoadCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MusicPlayer getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<MusicPlayer> clazz = MusicPlayer.class;
        synchronized (MusicPlayer.class) {
            if (sInstance == null) {
                sInstance = new MusicPlayer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private MusicPlayer() {
    }

    public static String openDialogGet() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filters = stack.mallocPointer(1);
            stack.nUTF8((CharSequence)"*.ogg", true);
            filters.put(stack.getPointerAddress());
            filters.rewind();
            String string = TinyFileDialogs.tinyfd_openFileDialog(null, null, (PointerBuffer)filters, (CharSequence)"Ogg Vorbis (*.ogg)", (boolean)false);
            return string;
        }
    }

    public void clearTrack() {
        if (this.mCurrentTrack != null) {
            this.mCurrentTrack.close();
            this.mCurrentTrack = null;
        }
        this.mName = null;
    }

    public void replaceTrack(Path path) {
        this.clearTrack();
        CompletableFuture.supplyAsync(() -> {
            Track track;
            block8: {
                FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
                try {
                    ByteBuffer nativeEncodedData = Core.readIntoNativeBuffer(channel).flip();
                    VorbisPullDecoder decoder = new VorbisPullDecoder(nativeEncodedData);
                    track = new Track(decoder);
                    if (channel == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ModernUI.LOGGER.error("Failed to open Ogg Vorbis, {}", (Object)path, (Object)e);
                        return null;
                    }
                }
                channel.close();
            }
            return track;
        }).whenCompleteAsync((track, ex) -> {
            this.mCurrentTrack = track;
            if (track != null) {
                track.setGain(this.mGain);
                this.mName = path.getFileName().toString();
            }
            if (this.mOnTrackLoadCallback != null) {
                this.mOnTrackLoadCallback.accept((Track)track);
            }
        }, Core.getUiThreadExecutor());
    }

    public void setOnTrackLoadCallback(Consumer<Track> onTrackLoadCallback) {
        this.mOnTrackLoadCallback = onTrackLoadCallback;
    }

    @Nullable
    public String getTrackName() {
        return this.mName;
    }

    public boolean hasTrack() {
        return this.mCurrentTrack != null;
    }

    public float getTrackTime() {
        if (this.mCurrentTrack != null) {
            return this.mCurrentTrack.getTime();
        }
        return 0.0f;
    }

    public float getTrackLength() {
        if (this.mCurrentTrack != null) {
            return this.mCurrentTrack.getLength();
        }
        return 0.0f;
    }

    public void play() {
        if (this.mCurrentTrack != null) {
            this.mCurrentTrack.play();
        }
    }

    public void pause() {
        if (this.mCurrentTrack != null) {
            this.mCurrentTrack.pause();
        }
    }

    public boolean isPlaying() {
        if (this.mCurrentTrack != null) {
            return this.mCurrentTrack.isPlaying();
        }
        return false;
    }

    public boolean seek(float fraction) {
        if (this.mCurrentTrack != null) {
            return this.mCurrentTrack.seekToSeconds(fraction * this.mCurrentTrack.getLength());
        }
        return true;
    }

    public void setGain(float gain) {
        if (this.mGain != gain) {
            this.mGain = gain;
            if (this.mCurrentTrack != null) {
                this.mCurrentTrack.setGain(gain);
            }
        }
    }

    public float getGain() {
        return this.mGain;
    }

    public void setAnalyzerCallback(Consumer<FFT> setup, Consumer<FFT> callback) {
        if (this.mCurrentTrack == null) {
            return;
        }
        if (setup == null && callback == null) {
            this.mCurrentTrack.setAnalyzer(null, null);
        } else {
            if (this.mFFT == null || this.mFFT.getSampleRate() != this.mCurrentTrack.getSampleRate()) {
                this.mFFT = FFT.create(1024, this.mCurrentTrack.getSampleRate());
            }
            if (setup != null) {
                setup.accept(this.mFFT);
            }
            this.mCurrentTrack.setAnalyzer(this.mFFT, callback);
        }
    }
}

