/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.text;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.text.FontCollection;
import icyllis.modernui.graphics.text.FontPaint;
import icyllis.modernui.graphics.text.LayoutPiece;
import icyllis.modernui.util.Pools;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LayoutCache {
    public static final int MAX_PIECE_LENGTH = 128;
    public static final int COMPUTE_CLUSTER_ADVANCES = 1;
    public static final int COMPUTE_GLYPHS_PIXEL_BOUNDS = 2;
    private static final Pools.Pool<LookupKey> sLookupKeys = Pools.newSynchronizedPool(3);
    private static volatile Cache<Key, LayoutPiece> sCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public static LayoutPiece getOrCreate(@NonNull char[] buf, int contextStart, int contextLimit, int start, int limit, boolean isRtl, @NonNull FontPaint paint, int computeFlags) {
        LayoutPiece piece;
        LookupKey key;
        if (contextStart < 0) throw new IndexOutOfBoundsException();
        if (contextStart >= contextLimit) throw new IndexOutOfBoundsException();
        if (buf.length == 0) throw new IndexOutOfBoundsException();
        if (contextLimit > buf.length) throw new IndexOutOfBoundsException();
        if (start < contextStart) throw new IndexOutOfBoundsException();
        if (limit > contextLimit) {
            throw new IndexOutOfBoundsException();
        }
        if (limit - start > 128) {
            return new LayoutPiece(buf, contextStart, contextLimit, start, limit, isRtl, paint, null, computeFlags);
        }
        if (sCache == null) {
            Class<LayoutCache> clazz = LayoutCache.class;
            // MONITORENTER : icyllis.modernui.graphics.text.LayoutCache.class
            if (sCache == null) {
                sCache = Caffeine.newBuilder().maximumSize(5000L).build();
            }
            // MONITOREXIT : clazz
        }
        if ((key = sLookupKeys.acquire()) == null) {
            key = new LookupKey();
        }
        if ((piece = (LayoutPiece)sCache.getIfPresent((Object)key.update(buf, contextStart, contextLimit, start, limit, paint, isRtl))) == null) {
            Key k = key.copy();
            sLookupKeys.release(key);
            piece = new LayoutPiece(buf, contextStart, contextLimit, start, limit, isRtl, paint, null, computeFlags);
            sCache.put((Object)k, (Object)piece);
            return piece;
        }
        int currFlags = piece.mComputeFlags & computeFlags;
        if (currFlags != computeFlags) {
            Key k = key.copy();
            sLookupKeys.release(key);
            piece = new LayoutPiece(buf, contextStart, contextLimit, start, limit, isRtl, paint, piece, currFlags ^ computeFlags);
            sCache.put((Object)k, (Object)piece);
            return piece;
        }
        sLookupKeys.release(key);
        return piece;
    }

    public static int getSize() {
        if (sCache == null) {
            return 0;
        }
        return (int)Math.min(sCache.estimatedSize(), Integer.MAX_VALUE);
    }

    public static int getMemoryUsage() {
        if (sCache == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry entry : sCache.asMap().entrySet()) {
            size += ((Key)entry.getKey()).getMemoryUsage();
            size += ((LayoutPiece)entry.getValue()).getMemoryUsage();
            size += 40;
        }
        return size;
    }

    public static void clear() {
        if (sCache != null) {
            sCache.invalidateAll();
        }
    }

    private static class LookupKey
    extends Key {
        private int mContextStart;
        private int mContextLimit;

        @NonNull
        public Key update(@NonNull char[] text, int contextStart, int contextLimit, int start, int limit, @NonNull FontPaint paint, boolean dir) {
            this.mChars = text;
            this.mContextStart = contextStart;
            this.mContextLimit = contextLimit;
            this.mStart = start - contextStart;
            this.mLimit = limit - contextStart;
            this.mFont = paint.mFont;
            this.mFlags = paint.mFlags;
            this.mSize = paint.getFontSize();
            this.mLocale = paint.mLocale;
            this.mIsRtl = dir;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.getClass() != Key.class) {
                throw new IllegalStateException();
            }
            Key key = (Key)o;
            if (this.mStart != key.mStart) {
                return false;
            }
            if (this.mLimit != key.mLimit) {
                return false;
            }
            if (this.mFlags != key.mFlags) {
                return false;
            }
            if (this.mSize != key.mSize) {
                return false;
            }
            if (this.mIsRtl != key.mIsRtl) {
                return false;
            }
            if (!Arrays.equals(this.mChars, this.mContextStart, this.mContextLimit, key.mChars, 0, key.mChars.length)) {
                return false;
            }
            if (!this.mFont.equals(key.mFont)) {
                return false;
            }
            return this.mLocale.equals(key.mLocale);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i = this.mContextStart; i < this.mContextLimit; ++i) {
                result = 31 * result + this.mChars[i];
            }
            result = 31 * result + this.mFont.hashCode();
            result = 31 * result + this.mFlags;
            result = 31 * result + Float.floatToIntBits(this.mSize);
            result = 31 * result + this.mStart;
            result = 31 * result + this.mLimit;
            result = 31 * result + this.mLocale.hashCode();
            result = 31 * result + (this.mIsRtl ? 1 : 0);
            return result;
        }

        @NonNull
        public Key copy() {
            return new Key(this);
        }
    }

    private static class Key {
        char[] mChars;
        int mStart;
        int mLimit;
        FontCollection mFont;
        int mFlags;
        float mSize;
        Locale mLocale;
        boolean mIsRtl;

        private Key() {
        }

        private Key(@NonNull LookupKey key) {
            this.mChars = new char[key.mContextLimit - key.mContextStart];
            System.arraycopy(key.mChars, key.mContextStart, this.mChars, 0, this.mChars.length);
            this.mStart = key.mStart;
            this.mLimit = key.mLimit;
            this.mFont = key.mFont;
            this.mFlags = key.mFlags;
            this.mSize = key.mSize;
            this.mLocale = key.mLocale;
            this.mIsRtl = key.mIsRtl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.getClass() != Key.class) {
                throw new IllegalStateException();
            }
            Key key = (Key)o;
            if (this.mStart != key.mStart) {
                return false;
            }
            if (this.mLimit != key.mLimit) {
                return false;
            }
            if (this.mFlags != key.mFlags) {
                return false;
            }
            if (this.mSize != key.mSize) {
                return false;
            }
            if (this.mIsRtl != key.mIsRtl) {
                return false;
            }
            if (!Arrays.equals(this.mChars, key.mChars)) {
                return false;
            }
            if (!this.mFont.equals(key.mFont)) {
                return false;
            }
            return this.mLocale.equals(key.mLocale);
        }

        public int hashCode() {
            int result = 1;
            for (char c : this.mChars) {
                result = 31 * result + c;
            }
            result = 31 * result + this.mFont.hashCode();
            result = 31 * result + this.mFlags;
            result = 31 * result + Float.floatToIntBits(this.mSize);
            result = 31 * result + this.mStart;
            result = 31 * result + this.mLimit;
            result = 31 * result + this.mLocale.hashCode();
            result = 31 * result + (this.mIsRtl ? 1 : 0);
            return result;
        }

        private int getMemoryUsage() {
            return MathUtil.align8(61 + (this.mChars.length << 1));
        }
    }
}

