/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.BidirectionalTypeConverter;
import icyllis.modernui.animation.Keyframe;
import icyllis.modernui.animation.KeyframeSet;
import icyllis.modernui.animation.Keyframes;
import icyllis.modernui.animation.TypeConverter;
import icyllis.modernui.animation.TypeEvaluator;
import icyllis.modernui.util.FloatProperty;
import icyllis.modernui.util.IntProperty;
import icyllis.modernui.util.Property;
import javax.annotation.Nonnull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class PropertyValuesHolder
implements Cloneable {
    Property mProperty;
    Keyframes mKeyframes;
    private Object mAnimatedValue;
    private TypeEvaluator mEvaluator;
    private TypeConverter mConverter;

    private PropertyValuesHolder() {
    }

    private PropertyValuesHolder(Property<?, ?> property) {
        this.mProperty = property;
    }

    @Nonnull
    public static PropertyValuesHolder ofInt(int ... values) {
        return new IntPropertyValuesHolder(values);
    }

    @Nonnull
    public static PropertyValuesHolder ofInt(IntProperty<?> property, int ... values) {
        return new IntPropertyValuesHolder(property, values);
    }

    @Nonnull
    public static PropertyValuesHolder ofFloat(float ... values) {
        return new FloatPropertyValuesHolder(values);
    }

    @Nonnull
    public static PropertyValuesHolder ofFloat(FloatProperty<?> property, float ... values) {
        return new FloatPropertyValuesHolder(property, values);
    }

    @Nonnull
    @SafeVarargs
    public static <V> PropertyValuesHolder ofObject(TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder();
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    @Nonnull
    @SafeVarargs
    public static <V> PropertyValuesHolder ofObject(Property<?, V> property, TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    @Nonnull
    @SafeVarargs
    public static <V, P> PropertyValuesHolder ofObject(Property<?, P> property, TypeConverter<V, P> converter, TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setConverter(converter);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    @Nonnull
    public static PropertyValuesHolder ofKeyframe(Keyframe ... values) {
        KeyframeSet keyframes = KeyframeSet.ofKeyframe(values);
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder((Keyframes.IntKeyframes)((Object)keyframes));
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder((Keyframes.FloatKeyframes)((Object)keyframes));
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder();
        pvh.mKeyframes = keyframes;
        return pvh;
    }

    @Nonnull
    public static PropertyValuesHolder ofKeyframe(Property<?, ?> property, Keyframe ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setKeyframes(values);
        return pvh;
    }

    @Nonnull
    public static <P> PropertyValuesHolder ofKeyframe(Property<?, P> property, TypeConverter<?, P> converter, Keyframe ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setConverter(converter);
        pvh.setKeyframes(values);
        return pvh;
    }

    @Nonnull
    public static PropertyValuesHolder ofKeyframe(IntProperty<?> property, Keyframe ... values) {
        KeyframeSet keyframes = KeyframeSet.ofKeyframe(values);
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(property, (Keyframes.IntKeyframes)((Object)keyframes));
        }
        throw new IllegalArgumentException("Some keyframes are not int keyframes");
    }

    @Nonnull
    public static PropertyValuesHolder ofKeyframe(FloatProperty<?> property, Keyframe ... values) {
        KeyframeSet keyframes = KeyframeSet.ofKeyframe(values);
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(property, (Keyframes.FloatKeyframes)((Object)keyframes));
        }
        throw new IllegalArgumentException("Some keyframes are not float keyframes");
    }

    public void setIntValues(int ... values) {
        throw new UnsupportedOperationException();
    }

    public void setFloatValues(float ... values) {
        throw new UnsupportedOperationException();
    }

    public void setKeyframes(Keyframe ... values) {
        this.mKeyframes = KeyframeSet.ofKeyframe(values);
    }

    public void setObjectValues(Object ... values) {
        this.mKeyframes = KeyframeSet.ofObject(values);
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    public void setConverter(TypeConverter<?, ?> converter) {
        this.mConverter = converter;
    }

    void setupSetterAndGetter(@Nonnull Object target) {
        if (this.mProperty != null) {
            Object testValue = null;
            Keyframe[] keyframes = this.mKeyframes.getKeyframes();
            int count = keyframes == null ? 0 : keyframes.length;
            for (int i = 0; i < count; ++i) {
                Keyframe kf = keyframes[i];
                if (kf.hasValue() && !kf.mValueWasSetOnStart) continue;
                if (testValue == null) {
                    testValue = this.convertBack(this.mProperty.get(target));
                }
                kf.setValue(testValue);
                kf.mValueWasSetOnStart = true;
            }
        }
    }

    private Object convertBack(Object value) {
        if (this.mConverter != null) {
            if (!(this.mConverter instanceof BidirectionalTypeConverter)) {
                throw new IllegalArgumentException("Converter " + this.mConverter.getClass().getName() + " must be a BidirectionalTypeConverter");
            }
            return ((BidirectionalTypeConverter)this.mConverter).convertBack(value);
        }
        return value;
    }

    void setupStartValue(@Nonnull Object target) {
        if (this.mProperty == null) {
            return;
        }
        Keyframe[] keyframes = this.mKeyframes.getKeyframes();
        if (keyframes.length > 0) {
            Object value = this.convertBack(this.mProperty.get(target));
            keyframes[0].setValue(value);
        }
    }

    void setupEndValue(@Nonnull Object target) {
        if (this.mProperty == null) {
            return;
        }
        Keyframe[] keyframes = this.mKeyframes.getKeyframes();
        if (keyframes.length > 0) {
            Object value = this.convertBack(this.mProperty.get(target));
            keyframes[keyframes.length - 1].setValue(value);
        }
    }

    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder newPVH = (PropertyValuesHolder)super.clone();
            newPVH.mProperty = this.mProperty;
            newPVH.mKeyframes = this.mKeyframes.copy();
            newPVH.mEvaluator = this.mEvaluator;
            return newPVH;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    void setAnimatedValue(@Nonnull Object target) {
        if (this.mProperty != null) {
            this.mProperty.set(target, this.getAnimatedValue());
        }
    }

    void init() {
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    public void setEvaluator(TypeEvaluator<?> evaluator) {
        this.mEvaluator = evaluator;
        this.mKeyframes.setEvaluator(this.mEvaluator);
    }

    public void invert() {
        Keyframe[] keyframes = this.mKeyframes.getKeyframes();
        if (keyframes != null) {
            for (Keyframe keyframe : keyframes) {
                keyframe.setFraction(1.0f - keyframe.getFraction());
            }
        }
    }

    void calculateValue(float fraction) {
        Object value = this.mKeyframes.getValue(fraction);
        this.mAnimatedValue = this.mConverter == null ? value : this.mConverter.convert(value);
    }

    public void setProperty(Property<?, ?> property) {
        this.mProperty = property;
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    static final class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        private int mIntAnimatedValue;

        private IntPropertyValuesHolder(@Nonnull Keyframes.IntKeyframes keyframes) {
            this.mKeyframes = keyframes;
        }

        private IntPropertyValuesHolder(IntProperty<?> property, @Nonnull Keyframes.IntKeyframes keyframes) {
            super(property);
            this.mKeyframes = keyframes;
        }

        private IntPropertyValuesHolder(int ... values) {
            this.setIntValues(values);
        }

        private IntPropertyValuesHolder(IntProperty<?> property, int ... values) {
            super(property);
            this.setIntValues(values);
        }

        @Override
        public void setProperty(Property<?, ?> property) {
            if (property != null && !(property instanceof IntProperty)) {
                throw new IllegalArgumentException();
            }
            super.setProperty(property);
        }

        @Override
        public void setIntValues(int ... values) {
            this.mKeyframes = KeyframeSet.ofInt(values);
        }

        @Override
        public void setKeyframes(Keyframe ... values) {
            super.setKeyframes(values);
            if (!(this.mKeyframes instanceof Keyframes.IntKeyframes)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void setObjectValues(Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setAnimatedValue(@Nonnull Object target) {
            if (this.mProperty != null) {
                ((IntProperty)this.mProperty).setValue(target, this.mIntAnimatedValue);
            }
        }

        @Override
        void calculateValue(float fraction) {
            this.mIntAnimatedValue = ((Keyframes.IntKeyframes)this.mKeyframes).getIntValue(fraction);
        }

        @Override
        public void setConverter(TypeConverter<?, ?> converter) {
            throw new UnsupportedOperationException();
        }

        @Override
        Integer getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        @Override
        public IntPropertyValuesHolder clone() {
            return (IntPropertyValuesHolder)super.clone();
        }
    }

    static final class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        private float mFloatAnimatedValue;

        private FloatPropertyValuesHolder(@Nonnull Keyframes.FloatKeyframes keyframes) {
            this.mKeyframes = keyframes;
        }

        private FloatPropertyValuesHolder(FloatProperty<?> property, @Nonnull Keyframes.FloatKeyframes keyframes) {
            super(property);
            this.mKeyframes = keyframes;
        }

        private FloatPropertyValuesHolder(float ... values) {
            this.setFloatValues(values);
        }

        private FloatPropertyValuesHolder(FloatProperty<?> property, float ... values) {
            super(property);
            this.setFloatValues(values);
        }

        @Override
        public void setProperty(Property<?, ?> property) {
            if (property != null && !(property instanceof FloatProperty)) {
                throw new IllegalArgumentException();
            }
            super.setProperty(property);
        }

        @Override
        public void setFloatValues(float ... values) {
            this.mKeyframes = KeyframeSet.ofFloat(values);
        }

        @Override
        public void setKeyframes(Keyframe ... values) {
            super.setKeyframes(values);
            if (!(this.mKeyframes instanceof Keyframes.FloatKeyframes)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void setObjectValues(Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setAnimatedValue(@Nonnull Object target) {
            if (this.mProperty != null) {
                ((FloatProperty)this.mProperty).setValue(target, this.mFloatAnimatedValue);
            }
        }

        @Override
        void calculateValue(float fraction) {
            this.mFloatAnimatedValue = ((Keyframes.FloatKeyframes)this.mKeyframes).getFloatValue(fraction);
        }

        @Override
        public void setConverter(TypeConverter<?, ?> converter) {
            throw new UnsupportedOperationException();
        }

        @Override
        Float getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            return (FloatPropertyValuesHolder)super.clone();
        }
    }
}

