/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.PipelineDesc;
import icyllis.arc3d.engine.RenderPassDesc;
import icyllis.arc3d.engine.ResourceProvider;
import icyllis.arc3d.engine.Sampler;
import icyllis.arc3d.engine.SamplerDesc;
import icyllis.arc3d.opengl.GLBuffer;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLGraphicsPipeline;
import icyllis.arc3d.opengl.GLGraphicsPipelineBuilder;
import icyllis.arc3d.opengl.GLImage;
import icyllis.arc3d.opengl.GLImageDesc;
import icyllis.arc3d.opengl.GLRenderbuffer;
import icyllis.arc3d.opengl.GLSampler;
import icyllis.arc3d.opengl.GLTexture;
import javax.annotation.Nullable;

public final class GLResourceProvider
extends ResourceProvider {
    private final GLDevice mDevice;

    GLResourceProvider(GLDevice device, Context context, long maxResourceBudget) {
        super(device, context, maxResourceBudget);
        this.mDevice = device;
    }

    @Override
    @SharedPtr
    protected GLGraphicsPipeline createGraphicsPipeline(PipelineDesc pipelineDesc, RenderPassDesc renderPassDesc) {
        return GLGraphicsPipelineBuilder.createGraphicsPipeline(this.mDevice, pipelineDesc);
    }

    @Override
    @Nullable
    @SharedPtr
    protected GLImage onCreateNewImage(ImageDesc desc, boolean budgeted) {
        if (!(desc instanceof GLImageDesc)) {
            return null;
        }
        GLImageDesc glImageDesc = (GLImageDesc)desc;
        if (glImageDesc.mTarget == 36161) {
            return GLRenderbuffer.make(this.mContext, glImageDesc, budgeted);
        }
        return GLTexture.make(this.mContext, glImageDesc, budgeted);
    }

    @Override
    @Nullable
    @SharedPtr
    protected GLBuffer onCreateNewBuffer(long size, int usage) {
        return GLBuffer.make(this.mContext, size, usage);
    }

    @Override
    @Nullable
    @SharedPtr
    protected Sampler createSampler(SamplerDesc desc) {
        return GLSampler.create(this.mContext, desc);
    }
}

