/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.BackendImage;
import icyllis.arc3d.opengl.GLBackendFormat;
import icyllis.arc3d.opengl.GLImageDesc;
import icyllis.arc3d.opengl.GLTextureMutableState;
import javax.annotation.Nonnull;

public final class GLBackendImage
extends BackendImage {
    private final GLImageDesc mInfo;
    final GLTextureMutableState mParams;
    public int handle;
    public int levels = 0;
    public int memoryObject;
    public long memoryHandle = -1L;
    private final BackendFormat mBackendFormat;

    public GLBackendImage(int width, int height, GLImageDesc desc) {
        this(width, height, desc, new GLTextureMutableState(), GLBackendFormat.make(desc.mFormat));
        assert (desc.mFormat != 0);
        this.glTextureParametersModified();
    }

    GLBackendImage(int width, int height, GLImageDesc desc, GLTextureMutableState params, BackendFormat backendFormat) {
        super(desc, params);
        this.mInfo = desc;
        this.mParams = params;
        this.mBackendFormat = backendFormat;
    }

    @Override
    public int getBackend() {
        return 0;
    }

    @Override
    public boolean isExternal() {
        return this.mBackendFormat.isExternal();
    }

    public GLImageDesc getGLImageInfo() {
        return this.mInfo;
    }

    @Override
    public void glTextureParametersModified() {
        if (this.mParams != null) {
            this.mParams.invalidate();
        }
    }

    @Override
    @Nonnull
    public BackendFormat getBackendFormat() {
        return this.mBackendFormat;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isSameImage(BackendImage image) {
        if (image instanceof GLBackendImage) {
            GLBackendImage that = (GLBackendImage)image;
            return this.handle == that.handle;
        }
        return false;
    }

    public String toString() {
        return "{mBackend=OpenGL, mInfo=" + this.mInfo + ", mParams=" + this.mParams + ", mBackendFormat=" + this.mBackendFormat + "}";
    }
}

