/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.engine.BufferViewInfo;
import icyllis.arc3d.granite.DrawBufferManager;
import icyllis.arc3d.granite.DrawCommandList;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;

public class MeshDrawWriter
implements AutoCloseable {
    private final DrawBufferManager mDrawBufferManager;
    private final DrawCommandList mCommandList;
    private int mVertexBinding;
    private int mInstanceBinding;
    private int mVertexStride;
    private int mInstanceStride;
    private final BufferViewInfo mVertexBufferInfo = new BufferViewInfo();
    private final BufferViewInfo mIndexBufferInfo = new BufferViewInfo();
    private final BufferViewInfo mInstanceBufferInfo = new BufferViewInfo();
    private int mTemplateCount;
    private int mPendingCount;
    private int mPendingBase;
    private boolean mPendingBufferBinds;
    private long mFailureStorage = 0L;
    private int mFailureCapacity = 0;
    private BufferViewInfo mCurrentTarget = null;
    private int mCurrentStride;
    private int mReservedCount;
    private long mCurrentWriter;
    private final BufferViewInfo mTempAllocInfo = new BufferViewInfo();

    public MeshDrawWriter(DrawBufferManager drawBufferManager, DrawCommandList commandList) {
        this.mDrawBufferManager = drawBufferManager;
        this.mCommandList = commandList;
    }

    @Override
    public void close() {
        if (this.mFailureStorage != 0L) {
            MemoryUtil.nmemFree((long)this.mFailureStorage);
        }
        this.mFailureStorage = 0L;
    }

    public void newPipelineState(int vertexBinding, int instanceBinding, int vertexStride, int instanceStride) {
        this.flush();
        this.mVertexBinding = vertexBinding;
        this.mInstanceBinding = instanceBinding;
        this.mVertexStride = vertexStride;
        this.mInstanceStride = instanceStride;
        this.mPendingBase = 0;
        assert (this.mPendingCount == 0);
    }

    public void newDynamicState() {
        this.flush();
    }

    void setTemplate(@Nullable BufferViewInfo vertexBufferInfo, @Nullable BufferViewInfo indexBufferInfo, @Nullable BufferViewInfo instanceBufferInfo, int templateCount) {
        boolean instanceChange;
        boolean vertexChange = !this.mVertexBufferInfo.equals(vertexBufferInfo);
        boolean bl = instanceChange = !this.mInstanceBufferInfo.equals(instanceBufferInfo);
        if (vertexChange || instanceChange || !this.mIndexBufferInfo.equals(indexBufferInfo)) {
            boolean isAppendingVertices;
            if (this.mPendingCount > 0) {
                this.flush();
            }
            boolean willAppendVertices = templateCount == 0;
            boolean bl2 = isAppendingVertices = this.mTemplateCount == 0;
            if (willAppendVertices != isAppendingVertices || isAppendingVertices && vertexChange || !isAppendingVertices && instanceChange) {
                this.mPendingBase = 0;
            }
            this.mVertexBufferInfo.set(vertexBufferInfo);
            this.mIndexBufferInfo.set(indexBufferInfo);
            this.mInstanceBufferInfo.set(instanceBufferInfo);
            this.mTemplateCount = templateCount;
            this.mPendingBufferBinds = true;
        } else if (templateCount >= 0 && templateCount != this.mTemplateCount || templateCount < 0 && this.mTemplateCount >= 0) {
            if (this.mPendingCount > 0) {
                this.flush();
            }
            if (templateCount == 0 != (this.mTemplateCount == 0)) {
                this.mPendingBase = 0;
            }
            this.mTemplateCount = templateCount;
        }
    }

    public void flush() {
        if (this.mPendingCount == 0 || this.mTemplateCount == -1) {
            return;
        }
        if (this.mPendingBufferBinds) {
            if (this.mIndexBufferInfo.isValid()) {
                this.mCommandList.bindIndexBuffer(1, this.mIndexBufferInfo);
            }
            if (this.mVertexBufferInfo.isValid()) {
                assert (this.mVertexBinding != -1 && this.mVertexStride > 0);
                this.mCommandList.bindVertexBuffer(this.mVertexBinding, this.mVertexBufferInfo);
            }
            if (this.mInstanceBufferInfo.isValid()) {
                assert (this.mInstanceBinding != -1 && this.mInstanceStride > 0);
                this.mCommandList.bindVertexBuffer(this.mInstanceBinding, this.mInstanceBufferInfo);
            }
            this.mPendingBufferBinds = false;
        }
        if (this.mTemplateCount != 0) {
            int realVertexCount;
            if (this.mTemplateCount < 0) {
                realVertexCount = -this.mTemplateCount - 1;
                this.mTemplateCount = -1;
            } else {
                realVertexCount = this.mTemplateCount;
            }
            if (this.mIndexBufferInfo.isValid()) {
                this.mCommandList.drawIndexedInstanced(realVertexCount, 0, this.mPendingCount, this.mPendingBase, 0);
            } else {
                this.mCommandList.drawInstanced(this.mPendingCount, this.mPendingBase, realVertexCount, 0);
            }
        } else {
            assert (!this.mInstanceBufferInfo.isValid());
            if (this.mIndexBufferInfo.isValid()) {
                this.mCommandList.drawIndexed(this.mPendingCount, 0, this.mPendingBase);
            } else {
                this.mCommandList.draw(this.mPendingCount, this.mPendingBase);
            }
        }
        this.mPendingBase += this.mPendingCount;
        this.mPendingCount = 0;
    }

    private long getFailureStorage(int size) {
        if (size > this.mFailureCapacity) {
            long newStorage = MemoryUtil.nmemRealloc((long)this.mFailureStorage, (long)size);
            if (newStorage == 0L) {
                throw new OutOfMemoryError();
            }
            this.mFailureStorage = newStorage;
            this.mFailureCapacity = size;
            return newStorage;
        }
        return this.mFailureStorage;
    }

    public void beginVertices() {
        assert (this.mCurrentTarget == null);
        assert (this.mVertexStride > 0);
        this.setTemplate(this.mVertexBufferInfo, null, null, 0);
        this.mCurrentTarget = this.mVertexBufferInfo;
        this.mCurrentStride = this.mVertexStride;
    }

    public void beginInstances(@Nullable BufferViewInfo vertexBufferInfo, @Nullable BufferViewInfo indexBufferInfo, int vertexCount) {
        assert (vertexCount > 0);
        assert (this.mCurrentTarget == null);
        assert (this.mInstanceStride > 0);
        this.setTemplate(vertexBufferInfo, indexBufferInfo, this.mInstanceBufferInfo, vertexCount);
        this.mCurrentTarget = this.mInstanceBufferInfo;
        this.mCurrentStride = this.mInstanceStride;
    }

    public void reserve(int count) {
        if (this.mReservedCount >= count) {
            return;
        }
        assert (this.mCurrentTarget != null);
        if (this.mReservedCount > 0) {
            this.mDrawBufferManager.putBackVertexBytes(this.mReservedCount * this.mCurrentStride);
        }
        this.mReservedCount = count;
        long writer = this.mDrawBufferManager.getVertexPointer(count * this.mCurrentStride, this.mTempAllocInfo);
        if (this.mTempAllocInfo.mBuffer != this.mCurrentTarget.mBuffer || this.mTempAllocInfo.mOffset != this.mCurrentTarget.mOffset + (long)(this.mPendingBase + this.mPendingCount) * (long)this.mCurrentStride) {
            this.flush();
            this.mCurrentTarget.set(this.mTempAllocInfo);
            this.mPendingBase = 0;
            this.mPendingBufferBinds = true;
        }
        this.mCurrentWriter = writer;
    }

    public long append(int count) {
        assert (count > 0);
        this.reserve(count);
        int size = count * this.mCurrentStride;
        if (this.mCurrentWriter == 0L) {
            return this.getFailureStorage(size);
        }
        assert (this.mReservedCount >= count);
        this.mReservedCount -= count;
        this.mPendingCount += count;
        long writer = this.mCurrentWriter;
        this.mCurrentWriter += (long)size;
        return writer;
    }

    public void endAppender() {
        assert (this.mCurrentTarget != null);
        if (this.mReservedCount > 0) {
            this.mDrawBufferManager.putBackVertexBytes(this.mReservedCount * this.mCurrentStride);
        }
        this.mCurrentTarget = null;
        this.mCurrentWriter = 0L;
    }
}

