/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.granite.PaintParams;
import javax.annotation.Nullable;

public class KeyContext {
    @RawPtr
    private final RecordingContext mRecordingContext;
    private final Caps mCaps;
    private final ImageInfo mTargetInfo;
    private float mR;
    private float mG;
    private float mB;
    private float mA;

    public KeyContext(@RawPtr RecordingContext recordingContext, ImageInfo targetInfo) {
        this.mRecordingContext = recordingContext;
        this.mCaps = recordingContext.getCaps();
        this.mTargetInfo = targetInfo;
    }

    public void reset(PaintParams paintParams) {
        ColorSpace dstCS = this.mTargetInfo.colorSpace();
        if (dstCS != null && !dstCS.isSrgb()) {
            float[] col = ColorSpace.connect(ColorSpace.get(ColorSpace.Named.SRGB), dstCS).transform(paintParams.r(), paintParams.g(), paintParams.b());
            this.mR = col[0];
            this.mG = col[1];
            this.mB = col[2];
        } else {
            this.mR = paintParams.r();
            this.mG = paintParams.g();
            this.mB = paintParams.b();
        }
        this.mA = paintParams.a();
    }

    @Nullable
    @RawPtr
    public RecordingContext getRecordingContext() {
        return this.mRecordingContext;
    }

    public Caps getCaps() {
        return this.mCaps;
    }

    public float r() {
        return this.mR;
    }

    public float g() {
        return this.mG;
    }

    public float b() {
        return this.mB;
    }

    public float a() {
        return this.mA;
    }

    public ImageInfo targetInfo() {
        return this.mTargetInfo;
    }
}

