/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.UniqueID;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.GpuRenderTarget;
import icyllis.arc3d.engine.GpuSurface;
import icyllis.arc3d.engine.IResourceKey;
import icyllis.arc3d.engine.ISurface;
import icyllis.arc3d.engine.Image;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.ResourceProvider;
import icyllis.arc3d.engine.SurfaceProxy;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class RenderTargetProxy
extends SurfaceProxy {
    private int mSampleCount;
    private final Rect2i mResolveRect = new Rect2i();
    private ImageViewProxy mColorImageProxy;

    RenderTargetProxy(BackendFormat format, int width, int height, int sampleCount, int surfaceFlags) {
        super(format, width, height, surfaceFlags);
        assert (width > 0 && height > 0);
        this.mSampleCount = sampleCount;
    }

    RenderTargetProxy(BackendFormat format, int width, int height, int sampleCount, int surfaceFlags, SurfaceProxy.LazyInstantiateCallback callback) {
        super(format, width, height, surfaceFlags);
        this.mSampleCount = sampleCount;
        this.mLazyInstantiateCallback = Objects.requireNonNull(callback);
        assert (width < 0 && height < 0 && (surfaceFlags & 2) != 0 || width > 0 && height > 0);
    }

    RenderTargetProxy(GpuRenderTarget renderTarget, int surfaceFlags) {
        super(renderTarget, surfaceFlags);
        this.mGpuSurface = renderTarget;
        this.mSampleCount = renderTarget.getSampleCount();
    }

    @Override
    protected void deallocate() {
        this.mGpuSurface = RefCnt.move(this.mGpuSurface);
        this.mColorImageProxy = RefCnt.move(this.mColorImageProxy);
    }

    @Override
    public boolean isLazy() {
        return this.mGpuSurface == null && this.mLazyInstantiateCallback != null;
    }

    @Override
    public int getBackingWidth() {
        assert (!this.isLazyMost());
        if (this.mGpuSurface != null) {
            return this.mGpuSurface.getWidth();
        }
        if ((this.mSurfaceFlags & 2) != 0) {
            return ISurface.getApproxSize(this.mWidth);
        }
        return this.mWidth;
    }

    @Override
    public int getBackingHeight() {
        assert (!this.isLazyMost());
        if (this.mGpuSurface != null) {
            return this.mGpuSurface.getHeight();
        }
        if ((this.mSurfaceFlags & 2) != 0) {
            return ISurface.getApproxSize(this.mHeight);
        }
        return this.mHeight;
    }

    @Override
    public int getSampleCount() {
        return this.mSampleCount;
    }

    public void setResolveRect(int left, int top, int right, int bottom) {
        assert (this.isManualMSAAResolve());
        if (left == 0 && top == 0 && right == 0 && bottom == 0) {
            this.mResolveRect.setEmpty();
        } else {
            assert (right > left && bottom > top);
            assert (left >= 0 && right <= this.getBackingWidth() && top >= 0 && bottom <= this.getBackingHeight());
            this.mResolveRect.join(left, top, right, bottom);
        }
    }

    public boolean needsResolve() {
        assert (this.mResolveRect.isEmpty() || this.isManualMSAAResolve());
        return this.isManualMSAAResolve() && !this.mResolveRect.isEmpty();
    }

    public Rect2ic getResolveRect() {
        assert (this.isManualMSAAResolve());
        return this.mResolveRect;
    }

    @Override
    public UniqueID getBackingUniqueID() {
        if (this.mGpuSurface != null) {
            return this.mGpuSurface.getUniqueID();
        }
        return this.mUniqueID;
    }

    @Override
    public boolean isInstantiated() {
        return this.mGpuSurface != null;
    }

    @Override
    public boolean instantiate(ResourceProvider resourceProvider) {
        if (this.isLazy()) {
            return false;
        }
        return this.mGpuSurface != null;
    }

    @Override
    public void clear() {
        assert (this.mGpuSurface != null);
        this.mGpuSurface.unref();
        this.mGpuSurface = null;
    }

    @Override
    public boolean shouldSkipAllocator() {
        if ((this.mSurfaceFlags & 0x200) != 0) {
            return true;
        }
        return this.mGpuSurface != null;
    }

    @Override
    public boolean isBackingWrapped() {
        return this.mGpuSurface != null;
    }

    @Override
    @Nullable
    public GpuSurface getGpuSurface() {
        return this.mGpuSurface;
    }

    @Override
    @Nullable
    public Image getGpuImage() {
        return this.mGpuSurface.asImage();
    }

    @Override
    @Nullable
    public GpuRenderTarget getGpuRenderTarget() {
        return (GpuRenderTarget)this.mGpuSurface;
    }

    @Override
    public ImageViewProxy asImageProxy() {
        return this.mColorImageProxy;
    }

    @Override
    public RenderTargetProxy asRenderTargetProxy() {
        return this;
    }

    @Override
    public boolean doLazyInstantiation(ResourceProvider resourceProvider) {
        int height;
        assert (this.isLazy());
        @SharedPtr GpuRenderTarget surface = null;
        boolean releaseCallback = false;
        int width = this.isLazyMost() ? -1 : this.getWidth();
        SurfaceProxy.LazyCallbackResult result = this.mLazyInstantiateCallback.onLazyInstantiate(resourceProvider, this.mFormat, width, height = this.isLazyMost() ? -1 : this.getHeight(), this.getSampleCount(), this.mSurfaceFlags, "");
        if (result != null) {
            surface = (GpuRenderTarget)result.mSurface;
            releaseCallback = result.mReleaseCallback;
        }
        if (surface == null) {
            this.mHeight = 0;
            this.mWidth = 0;
            return false;
        }
        if (this.isLazyMost()) {
            this.mWidth = surface.getWidth();
            this.mHeight = surface.getHeight();
        }
        assert (this.getWidth() <= surface.getWidth());
        assert (this.getHeight() <= surface.getHeight());
        this.mGpuSurface = RefCnt.move(this.mGpuSurface, surface);
        if (releaseCallback) {
            this.mLazyInstantiateCallback = null;
        }
        return true;
    }

    @Override
    @Nonnull
    IResourceKey computeScratchKey() {
        assert (this.mColorImageProxy != null);
        return null;
    }

    @Override
    @Nullable
    @SharedPtr
    GpuSurface createSurface(ResourceProvider resourceProvider) {
        assert (this.mColorImageProxy != null);
        return null;
    }
}

