/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.ImageMutableState;
import javax.annotation.Nonnull;

public abstract class BackendImage {
    protected final ImageDesc mDesc;
    protected final ImageMutableState mMutableState;

    protected BackendImage(ImageDesc desc, ImageMutableState mutableState) {
        this.mDesc = desc;
        this.mMutableState = mutableState;
    }

    public abstract int getBackend();

    public final int getWidth() {
        return this.mDesc.mWidth;
    }

    public final int getHeight() {
        return this.mDesc.mHeight;
    }

    public final int getDepth() {
        return this.mDesc.mDepth;
    }

    public final int getArraySize() {
        return this.mDesc.mArraySize;
    }

    public final int getImageType() {
        return this.mDesc.getImageType();
    }

    public abstract boolean isExternal();

    public final boolean isMipmapped() {
        return this.mDesc.isMipmapped();
    }

    public final int getMipLevelCount() {
        return this.mDesc.mMipLevelCount;
    }

    @Nonnull
    public final ImageDesc getDesc() {
        return this.mDesc;
    }

    @Nonnull
    public final ImageMutableState getMutableState() {
        return this.mMutableState;
    }

    public void glTextureParametersModified() {
    }

    public void setVkImageLayout(int layout) {
    }

    public void setVkQueueFamilyIndex(int queueFamilyIndex) {
    }

    @Nonnull
    public abstract BackendFormat getBackendFormat();

    public abstract boolean isProtected();

    public abstract boolean isSameImage(BackendImage var1);
}

