/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Paint;
import icyllis.arc3d.core.Path;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.StrokeRec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PathUtils {
    public static boolean fillPathWithPaint(@Nonnull Path src, @Nonnull Paint paint, @Nonnull Path dst, @Nullable Rect2fc cullRect, float resScale) {
        return PathUtils.fillPathWithPaint(src, paint, dst, cullRect, Matrix.makeScale(resScale, resScale));
    }

    public static boolean fillPathWithPaint(@Nonnull Path src, @Nonnull Paint paint, @Nonnull Path dst, @Nullable Rect2fc cullRect, @Nonnull Matrixc ctm) {
        StrokeRec strokeRec;
        float resScale;
        if (!src.isFinite()) {
            dst.reset();
            return false;
        }
        if (ctm.hasPerspective()) {
            Rect2f transformedBounds = new Rect2f();
            ctm.mapRect(src.getBounds(), transformedBounds);
            resScale = ctm.getMaxScale(transformedBounds.centerX(), transformedBounds.centerY());
        } else {
            resScale = ctm.getMaxScale();
        }
        if (resScale <= 1.0E-5f || !Float.isFinite(resScale)) {
            resScale = 1.0f;
        }
        if (!(strokeRec = new StrokeRec(paint, resScale)).applyToPath(src, dst)) {
            dst.set(src);
        }
        if (!dst.isFinite()) {
            dst.reset();
            return false;
        }
        return !strokeRec.isHairlineStyle();
    }
}

