/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.tree.ConstructorCall;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Type;
import java.util.OptionalDouble;
import javax.annotation.Nonnull;

public final class ConstructorMatrixResize
extends ConstructorCall {
    private ConstructorMatrixResize(int position, Type type, Expression ... arguments) {
        super(position, type, arguments);
        assert (arguments.length == 1);
    }

    @Nonnull
    public static Expression make(int position, @Nonnull Type type, @Nonnull Expression arg) {
        assert (type.isMatrix());
        assert (arg.getType().getComponentType().matches(type.getComponentType()));
        if (type.getRows() == arg.getType().getRows() && type.getCols() == arg.getType().getCols()) {
            return arg;
        }
        return new ConstructorMatrixResize(position, type, arg);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.CONSTRUCTOR_MATRIX_RESIZE;
    }

    @Override
    public OptionalDouble getConstantValue(int i) {
        int rows = this.getType().getRows();
        int row = i % rows;
        int col = i / rows;
        assert (col >= 0);
        assert (row >= 0);
        assert (col < this.getType().getCols());
        assert (row < this.getType().getRows());
        Type argType = this.getArgument().getType();
        if (col < argType.getCols() && row < argType.getRows()) {
            i = row + col * argType.getRows();
            return this.getArgument().getConstantValue(i);
        }
        return OptionalDouble.of(col == row ? 1.0 : 0.0);
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new ConstructorMatrixResize(position, this.getType(), this.cloneArguments());
    }
}

