/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.tree.ConstructorArray;
import icyllis.arc3d.compiler.tree.ConstructorCompound;
import icyllis.arc3d.compiler.tree.ConstructorScalarCast;
import icyllis.arc3d.compiler.tree.ConstructorStruct;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import icyllis.arc3d.compiler.tree.Type;
import java.util.List;
import java.util.OptionalDouble;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ConstructorCall
extends Expression {
    private final @Unmodifiable Expression[] mArguments;

    protected ConstructorCall(int position, Type type, Expression[] arguments) {
        super(position, type);
        assert (arguments.length != 0);
        this.mArguments = arguments;
    }

    @Nullable
    public static Expression convert(@Nonnull Context context, int pos, @Nonnull Type type, @Nonnull List<Expression> args) {
        if (args.size() == 1 && args.get(0).getType().matches(type) && !type.getElementType().isOpaque()) {
            Expression expr = args.get(0);
            expr.mPosition = pos;
            return expr;
        }
        if (type.isScalar()) {
            return ConstructorScalarCast.convert(context, pos, type, args);
        }
        if (type.isVector() || type.isMatrix()) {
            return ConstructorCompound.convert(context, pos, type, args);
        }
        if (type.isArray()) {
            return ConstructorArray.convert(context, pos, type, args);
        }
        if (type.isStruct() && type.getFields().length > 0) {
            return ConstructorStruct.convert(context, pos, type, args);
        }
        context.error(pos, "cannot construct '" + type + "'");
        return null;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitConstructorCall(this)) {
            return true;
        }
        for (Expression arg : this.mArguments) {
            if (!arg.accept(visitor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isConstructorCall() {
        return true;
    }

    public final Type getComponentType() {
        return this.getType().getComponentType();
    }

    public final Expression getArgument() {
        assert (this.mArguments.length == 1);
        return this.mArguments[0];
    }

    public final @Unmodifiable Expression[] getArguments() {
        return this.mArguments;
    }

    @Override
    public OptionalDouble getConstantValue(int i) {
        assert (i >= 0 && i < this.getType().getComponents());
        for (Expression arg : this.mArguments) {
            int components = arg.getType().getComponents();
            if (i < components) {
                return arg.getConstantValue(i);
            }
            i -= components;
        }
        throw new AssertionError(i);
    }

    @Override
    @Nonnull
    public String toString(int parentPrecedence) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Expression arg : this.mArguments) {
            joiner.add(arg.toString(17));
        }
        return this.getType().getName() + "(" + joiner + ")";
    }

    final Expression[] cloneArguments() {
        Expression[] result = (Expression[])this.mArguments.clone();
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].clone();
        }
        return result;
    }
}

