/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer.computerthread;

import dan200.computercraft.core.computer.TimeoutState;

public abstract class ManagedTimeoutState
extends TimeoutState {
    private long startTime;
    private long abortDeadline;
    private long pauseDeadline;

    @Override
    public final synchronized void refresh() {
        long now = System.nanoTime();
        boolean changed = false;
        if (!this.paused && Long.compareUnsigned(now, this.pauseDeadline) >= 0 && this.shouldPause()) {
            this.paused = true;
            changed = true;
        }
        if (!this.softAbort && Long.compareUnsigned(now, this.abortDeadline) >= 0) {
            this.softAbort = true;
            changed = true;
        }
        if (this.softAbort && !this.hardAbort && Long.compareUnsigned(now, this.abortDeadline + ABORT_TIMEOUT) >= 0) {
            this.hardAbort = true;
            changed = true;
        }
        if (changed) {
            this.updateListeners();
        }
    }

    public final long getExecutionTime() {
        return System.nanoTime() - this.startTime;
    }

    public final long getRemainingTime() {
        return this.abortDeadline - System.nanoTime();
    }

    public final void setRemainingTime(long time) {
        this.abortDeadline = this.startTime + time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void hardAbort() {
        this.hardAbort = true;
        this.softAbort = true;
        ManagedTimeoutState managedTimeoutState = this;
        synchronized (managedTimeoutState) {
            this.updateListeners();
        }
    }

    public final synchronized void startTimer(long pauseTimeout) {
        long now;
        this.startTime = now = System.nanoTime();
        this.abortDeadline = now + BASE_TIMEOUT;
        this.pauseDeadline = now + pauseTimeout;
    }

    public final synchronized void reset() {
        this.hardAbort = false;
        this.softAbort = false;
        this.paused = false;
        this.updateListeners();
    }

    protected abstract boolean shouldPause();
}

