/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.tesseract.TesseractConfig;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.nio.file.Path;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class TesseractSaveHandler {
    private static long lastSaveTime = 0L;

    public static void registerListeners() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> TesseractSaveHandler.onJoin((class_1657)handler.method_32311()));
        ServerTickEvents.END_SERVER_TICK.register(TesseractSaveHandler::tick);
        ServerWorldEvents.LOAD.register(TesseractSaveHandler::load);
    }

    private static void onJoin(class_1657 player) {
        if (player.method_5770().field_9236) {
            return;
        }
        TesseractTracker.sendReferences(player);
        TesseractChannelManager.sendChannels(player);
    }

    private static void tick(MinecraftServer server) {
        if (System.currentTimeMillis() - lastSaveTime >= (long)(TesseractConfig.saveInterval.get() * 60000)) {
            Path saveDirectory = CommonUtils.getServer().method_27050(class_5218.field_24188);
            TesseractTracker.saveReferences(saveDirectory);
            TesseractChannelManager.saveChannels(saveDirectory);
            lastSaveTime = System.currentTimeMillis();
        }
    }

    public static void save(class_1937 level) {
        if (level.method_8608() || level.method_27983() != class_1937.field_25179) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().method_27050(class_5218.field_24188);
        TesseractTracker.saveReferences(saveDirectory);
        TesseractChannelManager.saveChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }

    private static void load(MinecraftServer server, class_1937 level) {
        if (level.method_8608() || level.method_27983() != class_1937.field_25179) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().method_27050(class_5218.field_24188);
        TesseractTracker.loadReferences(saveDirectory);
        TesseractChannelManager.loadChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }
}

