/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.mixin;

import java.util.Optional;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.init.DimensionInit;
import net.dungeonz.network.DungeonServerPacket;
import net.dungeonz.util.DungeonHelper;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Inject(method={"onPlayerConnect"}, at={@At(value="TAIL")})
    private void onPlayerConnectMixin(class_2535 connection, class_3222 player, CallbackInfo info) {
        if (player.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD) {
            if (DungeonHelper.getCurrentDungeon(player) != null && DungeonHelper.getDungeonPortalEntity(player).getDungeonPlayerUuids().contains(player.method_5667()) && !DungeonHelper.getDungeonPortalEntity(player).isOnCooldown((int)player.method_37908().method_8510())) {
                Dungeon dungeon = DungeonHelper.getCurrentDungeon(player);
                DungeonServerPacket.writeS2CDungeonInfoPacket(player, dungeon.getBreakableBlockIdList(), dungeon.getplaceableBlockIdList(), dungeon.isElytraAllowed());
            } else {
                DungeonHelper.teleportOutOfDungeon(player);
            }
        }
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;onPlayerRespawned(Lnet/minecraft/server/network/ServerPlayerEntity;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void respawnPlayerMixin(class_3222 oldPlayer, boolean alive, CallbackInfoReturnable<class_3222> info, class_2338 blockPos, float f, boolean bl, class_3218 serverWorld, Optional<class_243> optional, class_3218 serverWorld2, class_3222 serverPlayerEntity) {
        DungeonPortalEntity dungeonPortalEntity;
        if (!alive && oldPlayer.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD && DungeonHelper.getDungeonPortalEntity(oldPlayer) != null && !(dungeonPortalEntity = DungeonHelper.getDungeonPortalEntity(oldPlayer)).getDungeon().isRespawnAllowed()) {
            dungeonPortalEntity.getDungeonPlayerUuids().remove(oldPlayer.method_5667());
            dungeonPortalEntity.addDeadDungeonPlayerUuids(serverPlayerEntity.method_5667());
            if (dungeonPortalEntity.getDungeonPlayerCount() == 0) {
                dungeonPortalEntity.setCooldownTime(dungeonPortalEntity.getDungeon().getCooldown() + (int)serverWorld.method_8510());
            }
            dungeonPortalEntity.method_5431();
        }
    }

    @ModifyVariable(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z", ordinal=0), ordinal=0)
    private Optional<class_243> respawnPlayerMixin(Optional<class_243> original, class_3222 oldPlayer, boolean alive) {
        if (!alive && oldPlayer.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD && DungeonHelper.getDungeonPortalEntity(oldPlayer) != null && DungeonHelper.getDungeonPortalEntity(oldPlayer).getDungeon().isRespawnAllowed()) {
            class_2338 pos = DungeonHelper.getDungeonPortalEntity(oldPlayer).method_11016();
            return Optional.of(new class_243((double)(pos.method_10263() * 16), 100.0, (double)(pos.method_10260() * 16)));
        }
        return original;
    }

    @ModifyVariable(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z", ordinal=0), ordinal=0)
    private class_2338 respawnPlayerMixin(class_2338 original, class_3222 oldPlayer, boolean alive) {
        if (!alive && oldPlayer.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD && DungeonHelper.getDungeonPortalEntity(oldPlayer) != null && DungeonHelper.getDungeonPortalEntity(oldPlayer).getDungeon().isRespawnAllowed()) {
            class_2338 pos = DungeonHelper.getDungeonPortalEntity(oldPlayer).method_11016();
            return new class_2338(pos.method_10263() * 16, 100, pos.method_10260() * 16);
        }
        return original;
    }

    @ModifyVariable(method={"respawnPlayer"}, at=@At(value="FIELD", target="Lnet/minecraft/server/PlayerManager;server:Lnet/minecraft/server/MinecraftServer;", ordinal=2), ordinal=1)
    private class_3218 respawnPlayerMixin(class_3218 original, class_3222 oldPlayer, boolean alive) {
        if (!alive && oldPlayer.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD && DungeonHelper.getDungeonPortalEntity(oldPlayer) != null && DungeonHelper.getDungeonPortalEntity(oldPlayer).getDungeon().isRespawnAllowed()) {
            return oldPlayer.method_51469();
        }
        return original;
    }
}

