/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class InvariantModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_TEMPERATURE = 1.25f;
    private static final float DAMAGE = 2.0f;
    private static final float ACCURACY = 0.120000005f;

    private static float getBonus(class_1309 living, int level) {
        class_2338 pos = living.method_24515();
        return (1.25f - Math.abs(0.75f - ((class_1959)living.method_37908().method_23753(pos).comp_349()).method_21740(pos))) * (float)level;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT);
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + InvariantModifier.getBonus(context.getAttacker(), level) * 2.0f * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.ACCURACY) {
            return baseValue + InvariantModifier.getBonus(living, modifier.getLevel()) * 0.120000005f * multiplier;
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        float bonus = player != null && key == TooltipKey.SHIFT ? InvariantModifier.getBonus((class_1309)player, level) : (float)level * 1.25f;
        if (bonus > 0.01f) {
            if (tool.hasTag(TinkerTags.Items.RANGED)) {
                this.addStatTooltip(tool, ToolStats.ACCURACY, TinkerTags.Items.RANGED, bonus * 0.120000005f, tooltip);
            } else {
                this.addDamageTooltip(tool, bonus * 2.0f, tooltip);
            }
        }
    }
}

