/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.melting;

import dev.architectury.fluid.FluidStack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.rei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;
import slimeknights.tconstruct.plugin.rei.melting.MeltingDisplay;
import slimeknights.tconstruct.plugin.rei.widgets.ArrowWidget;
import slimeknights.tconstruct.plugin.rei.widgets.WidgetHolder;

public abstract class AbstractMeltingCategory
implements TinkersCategory<MeltingDisplay> {
    protected static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/melting.png");
    protected static final String KEY_COOLING_TIME = TConstruct.makeTranslationKey("jei", "melting.time");
    protected static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    protected static final String KEY_MULTIPLIER = TConstruct.makeTranslationKey("jei", "melting.multiplier");
    protected static final class_2561 TOOLTIP_ORE = class_2561.method_43471((String)TConstruct.makeTranslationKey("jei", "melting.ore"));
    public static final IRecipeTooltipReplacement FUEL_TOOLTIP = (slot, tooltip) -> {
        EntryStack stack = slot.getCurrentEntry().cast();
        MeltingFuelHandler.getTemperature(((FluidStack)stack.getValue()).getFluid()).ifPresent(temperature -> {
            tooltip.add(class_2561.method_43469((String)KEY_TEMPERATURE, (Object[])new Object[]{temperature}).method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43469((String)KEY_MULTIPLIER, (Object[])new Object[]{Float.valueOf((float)temperature / 1000.0f)}).method_27692(class_124.field_1080));
        });
    };
    private final WidgetHolder background = new WidgetHolder(BACKGROUND_LOC, 0, 0, 132, 40);
    protected final WidgetHolder tankOverlay = new WidgetHolder(BACKGROUND_LOC, 132, 0, 32, 32);
    protected final WidgetHolder plus = new WidgetHolder(BACKGROUND_LOC, 132, 34, 6, 6);

    @Override
    public void draw(MeltingDisplay display, class_332 graphics, double mouseX, double mouseY) {
        int temperature = display.getTemperature();
        class_327 fontRenderer = class_310.method_1551().field_1772;
        String tempString = class_1074.method_4662((String)KEY_TEMPERATURE, (Object[])new Object[]{temperature});
        int x = 56 - fontRenderer.method_1727(tempString) / 2;
        graphics.method_51433(fontRenderer, tempString, x, 3, Color.GRAY.getRGB(), false);
    }

    @Override
    public void addWidgets(MeltingDisplay display, List<Widget> ingredients, Point origin, Rectangle bounds) {
        ingredients.add((Widget)new ArrowWidget(this.point(56, 18, origin), BACKGROUND_LOC, 150, 41).animationDurationTicks(display.getTime() * 5));
        if (display.getOreType() != null) {
            ingredients.add(this.plus.build(87, 31, origin));
        }
    }

    @Override
    public List<class_2561> getTooltipStrings(MeltingDisplay display, List<Widget> widgets, double mouseXD, double mouseYD) {
        int mouseX = (int)mouseXD;
        int mouseY = (int)mouseYD;
        if (display.getOreType() != null && GuiUtil.isHovered(mouseX, mouseY, 87, 31, 16, 16)) {
            return Collections.singletonList(TOOLTIP_ORE);
        }
        if (GuiUtil.isHovered(mouseX, mouseY, 56, 18, 24, 17)) {
            return Collections.singletonList(class_2561.method_43469((String)KEY_COOLING_TIME, (Object[])new Object[]{display.getTime() / 4}));
        }
        return Collections.emptyList();
    }

    @Override
    public WidgetHolder getBackground() {
        return this.background;
    }

    public static class MeltingFluidCallback
    implements IRecipeTooltipReplacement {
        public static final MeltingFluidCallback INSTANCE = new MeltingFluidCallback();

        protected boolean appendMaterial(FluidStack stack, List<class_2561> list) {
            return FluidTooltipHandler.appendMaterialNoShift((class_3611)stack.getFluid(), (long)stack.getAmount(), list);
        }

        @Override
        public void addMiddleLines(Slot slot, List<class_2561> list) {
            EntryStack stack = slot.getCurrentEntry().cast();
            if (this.appendMaterial((FluidStack)stack.getValue(), list)) {
                FluidTooltipHandler.appendShift(list);
            }
        }
    }
}

