/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public interface IToolStatProvider {
    public StatsNBT buildStats(ToolDefinition var1, MaterialNBT var2);

    public boolean isMultipart();

    default public void validate(ToolDefinitionData data) {
        int size = data.getParts().size();
        if (this.isMultipart()) {
            if (size == 0) {
                throw new IllegalStateException("Must have at least one tool part for a multipart tool");
            }
        } else if (size != 0) {
            throw new IllegalStateException("Cannot have parts for a specialized tool");
        }
    }

    default public ToolDefinitionData getDefaultData() {
        return ToolDefinitionData.EMPTY;
    }

    public static void validate(String name, MaterialStatsId requiredStat, Set<MaterialStatsId> otherStats, ToolDefinitionData data) {
        List<PartRequirement> requirements = data.getParts();
        if (requirements.isEmpty()) {
            throw new IllegalStateException("Must have at least one tool part for a " + name + " tool");
        }
        boolean foundHead = false;
        for (PartRequirement req : requirements) {
            MaterialStatsId statType = req.getStatType();
            if (statType.equals((Object)requiredStat)) {
                foundHead = true;
                continue;
            }
            if (otherStats.contains((Object)statType)) continue;
            throw new IllegalStateException("Invalid " + name + " tool part type " + statType + ", only support: " + requiredStat + otherStats.stream().map(class_2960::toString).reduce("", (s1, s2) -> s1 + ", " + s2));
        }
        if (!foundHead) {
            throw new IllegalStateException(name + " tool must use at least one " + requiredStat + " part");
        }
    }
}

