/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingRecipe
implements IMeltingRecipe {
    private final class_2960 id;
    protected final String group;
    protected final class_1856 input;
    protected final FluidStack output;
    protected final int temperature;
    protected final int time;
    protected final List<FluidStack> byproducts;
    private List<List<FluidStack>> outputWithByproducts;

    public boolean matches(IMeltingContainer inv, class_1937 world) {
        return this.input.method_8093(inv.getStack());
    }

    @Override
    public int getTemperature(IMeltingContainer inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingContainer inv) {
        return this.time;
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        return this.output.copy();
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.input});
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.meltingSerializer.get();
    }

    @Nullable
    public IMeltingContainer.OreRateType getOreType() {
        return null;
    }

    @Override
    public void handleByproducts(IMeltingContainer inv, SlottedStorage<FluidVariant> handler) {
        for (FluidStack fluidStack : this.byproducts) {
            TransferUtil.insertFluid(handler, (FluidStack)fluidStack.copy());
        }
    }

    public List<List<FluidStack>> getOutputWithByproducts() {
        if (this.outputWithByproducts == null) {
            this.outputWithByproducts = Stream.concat(Stream.of(this.output).map(output -> {
                IMeltingContainer.OreRateType rate = this.getOreType();
                if (rate != null) {
                    return new FluidStack(output, Config.COMMON.foundryOreRate.applyOreBoost(rate, output.getAmount()));
                }
                return output;
            }), this.byproducts.stream()).map(Collections::singletonList).collect(Collectors.toList());
        }
        return this.outputWithByproducts;
    }

    public MeltingRecipe(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
        this.byproducts = byproducts;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer<T extends MeltingRecipe>
    extends AbstractSerializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T createFromJson(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, JsonObject json) {
            return this.factory.create(id, group, input, output, temperature, time, byproducts);
        }

        @Override
        protected T createFromNetwork(class_2960 id, String group, class_1856 input, FluidStack output, int temperature, int time, List<FluidStack> byproducts, class_2540 buffer) {
            return this.factory.create(id, group, input, output, temperature, time, byproducts);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    protected static abstract class AbstractSerializer<T extends MeltingRecipe>
    extends LoggingRecipeSerializer<T> {
        protected AbstractSerializer() {
        }

        protected abstract T createFromJson(class_2960 var1, String var2, class_1856 var3, FluidStack var4, int var5, int var6, List<FluidStack> var7, JsonObject var8);

        protected abstract T createFromNetwork(class_2960 var1, String var2, class_1856 var3, FluidStack var4, int var5, int var6, List<FluidStack> var7, class_2540 var8);

        public T fromJson(class_2960 id, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_1856 input = class_1856.method_52177((JsonElement)json.get("ingredient"));
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            int temperature = class_3518.method_15260((JsonObject)json, (String)"temperature");
            int time = class_3518.method_15260((JsonObject)json, (String)"time");
            if (temperature < 0) {
                throw new JsonSyntaxException("Melting temperature must be greater than zero");
            }
            if (time <= 0) {
                throw new JsonSyntaxException("Melting time must be greater than zero");
            }
            List byproducts = Collections.emptyList();
            if (json.has("byproducts")) {
                byproducts = JsonHelper.parseList((JsonObject)json, (String)"byproducts", RecipeHelper::deserializeFluidStack);
            }
            return this.createFromJson(id, group, input, output, temperature, time, byproducts, json);
        }

        @Nullable
        protected T fromNetworkSafe(class_2960 id, class_2540 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            FluidStack output = FluidStack.readFromPacket((class_2540)buffer);
            int temperature = buffer.readInt();
            int time = buffer.method_10816();
            ImmutableList.Builder builder = ImmutableList.builder();
            int byproductCount = buffer.method_10816();
            for (int i = 0; i < byproductCount; ++i) {
                builder.add((Object)FluidStack.readFromPacket((class_2540)buffer));
            }
            return this.createFromNetwork(id, group, input, output, temperature, time, (List<FluidStack>)builder.build(), buffer);
        }

        protected void toNetworkSafe(class_2540 buffer, T recipe) {
            buffer.method_10814(((MeltingRecipe)recipe).group);
            ((MeltingRecipe)recipe).input.method_8088(buffer);
            ((MeltingRecipe)recipe).output.writeToPacket(buffer);
            buffer.writeInt(((MeltingRecipe)recipe).temperature);
            buffer.method_10804(((MeltingRecipe)recipe).time);
            buffer.method_10804(((MeltingRecipe)recipe).byproducts.size());
            for (FluidStack fluidStack : ((MeltingRecipe)recipe).byproducts) {
                fluidStack.writeToPacket(buffer);
            }
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends MeltingRecipe> {
        public T create(class_2960 var1, String var2, class_1856 var3, FluidStack var4, int var5, int var6, List<FluidStack> var7);
    }
}

