/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1887;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.utils.GenericTagUtil;

public class UpdateModifiersPacket
implements IThreadsafePacket {
    private final Map<ModifierId, Modifier> allModifiers;
    private final Map<class_2960, Collection<Modifier>> tags;
    private Collection<Modifier> modifiers;
    private Map<ModifierId, ModifierId> redirects;
    private final Map<class_1887, Modifier> enchantmentMap;
    private final Map<class_6862<class_1887>, Modifier> enchantmentTagMappings;

    private void ensureCalculated() {
        if (this.modifiers == null || this.redirects == null) {
            ImmutableList.Builder modifiers = ImmutableList.builder();
            ImmutableMap.Builder redirects = ImmutableMap.builder();
            for (Map.Entry<ModifierId, Modifier> entry : this.allModifiers.entrySet()) {
                Modifier mod;
                ModifierId id = entry.getKey();
                if (id.equals((Object)(mod = entry.getValue()).getId())) {
                    modifiers.add((Object)mod);
                    continue;
                }
                redirects.put((Object)id, (Object)mod.getId());
            }
            this.modifiers = modifiers.build();
            this.redirects = redirects.build();
        }
    }

    private static Modifier getModifier(Map<ModifierId, Modifier> modifiers, ModifierId id) {
        Modifier modifier = ModifierManager.INSTANCE.getStatic(id);
        if (modifier == ModifierManager.INSTANCE.getDefaultValue() && (modifier = modifiers.get((Object)id)) == null) {
            throw new DecoderException("Unknown modifier " + id);
        }
        return modifier;
    }

    public UpdateModifiersPacket(class_2540 buffer) {
        int i;
        int size = buffer.method_10816();
        HashMap<ModifierId, Modifier> modifiers = new HashMap<ModifierId, Modifier>();
        for (i = 0; i < size; ++i) {
            ModifierId id2 = new ModifierId(buffer.method_10800(Short.MAX_VALUE));
            Modifier modifier = (Modifier)ModifierManager.MODIFIER_LOADERS.fromNetwork(buffer);
            modifier.setId(id2);
            modifiers.put(id2, modifier);
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            ModifierId from = new ModifierId(buffer.method_10800(Short.MAX_VALUE));
            modifiers.put(from, UpdateModifiersPacket.getModifier(modifiers, new ModifierId(buffer.method_10800(Short.MAX_VALUE))));
        }
        this.allModifiers = modifiers;
        this.tags = GenericTagUtil.decodeTags(buffer, id -> UpdateModifiersPacket.getModifier(modifiers, new ModifierId((class_2960)id)));
        ImmutableMap.Builder enchantmentBuilder = ImmutableMap.builder();
        size = buffer.method_10816();
        for (int i2 = 0; i2 < size; ++i2) {
            enchantmentBuilder.put((Object)Objects.requireNonNull((class_1887)class_7923.field_41176.method_10223(buffer.method_10810())), (Object)UpdateModifiersPacket.getModifier(modifiers, new ModifierId(buffer.method_10810())));
        }
        this.enchantmentMap = enchantmentBuilder.build();
        ImmutableMap.Builder enchantmentTagBuilder = ImmutableMap.builder();
        size = buffer.method_10816();
        for (int i3 = 0; i3 < size; ++i3) {
            enchantmentTagBuilder.put((Object)class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)buffer.method_10810()), (Object)UpdateModifiersPacket.getModifier(modifiers, new ModifierId(buffer.method_10810())));
        }
        this.enchantmentTagMappings = enchantmentTagBuilder.build();
    }

    public void encode(class_2540 buffer) {
        this.ensureCalculated();
        buffer.method_10804(this.modifiers.size());
        for (Modifier modifier : this.modifiers) {
            buffer.method_10812((class_2960)modifier.getId());
            ModifierManager.MODIFIER_LOADERS.toNetwork((GenericLoaderRegistry.IHaveLoader)modifier, buffer);
        }
        buffer.method_10804(this.redirects.size());
        for (Map.Entry entry : this.redirects.entrySet()) {
            buffer.method_10812((class_2960)entry.getKey());
            buffer.method_10812((class_2960)entry.getValue());
        }
        GenericTagUtil.encodeTags(buffer, Modifier::getId, this.tags);
        buffer.method_10804(this.enchantmentMap.size());
        for (Map.Entry entry : this.enchantmentMap.entrySet()) {
            buffer.method_10812(class_7923.field_41176.method_10221((Object)((class_1887)entry.getKey())));
            buffer.method_10812((class_2960)((Modifier)entry.getValue()).getId());
        }
        buffer.method_10804(this.enchantmentTagMappings.size());
        for (Map.Entry entry : this.enchantmentTagMappings.entrySet()) {
            buffer.method_10812(((class_6862)entry.getKey()).comp_327());
            buffer.method_10812((class_2960)((Modifier)entry.getValue()).getId());
        }
    }

    public void handleThreadsafe(ISimplePacket.Context context) {
        ModifierManager.INSTANCE.updateModifiersFromServer(this.allModifiers, this.tags, this.enchantmentMap, this.enchantmentTagMappings);
    }

    public UpdateModifiersPacket(Map<ModifierId, Modifier> allModifiers, Map<class_2960, Collection<Modifier>> tags, Map<class_1887, Modifier> enchantmentMap, Map<class_6862<class_1887>, Modifier> enchantmentTagMappings) {
        this.allModifiers = allModifiers;
        this.tags = tags;
        this.enchantmentMap = enchantmentMap;
        this.enchantmentTagMappings = enchantmentTagMappings;
    }
}

