/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2893;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5483;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_6012;
import net.minecraft.class_6885;
import net.minecraft.class_7061;
import net.minecraft.class_7151;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.util.ConfigurableSpawns;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.LandmarkStructure;

public class HollowHillStructure
extends LandmarkStructure
implements ConfigurableSpawns {
    public static final Codec<HollowHillStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)3).fieldOf("hill_size").forGetter(s -> s.size), (App)ControlledSpawns.ControlledSpawningConfig.FLAT_CODEC.forGetter(s -> s.controlledSpawningConfig)).and(HollowHillStructure.landmarkCodec(instance)).apply((Applicative)instance, HollowHillStructure::new));
    private final int size;
    private final ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig;

    public HollowHillStructure(int size, ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, DecorationClearance.DecorationConfig decorationConfig, class_3195.class_7302 structureSettings) {
        super(decorationConfig, structureSettings);
        this.size = size;
        this.controlledSpawningConfig = controlledSpawningConfig;
    }

    public boolean canSpawnMob(class_2338 spawnPos, class_3341 structureStartBox) {
        float hZ;
        float hY;
        float hX = class_3532.method_37960((float)spawnPos.method_10263(), (float)structureStartBox.method_35415(), (float)structureStartBox.method_35418()) * 2.0f - 1.0f;
        return class_3532.method_33825((double)hX, (double)(hY = class_3532.method_37960((float)spawnPos.method_10264(), (float)structureStartBox.method_35416(), (float)structureStartBox.method_35419())), (double)(hZ = class_3532.method_37960((float)spawnPos.method_10260(), (float)structureStartBox.method_35417(), (float)structureStartBox.method_35420()) * 2.0f - 1.0f)) < (double)0.975f;
    }

    @Override
    protected class_3443 getFirstPiece(class_3195.class_7149 context, class_5819 random, class_1923 chunkPos, int x, int y, int z) {
        return switch (this.size) {
            case 1 -> new HollowHillComponent((class_3773)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 3, y - 2, z - 3);
            case 2 -> new HollowHillComponent((class_3773)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 7, y - 5, z - 7);
            default -> new HollowHillComponent((class_3773)TFStructurePieceTypes.TFHill.get(), 0, this.size, x - 11, y - 5, z - 11);
        };
    }

    public class_7151<?> method_41618() {
        return (class_7151)TFStructureTypes.HOLLOW_HILL.get();
    }

    @Override
    public ControlledSpawns.ControlledSpawningConfig getConfig() {
        return this.controlledSpawningConfig;
    }

    public static HollowHillStructure buildSmallHillConfig(class_7891<class_3195> context) {
        return new HollowHillStructure(1, ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new class_5483.class_1964(class_1299.field_6079, 10, 4, 4), new class_5483.class_1964(class_1299.field_6051, 10, 4, 4), new class_5483.class_1964((class_1299)TFEntities.REDCAP.get(), 10, 4, 4), new class_5483.class_1964((class_1299)TFEntities.SWARM_SPIDER.get(), 10, 4, 4), new class_5483.class_1964((class_1299)TFEntities.KOBOLD.get(), 10, 4, 8))), List.of(), List.of()), new DecorationClearance.DecorationConfig(1, true, false, false), new class_3195.class_7302((class_6885)context.method_46799(class_7924.field_41236).method_46735(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Arrays.stream(class_1311.values()).collect(Collectors.toMap(category -> category, category -> new class_7061(class_7061.class_7062.field_37200, class_6012.method_34990()))), class_2893.class_2895.field_13173, class_5847.field_28922));
    }

    public static HollowHillStructure buildMediumHillConfig(class_7891<class_3195> context) {
        return new HollowHillStructure(2, ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new class_5483.class_1964((class_1299)TFEntities.REDCAP.get(), 10, 1, 2), new class_5483.class_1964((class_1299)TFEntities.REDCAP_SAPPER.get(), 1, 1, 2), new class_5483.class_1964((class_1299)TFEntities.KOBOLD.get(), 10, 2, 4), new class_5483.class_1964(class_1299.field_6137, 10, 2, 3), new class_5483.class_1964((class_1299)TFEntities.SWARM_SPIDER.get(), 10, 2, 4), new class_5483.class_1964(class_1299.field_6079, 10, 1, 3), new class_5483.class_1964(class_1299.field_6046, 10, 1, 2), new class_5483.class_1964((class_1299)TFEntities.FIRE_BEETLE.get(), 5, 1, 1), new class_5483.class_1964((class_1299)TFEntities.SLIME_BEETLE.get(), 5, 1, 1), new class_5483.class_1964(class_1299.field_6145, 1, 1, 1))), List.of(), List.of()), new DecorationClearance.DecorationConfig(2, true, false, false), new class_3195.class_7302((class_6885)context.method_46799(class_7924.field_41236).method_46735(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Arrays.stream(class_1311.values()).collect(Collectors.toMap(category -> category, category -> new class_7061(class_7061.class_7062.field_37200, class_6012.method_34990()))), class_2893.class_2895.field_13173, class_5847.field_28922));
    }

    public static HollowHillStructure buildLargeHillConfig(class_7891<class_3195> context) {
        return new HollowHillStructure(3, ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new class_5483.class_1964((class_1299)TFEntities.REDCAP.get(), 10, 2, 4), new class_5483.class_1964((class_1299)TFEntities.REDCAP_SAPPER.get(), 2, 1, 2), new class_5483.class_1964(class_1299.field_6137, 10, 2, 3), new class_5483.class_1964(class_1299.field_6084, 10, 1, 2), new class_5483.class_1964(class_1299.field_6046, 10, 1, 1), new class_5483.class_1964(class_1299.field_6091, 1, 1, 1), new class_5483.class_1964((class_1299)TFEntities.WRAITH.get(), 2, 1, 2), new class_5483.class_1964((class_1299)TFEntities.FIRE_BEETLE.get(), 10, 1, 2), new class_5483.class_1964((class_1299)TFEntities.SLIME_BEETLE.get(), 10, 1, 2), new class_5483.class_1964((class_1299)TFEntities.PINCH_BEETLE.get(), 10, 1, 2), new class_5483.class_1964(class_1299.field_6145, 1, 1, 1)), new DecorationClearance.DecorationConfig(3, true, false, false), new class_3195.class_7302((class_6885)context.method_46799(class_7924.field_41236).method_46735(BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES), Arrays.stream(class_1311.values()).collect(Collectors.toMap(category -> category, category -> new class_7061(class_7061.class_7062.field_37200, class_6012.method_34990()))), class_2893.class_2895.field_13173, class_5847.field_28922));
    }
}

